/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.transaction;

import java.util.HashMap;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.transaction.TransactionFactory;
import org.apache.ojb.otm.transaction.TransactionFactoryException;

public class LocalTransactionFactory
implements TransactionFactory {
    private HashMap _transactionMap = new HashMap();

    public Transaction getTransactionForConnection(OTMConnection connection) {
        if (!(connection instanceof BaseConnection)) {
            StringBuffer msg = new StringBuffer();
            msg.append("Unknown connection type: ");
            if (connection != null) {
                msg.append(connection.getClass().getName());
            } else {
                msg.append(" null. Make sure you pass a non-null OTMConnection to this method. An OTMConnection can be acquired by calling acquireConnection (PBKey pbKey)");
            }
            throw new TransactionFactoryException(msg.toString());
        }
        Transaction tx = (Transaction)this._transactionMap.get(connection);
        if (tx == null) {
            tx = new Transaction();
            this._transactionMap.put(connection, tx);
        }
        tx.registerConnection(connection);
        return tx;
    }

    public OTMConnection acquireConnection(PBKey pbKey) {
        LocalConnection newConnection = new LocalConnection(pbKey);
        this.getTransactionForConnection(newConnection);
        return newConnection;
    }

    private static class LocalConnection
    extends BaseConnection {
        public LocalConnection(PBKey pbKey) {
            super(pbKey);
        }

        public void transactionBegin() throws TransactionException {
            this.getKernelBroker().beginTransaction();
        }

        public void transactionPrepare() throws TransactionException {
        }

        public void transactionCommit() throws TransactionException {
            this.getKernelBroker().commitTransaction();
        }

        public void transactionRollback() throws TransactionException {
            this.getKernelBroker().abortTransaction();
        }
    }
}

