/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.cache.MaterializationCache;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.VirtualProxy;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RsIterator
implements OJBIterator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INFO_MSG = "Resources already cleaned up, recommend to set this flag before first use of the iterator";
    private PBLifeCycleEvent afterLookupEvent;
    private MaterializationCache m_cache;
    private PersistenceBrokerImpl m_broker;
    private ResultSetAndStatement m_rsAndStmt;
    private RsQueryObject m_queryObject;
    private Class m_itemProxyClass;
    private Class m_itemTopLevelClass = null;
    private Map m_row = null;
    private boolean m_hasCalledCheck = false;
    private boolean m_inBatchedMode = false;
    private boolean hasNext = false;
    private boolean advancedJDBCSupport = false;
    private boolean JDBCSupportAssessed = false;
    private int m_current_row = 0;
    private boolean resourcesAreReleased = false;
    private boolean autoRelease = true;

    public RsIterator(RsQueryObject queryObject, PersistenceBrokerImpl broker) {
        this.setCache(broker.getInternalCache());
        this.setRow(new HashMap());
        this.setBroker(broker);
        this.setQueryObject(queryObject);
        Class classToPrefetch = broker.getReferenceBroker().getClassToPrefetch();
        if (classToPrefetch != null && classToPrefetch.isAssignableFrom(queryObject.getClassDescriptor().getClassOfObject())) {
            this.setItemProxyClass(null);
        } else {
            this.setItemProxyClass(queryObject.getClassDescriptor().getProxyClass());
        }
        this.setAfterLookupEvent(new PBLifeCycleEvent(this.getBroker(), PBLifeCycleEvent.Type.AFTER_LOOKUP));
        try {
            this.setRsAndStmt(queryObject.performQuery(broker.serviceJdbcAccess()));
            this.prefetchRelationships(queryObject.getQuery());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("RsIterator[" + queryObject + "] initialized");
            }
        }
        catch (RuntimeException e) {
            this.autoReleaseDbResources();
            throw e;
        }
        this.m_broker.addListener(new ResourceWrapper(this));
    }

    protected Class getTopLevelClass() {
        if (this.m_itemTopLevelClass == null) {
            this.m_itemTopLevelClass = this.getBroker().getTopLevelClass(this.getQueryObject().getClassDescriptor().getClassOfObject());
        }
        return this.m_itemTopLevelClass;
    }

    public synchronized boolean hasNext() {
        try {
            if (!this.isHasCalledCheck()) {
                this.setHasCalledCheck(true);
                this.setHasNext(this.getRsAndStmt().m_rs.next());
                if (!this.getHasNext()) {
                    this.autoReleaseDbResources();
                }
            }
        }
        catch (Exception ex) {
            this.setHasNext(false);
            this.autoReleaseDbResources();
            if (ex instanceof ResourceClosedException) {
                throw (ResourceClosedException)((Object)ex);
            }
            if (ex instanceof SQLException) {
                throw new PersistenceBrokerSQLException("Calling ResultSet.next() failed", (SQLException)ex);
            }
            throw new PersistenceBrokerException("Can't get next row from ResultSet", ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("hasNext() -> " + this.getHasNext());
        }
        return this.getHasNext();
    }

    public synchronized Object next() throws NoSuchElementException {
        try {
            if (!this.isHasCalledCheck()) {
                this.hasNext();
            }
            this.setHasCalledCheck(false);
            if (this.getHasNext()) {
                Object obj = this.getObjectFromResultSet();
                ++this.m_current_row;
                this.getAfterLookupEvent().setTarget(obj);
                this.getBroker().fireBrokerEvent(this.getAfterLookupEvent());
                this.getAfterLookupEvent().setTarget(null);
                return obj;
            }
            throw new NoSuchElementException("inner hasNext was false");
        }
        catch (ResourceClosedException ex) {
            this.autoReleaseDbResources();
            throw ex;
        }
        catch (NoSuchElementException ex) {
            this.autoReleaseDbResources();
            this.logger.error("Error while iterate ResultSet for query " + this.m_queryObject, ex);
            throw new NoSuchElementException("Could not obtain next object: " + ex.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("removing not supported by RsIterator");
    }

    private Collection getOwnerObjects() {
        Vector<Object> owners = new Vector<Object>();
        while (this.hasNext()) {
            owners.add(this.next());
        }
        return owners;
    }

    private void prefetchRelationships(Query query) {
        int i;
        if (query == null || query.getPrefetchedRelationships() == null || query.getPrefetchedRelationships().isEmpty()) {
            return;
        }
        if (!this.supportsAdvancedJDBCCursorControl()) {
            this.logger.info("prefetching relationships requires JDBC level 2.0");
            return;
        }
        this.setInBatchedMode(true);
        List prefetchedRel = query.getPrefetchedRelationships();
        RelationshipPrefetcher[] prefetchers = new RelationshipPrefetcher[prefetchedRel.size()];
        for (i = 0; i < prefetchedRel.size(); ++i) {
            String relName = (String)prefetchedRel.get(i);
            prefetchers[i] = this.getBroker().getRelationshipPrefetcherFactory().createRelationshipPrefetcher(this.getQueryObject().getClassDescriptor(), relName);
            prefetchers[i].prepareRelationshipSettings();
        }
        Collection owners = this.getOwnerObjects();
        for (i = 0; i < prefetchedRel.size(); ++i) {
            prefetchers[i].prefetchRelationship(owners);
        }
        for (i = 0; i < prefetchedRel.size(); ++i) {
            prefetchers[i].restoreRelationshipSettings();
        }
        try {
            this.getRsAndStmt().m_rs.beforeFirst();
        }
        catch (SQLException e) {
            this.logger.error("beforeFirst failed !", e);
        }
        this.setInBatchedMode(false);
        this.setHasCalledCheck(false);
    }

    protected Identity getIdentityFromResultSet() throws PersistenceBrokerException {
        FieldDescriptor[] pkFields = this.getQueryObject().getClassDescriptor().getPkFields();
        Object[] pkValues = new Object[pkFields.length];
        for (int i = 0; i < pkFields.length; ++i) {
            FieldDescriptor fld = pkFields[i];
            pkValues[i] = this.getRow().get(fld.getColumnName());
        }
        return new Identity(this.getQueryObject().getClassDescriptor().getClassOfObject(), this.getTopLevelClass(), pkValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        this.getRow().clear();
        this.getQueryObject().getClassDescriptor().getRowReader().readPkValuesFrom(this.getRsAndStmt().m_rs, this.getRow());
        if (this.getItemProxyClass() != null) {
            return this.getProxyFromResultSet();
        }
        Identity oid = this.getIdentityFromResultSet();
        Object result = null;
        result = this.getCache().lookup(oid);
        if (result == null) {
            this.getQueryObject().getClassDescriptor().getRowReader().readObjectArrayFrom(this.getRsAndStmt().m_rs, this.getRow());
            result = this.getQueryObject().getClassDescriptor().getRowReader().readObjectFrom(this.getRow());
            if (result != null) {
                Object object = result;
                synchronized (object) {
                    this.getCache().enableMaterializationCache();
                    try {
                        this.getCache().doInternalCache(oid, result, 11);
                        ClassDescriptor cld = this.getBroker().getClassDescriptor(result.getClass());
                        boolean unforced = false;
                        this.getBroker().getReferenceBroker().retrieveReferences(result, cld, false);
                        this.getBroker().getReferenceBroker().retrieveCollections(result, cld, false);
                        this.getCache().disableMaterializationCache();
                    }
                    catch (RuntimeException e) {
                        this.getCache().doLocalClear();
                        throw e;
                    }
                }
            }
        } else {
            ClassDescriptor cld = this.getBroker().getClassDescriptor(result.getClass());
            if (cld.isAlwaysRefresh()) {
                this.getQueryObject().getClassDescriptor().getRowReader().readObjectArrayFrom(this.getRsAndStmt().m_rs, this.getRow());
                this.getQueryObject().getClassDescriptor().getRowReader().refreshObject(result, this.getRow());
            }
            this.getBroker().refreshRelationships(result, cld);
        }
        return result;
    }

    protected Object getProxyFromResultSet() throws PersistenceBrokerException {
        Identity oid = this.getIdentityFromResultSet();
        return VirtualProxy.createProxy(this.getBroker().getPBKey(), this.getItemProxyClass(), oid);
    }

    private boolean supportsAdvancedJDBCCursorControl() {
        if (!this.JDBCSupportAssessed) {
            if (this.getConnectionDescriptor().getJdbcLevel() >= 2.0) {
                this.advancedJDBCSupport = true;
            }
            this.JDBCSupportAssessed = true;
        }
        return this.advancedJDBCSupport;
    }

    protected int countedSize() throws PersistenceBrokerException {
        ResultSetAndStatement rsStmt;
        Query countQuery = this.getBroker().serviceBrokerHelper().getCountQuery(this.getQueryObject().getQuery());
        ClassDescriptor cld = this.getQueryObject().getClassDescriptor();
        int count = 0;
        if (countQuery instanceof QueryBySQL) {
            String countSql = ((QueryBySQL)countQuery).getSql();
            rsStmt = this.getBroker().serviceJdbcAccess().executeSQL(countSql, cld, false);
        } else {
            rsStmt = this.getBroker().serviceJdbcAccess().executeQuery(countQuery, cld);
        }
        try {
            if (rsStmt.m_rs.next()) {
                count = rsStmt.m_rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException(e);
        }
        finally {
            rsStmt.close();
        }
        return count;
    }

    public int size() throws PersistenceBrokerException {
        int retval = 0;
        boolean forwardOnly = true;
        try {
            forwardOnly = this.getRsAndStmt().m_stmt.getResultSetType() == 1003;
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (!this.supportsAdvancedJDBCCursorControl() || this.getBroker().serviceConnectionManager().getSupportedPlatform().useCountForResultsetSize() || forwardOnly) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing count(*) to get size()");
            }
            retval = this.countedSize();
        } else {
            int whereIAm = 1;
            try {
                if (this.getRsAndStmt().m_rs != null) {
                    whereIAm = this.getRsAndStmt().m_rs.getRow();
                    retval = this.getRsAndStmt().m_rs.last() ? this.getRsAndStmt().m_rs.getRow() : 0;
                    if (whereIAm > 0) {
                        this.getRsAndStmt().m_rs.absolute(whereIAm);
                    } else {
                        this.getRsAndStmt().m_rs.beforeFirst();
                    }
                }
            }
            catch (SQLException se) {
                this.advancedJDBCSupport = false;
            }
        }
        return retval;
    }

    public int fullSize() throws PersistenceBrokerException {
        return this.size();
    }

    public boolean absolute(int row) throws PersistenceBrokerException {
        boolean retval;
        block11: {
            retval = false;
            if (this.supportsAdvancedJDBCCursorControl()) {
                try {
                    if (this.getRsAndStmt().m_rs != null) {
                        retval = this.getRsAndStmt().m_rs.absolute(row);
                        this.m_current_row = row;
                        this.setHasCalledCheck(false);
                    }
                }
                catch (SQLException e) {
                    this.advancedJDBCSupport = false;
                }
            } else if (row > this.m_current_row) {
                try {
                    while (this.m_current_row < row && this.getRsAndStmt().m_rs.next()) {
                        ++this.m_current_row;
                    }
                    if (this.m_current_row == row) {
                        retval = true;
                        break block11;
                    }
                    this.setHasCalledCheck(true);
                    this.setHasNext(false);
                    retval = false;
                    this.autoReleaseDbResources();
                }
                catch (Exception ex) {
                    this.setHasCalledCheck(true);
                    this.setHasNext(false);
                    retval = false;
                }
            } else {
                this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call absolute() with a position < current");
            }
        }
        return retval;
    }

    public boolean relative(int row) throws PersistenceBrokerException {
        boolean retval = false;
        if (this.supportsAdvancedJDBCCursorControl()) {
            try {
                if (this.getRsAndStmt().m_rs != null) {
                    retval = this.getRsAndStmt().m_rs.relative(row);
                    this.m_current_row += row;
                }
            }
            catch (SQLException e) {
                this.advancedJDBCSupport = false;
            }
        } else {
            if (row >= 0) {
                return this.absolute(this.m_current_row + row);
            }
            this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call relative() with a negative value");
        }
        return retval;
    }

    public void releaseDbResources() {
        if (!this.isInBatchedMode() && !this.resourcesAreReleased) {
            this.resourcesAreReleased = true;
            if (this.m_rsAndStmt != null) {
                this.m_rsAndStmt.close();
                this.m_rsAndStmt = null;
            }
        }
    }

    protected void autoReleaseDbResources() {
        if (this.autoRelease) {
            this.releaseDbResources();
        }
    }

    public void setAutoRelease(boolean autoRelease) {
        if (this.resourcesAreReleased && !autoRelease) {
            this.logger.info(INFO_MSG);
        }
        this.autoRelease = autoRelease;
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    protected JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.getBroker().serviceConnectionManager().getConnectionDescriptor();
    }

    protected void finalize() {
        if (this.m_rsAndStmt != null) {
            this.logger.info("Found unclosed resources while finalize (causer class: " + this.getClass().getName() + ")" + " Do automatic cleanup");
            this.releaseDbResources();
        }
    }

    public String toString() {
        return super.toString();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.getQueryObject().getClassDescriptor();
    }

    protected void setBroker(PersistenceBrokerImpl broker) {
        this.m_broker = broker;
    }

    protected PersistenceBrokerImpl getBroker() {
        return this.m_broker;
    }

    protected void setRsAndStmt(ResultSetAndStatement rsAndStmt) {
        if (this.m_rsAndStmt != null) {
            throw new ResourceNotClosedException("Unclosed resources found, please release resources before set new ones");
        }
        this.resourcesAreReleased = false;
        this.m_rsAndStmt = rsAndStmt;
    }

    protected ResultSetAndStatement getRsAndStmt() {
        if (this.resourcesAreReleased) {
            throw new ResourceClosedException("Resources no longer reachable, RsIterator will be automatic cleaned up on PB.close/.commitTransaction/.abortTransaction");
        }
        return this.m_rsAndStmt;
    }

    protected void setQueryObject(RsQueryObject queryObject) {
        this.m_queryObject = queryObject;
    }

    protected RsQueryObject getQueryObject() {
        return this.m_queryObject;
    }

    protected void setItemProxyClass(Class itemProxyClass) {
        this.m_itemProxyClass = itemProxyClass;
    }

    protected Class getItemProxyClass() {
        return this.m_itemProxyClass;
    }

    protected void setRow(Map row) {
        this.m_row = row;
    }

    protected Map getRow() {
        return this.m_row;
    }

    protected void setCache(MaterializationCache cache) {
        this.m_cache = cache;
    }

    protected MaterializationCache getCache() {
        return this.m_cache;
    }

    protected void setAfterLookupEvent(PBLifeCycleEvent afterLookupEvent) {
        this.afterLookupEvent = afterLookupEvent;
    }

    protected PBLifeCycleEvent getAfterLookupEvent() {
        return this.afterLookupEvent;
    }

    protected void setHasCalledCheck(boolean hasCalledCheck) {
        this.m_hasCalledCheck = hasCalledCheck;
    }

    protected boolean isHasCalledCheck() {
        return this.m_hasCalledCheck;
    }

    protected void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    protected boolean getHasNext() {
        return this.hasNext;
    }

    protected void setInBatchedMode(boolean inBatchedMode) {
        this.m_inBatchedMode = inBatchedMode;
    }

    protected boolean isInBatchedMode() {
        return this.m_inBatchedMode;
    }

    public static class ResourceNotClosedException
    extends OJBRuntimeException {
        public ResourceNotClosedException(String msg) {
            super(msg);
        }

        public ResourceNotClosedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class ResourceClosedException
    extends OJBRuntimeException {
        public ResourceClosedException(String msg) {
            super(msg);
        }

        public ResourceClosedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class ResourceWrapper
    implements PBStateListener {
        WeakReference ref;

        public ResourceWrapper(RsIterator rs) {
            this.ref = new WeakReference<RsIterator>(rs);
        }

        public void beforeClose(PBStateEvent event) {
            if (this.ref != null) {
                RsIterator rs = (RsIterator)this.ref.get();
                if (rs != null) {
                    rs.releaseDbResources();
                }
                this.ref = null;
            }
        }

        public void beforeRollback(PBStateEvent event) {
            if (this.ref != null) {
                RsIterator rs = (RsIterator)this.ref.get();
                if (rs != null) {
                    rs.releaseDbResources();
                }
                this.ref = null;
            }
        }

        public void beforeCommit(PBStateEvent event) {
            if (this.ref != null) {
                RsIterator rs = (RsIterator)this.ref.get();
                if (rs != null) {
                    rs.releaseDbResources();
                }
                this.ref = null;
            }
        }

        public void afterCommit(PBStateEvent event) {
        }

        public void afterRollback(PBStateEvent event) {
        }

        public void afterBegin(PBStateEvent event) {
        }

        public void beforeBegin(PBStateEvent event) {
        }

        public void afterOpen(PBStateEvent event) {
        }
    }
}

