/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCacheInternal,
PBStateListener {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheDefaultImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl);
    public static final String TIMEOUT_PROP = "timeout";
    public static final String AUTOSYNC_PROP = "autoSync";
    public static final String CACHING_KEY_TYPE_PROP = "cachingKeyType";
    public static final String SOFT_REFERENCES_PROP = "useSoftReferences";
    protected static Map objectTable = new Hashtable();
    private static ReferenceQueue queue = new ReferenceQueue();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    protected PersistenceBroker broker;
    private List identitiesInWork;
    private long timeout = 900000L;
    private boolean useAutoSync = false;
    private int cachingKeyType;
    private boolean useSoftReferences = true;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;

    public ObjectCacheDefaultImpl(PersistenceBroker broker, Properties prop) {
        this.broker = broker;
        this.timeout = prop == null ? this.timeout : Long.parseLong(prop.getProperty(TIMEOUT_PROP, "900")) * 1000L;
        this.useSoftReferences = prop == null ? false : Boolean.valueOf(prop.getProperty(SOFT_REFERENCES_PROP, "true").trim());
        this.cachingKeyType = prop == null ? 0 : Integer.parseInt(prop.getProperty(CACHING_KEY_TYPE_PROP, "0"));
        boolean bl = this.useAutoSync = prop == null ? false : Boolean.valueOf(prop.getProperty(AUTOSYNC_PROP, "false").trim());
        if (this.useAutoSync) {
            if (broker != null) {
                broker.addListener(this, true);
            } else {
                this.log.info("Can't enable property 'autoSync', because given PB instance is null");
            }
        }
        this.identitiesInWork = new ArrayList();
        if (this.log.isEnabledFor(2)) {
            ToStringBuilder buf = new ToStringBuilder((Object)this);
            buf.append(TIMEOUT_PROP, this.timeout).append(SOFT_REFERENCES_PROP, this.useSoftReferences).append(CACHING_KEY_TYPE_PROP, this.cachingKeyType).append("useAutoSync", this.useAutoSync);
            this.log.info("Setup cache: " + buf.toString());
        }
    }

    public void clear() {
        this.processQueue();
        objectTable.clear();
        this.identitiesInWork.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInternalCache(Identity oid, Object obj, int type) {
        this.processQueue();
        if (obj != null) {
            Map map = objectTable;
            synchronized (map) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cache object " + oid);
                }
                this.traceIdentity(oid);
                objectTable.put(this.buildKey(oid), this.buildEntry(obj, oid));
            }
        }
    }

    public void cache(Identity oid, Object obj) {
        this.doInternalCache(oid, obj, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheIfNew(Identity oid, Object obj) {
        this.processQueue();
        boolean result = false;
        Object key = this.buildKey(oid);
        if (obj != null) {
            Map map = objectTable;
            synchronized (map) {
                if (!objectTable.containsKey(key)) {
                    this.traceIdentity(oid);
                    objectTable.put(key, this.buildEntry(obj, oid));
                    result = true;
                }
            }
        }
        return result;
    }

    public Object lookup(Identity oid) {
        this.processQueue();
        ++hitCount;
        Object result = null;
        CacheEntry entry = (CacheEntry)objectTable.get(this.buildKey(oid));
        if (entry != null) {
            result = entry.get();
            if (result == null || entry.getLifetime() < System.currentTimeMillis()) {
                ++gcCount;
                this.remove(oid);
                result = null;
            } else {
                this.traceIdentity(oid);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Object match " + oid);
                }
            }
        } else {
            ++failCount;
        }
        return result;
    }

    public void remove(Identity oid) {
        this.processQueue();
        if (oid != null) {
            this.removeTracedIdentity(oid);
            objectTable.remove(this.buildKey(oid));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Remove object " + oid);
            }
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("Count of cached objects", objectTable.keySet().size());
        buf.append("Lookup hits", hitCount);
        buf.append("Failures", failCount);
        buf.append("Reclaimed", gcCount);
        return buf.toString();
    }

    protected void finalize() {
        this.log.debug("Finalize ObjectCache: " + this.toString());
    }

    private void traceIdentity(Identity oid) {
        if (this.useAutoSync && this.broker != null && this.broker.isInTransaction()) {
            this.identitiesInWork.add(oid);
        }
    }

    private void removeTracedIdentity(Identity oid) {
        this.identitiesInWork.remove(oid);
    }

    private void synchronizeWithTracedObjects() {
        this.log.info("tx was aborted, remove " + this.identitiesInWork.size() + " traced (potentially modified) objects from cache");
        Iterator iterator = this.identitiesInWork.iterator();
        while (iterator.hasNext()) {
            Identity oid = (Identity)iterator.next();
            objectTable.remove(this.buildKey(oid));
        }
    }

    public void beforeRollback(PBStateEvent event) {
        this.synchronizeWithTracedObjects();
    }

    public void beforeCommit(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void beforeClose(PBStateEvent event) {
        this.identitiesInWork.clear();
    }

    public void afterRollback(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterOpen(PBStateEvent event) {
    }

    private CacheEntry buildEntry(Object obj, Identity oid) {
        if (this.useSoftReferences) {
            return new CacheEntrySoft(obj, oid, queue);
        }
        return new CacheEntryHard(obj, oid);
    }

    private void processQueue() {
        CacheEntry sv;
        while ((sv = (CacheEntry)((Object)queue.poll())) != null) {
            this.removeTracedIdentity(sv.getOid());
            objectTable.remove(this.buildKey(sv.getOid()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object buildKey(Identity oid) {
        void var2_2;
        switch (this.cachingKeyType) {
            case 0: {
                Object key = oid;
                break;
            }
            case 1: {
                Object key = new OrderedTuple(oid, this.broker.getPBKey().getAlias());
                break;
            }
            case 2: {
                Object key = new OrderedTuple(oid, new Integer(this.broker.getDescriptorRepository().hashCode()));
                break;
            }
            case 3: {
                Object key = new OrderedTuple(oid, this.broker.getPBKey().getAlias(), new Integer(this.broker.getDescriptorRepository().hashCode()));
                break;
            }
            default: {
                throw new OJBRuntimeException("Unexpected error, 'cacheType =" + this.cachingKeyType + "' was not supported");
            }
        }
        return var2_2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CacheEntryHard
    implements CacheEntry {
        private final long lifetime;
        private final Identity oid;
        private Object obj;

        CacheEntryHard(Object object, Identity k) {
            this.obj = object;
            this.oid = k;
            this.lifetime = ObjectCacheDefaultImpl.this.timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }

        public Object get() {
            return this.obj;
        }

        public Identity getOid() {
            return this.oid;
        }

        public long getLifetime() {
            return this.lifetime;
        }
    }

    class CacheEntrySoft
    extends SoftReference
    implements CacheEntry {
        private final long lifetime;
        private final Identity oid;

        CacheEntrySoft(Object object, Identity k, ReferenceQueue q) {
            super(object, q);
            this.oid = k;
            this.lifetime = ObjectCacheDefaultImpl.this.timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }

        public Identity getOid() {
            return this.oid;
        }

        public long getLifetime() {
            return this.lifetime;
        }
    }

    static interface CacheEntry {
        public Object get();

        public Identity getOid();

        public long getLifetime();
    }

    static final class OrderedTuple {
        private static int[] multipliers = new int[]{13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 51};
        private Object[] elements;
        private int hashCode;

        public OrderedTuple(Object element) {
            this.elements = new Object[1];
            this.elements[0] = element;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object element1, Object element2) {
            this.elements = new Object[2];
            this.elements[0] = element1;
            this.elements[1] = element2;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object element1, Object element2, Object element3) {
            this.elements = new Object[3];
            this.elements[0] = element1;
            this.elements[1] = element2;
            this.elements[2] = element3;
            this.hashCode = this.calcHashCode();
        }

        public OrderedTuple(Object[] elements) {
            this.elements = elements;
            this.hashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            int code = 7;
            for (int i = 0; i < this.elements.length; ++i) {
                int m = i % multipliers.length;
                code += this.elements[i].hashCode() * multipliers[m];
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrderedTuple)) {
                return false;
            }
            OrderedTuple other = (OrderedTuple)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (this.elements.length != other.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(other.elements[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append('{');
            for (int i = 0; i < this.elements.length; ++i) {
                s.append(this.elements[i]).append('#').append(this.elements[i].hashCode()).append(',');
            }
            s.setCharAt(s.length() - 1, '}');
            s.append("#").append(this.hashCode);
            return s.toString();
        }
    }
}

