/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.access.exception.ObjectExistsException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class ObjectCacheJCSImpl
implements ObjectCache {
    public static final String DEFAULT_REGION = "ojbDefaultJCSRegion";
    private JCS jcsCache;
    private String regionName = "ojbDefaultJCSRegion";

    public ObjectCacheJCSImpl(PersistenceBroker broker, Properties prop) {
        this(null);
    }

    public ObjectCacheJCSImpl(String name) {
        this.regionName = name != null ? name : DEFAULT_REGION;
        try {
            this.jcsCache = JCS.getInstance((String)this.regionName);
        }
        catch (Exception e) {
            throw new RuntimeCacheException("Can't instantiate JCS ObjectCacheImplementation", e);
        }
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void cache(Identity oid, Object obj) {
        try {
            this.jcsCache.put((Object)oid.toString(), obj);
        }
        catch (CacheException e) {
            throw new RuntimeCacheException(e);
        }
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        boolean result = false;
        try {
            this.jcsCache.putSafe((Object)oid.toString(), obj);
            result = true;
        }
        catch (ObjectExistsException e) {
        }
        catch (CacheException e) {
            throw new RuntimeCacheException(e);
        }
        return result;
    }

    public Object lookup(Identity oid) {
        return this.jcsCache.get((Object)oid.toString());
    }

    public void remove(Identity oid) {
        try {
            this.jcsCache.remove((Object)oid.toString());
        }
        catch (CacheException e) {
            throw new RuntimeCacheException(e.getMessage());
        }
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.remove();
            }
            catch (CacheException e) {
                throw new RuntimeCacheException(e);
            }
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("JCS region name", (Object)this.regionName);
        buf.append("JCS region", (Object)this.jcsCache);
        return buf.toString();
    }
}

