/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.ClassHelper;

public class FieldDescriptor
extends AttributeDescriptorBase
implements XmlCapable,
Serializable {
    private static final long serialVersionUID = 7865777758296851949L;
    public static final String ACCESS_ANONYMOUS = "anonymous";
    public static final String ACCESS_READONLY = "readonly";
    public static final String ACCESS_READWRITE = "readwrite";
    private int m_ColNo;
    private String m_ColumnName;
    private String m_ColumnType;
    private boolean m_IsKeyField = false;
    private boolean indexed = false;
    private boolean m_autoIncrement = false;
    private String m_sequenceName;
    private JdbcType m_jdbcType;
    private int length = 0;
    private int precision = 0;
    private int scale = 0;
    private boolean required = false;
    private boolean scaleSpecified = false;
    private boolean precisionSpecified = false;
    private boolean lengthSpecified = false;
    private FieldConversion fieldConversion = null;
    private boolean m_locking = false;
    private boolean updateLock = true;
    private String m_access;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl;

    public static Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                FieldDescriptor fmd1 = (FieldDescriptor)o1;
                FieldDescriptor fmd2 = (FieldDescriptor)o2;
                if (fmd1.getColNo() < fmd2.getColNo()) {
                    return -1;
                }
                if (fmd1.getColNo() > fmd2.getColNo()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public FieldDescriptor(ClassDescriptor cld, int id) {
        super(cld);
        this.m_ColNo = id;
    }

    public String getColumnName() {
        return this.m_ColumnName;
    }

    public String getFullColumnName() {
        return this.getClassDescriptor().getFullTableName() + "." + this.getColumnName();
    }

    public void setColumnName(String str) {
        this.m_ColumnName = str;
    }

    public String getColumnType() {
        return this.m_ColumnType;
    }

    public void setColumnType(String str) {
        this.m_ColumnType = str;
        this.m_jdbcType = this.lookupJdbcType();
    }

    public JdbcType getJdbcType() {
        if (this.m_jdbcType == null) {
            this.m_jdbcType = this.lookupJdbcType();
        }
        return this.m_jdbcType;
    }

    private JdbcType lookupJdbcType() {
        JdbcType result = null;
        String columnType = this.getColumnType();
        if (columnType == null) {
            try {
                result = JdbcTypesHelper.getJdbcTypeByReflection(this.m_PersistentField.getType().getName());
            }
            catch (Exception e) {
                String eol = SystemUtils.LINE_SEPARATOR;
                throw new OJBRuntimeException("Can't automatically assign a jdbc field-type for field: " + eol + this.toXML() + eol + "in class: " + eol + this.getClassDescriptor(), e);
            }
        }
        try {
            result = JdbcTypesHelper.getJdbcTypeByName(columnType);
        }
        catch (Exception e) {
            String eol = SystemUtils.LINE_SEPARATOR;
            throw new OJBRuntimeException("Can't assign the specified jdbc field-type '" + columnType + "' for field: " + eol + this.toXML() + eol + "in class: " + eol + this.getClassDescriptor(), e);
        }
        return result;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("columnName", (Object)this.m_ColumnName);
        buf.append("columnType", (Object)this.m_ColumnType);
        buf.append("isPrimaryKey", this.m_IsKeyField);
        buf.append("isLocking", this.m_locking);
        buf.append("isAutoincrement", this.m_autoIncrement);
        buf.append("access", (Object)this.m_access);
        buf.append("sequenceName", (Object)this.m_sequenceName);
        buf.append("jdbcType", (Object)this.m_jdbcType);
        buf.append("super_class_fields ", (Object)("=> " + super.toString()));
        buf.append((Object)SystemUtils.LINE_SEPARATOR);
        return buf.toString();
    }

    public FieldConversion getFieldConversion() {
        if (this.fieldConversion == null) {
            this.fieldConversion = new FieldConversionDefaultImpl();
        }
        return this.fieldConversion;
    }

    public void setFieldConversion(FieldConversion fieldConversion) {
        this.fieldConversion = fieldConversion;
    }

    public void setFieldConversionClassName(String fieldConversionClassName) {
        try {
            this.fieldConversion = (FieldConversion)ClassHelper.newInstance(fieldConversionClassName);
        }
        catch (Exception e) {
            throw new MetadataException("Could not instantiate FieldConversion class using default constructor", e);
        }
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isAutoIncrement() {
        return this.m_autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.m_autoIncrement = autoIncrement;
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public boolean isPrimaryKey() {
        return this.m_IsKeyField;
    }

    public void setPrimaryKey(boolean b) {
        this.m_IsKeyField = b;
    }

    public int getColNo() {
        return this.m_ColNo;
    }

    public boolean isLocking() {
        return this.m_locking;
    }

    public void setLocking(boolean locking) {
        this.m_locking = locking;
    }

    public boolean isUpdateLock() {
        return this.updateLock;
    }

    public void setUpdateLock(boolean updateLock) {
        this.updateLock = updateLock;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isScaleSpecified() {
        return this.scaleSpecified;
    }

    public void setScaleSpecified(boolean scaleSpecified) {
        this.scaleSpecified = scaleSpecified;
    }

    public boolean isPrecisionSpecified() {
        return this.precisionSpecified;
    }

    public void setPrecisionSpecified(boolean precisionSpecified) {
        this.precisionSpecified = precisionSpecified;
    }

    public boolean isLengthSpecified() {
        return this.lengthSpecified;
    }

    public void setLengthSpecified(boolean lengthSpecified) {
        this.lengthSpecified = lengthSpecified;
    }

    public String getAccess() {
        return this.m_access;
    }

    public void setAccess(String access) {
        if (access == null) {
            access = ACCESS_READWRITE;
        }
        if (!(ACCESS_ANONYMOUS.equals(access) || ACCESS_READONLY.equals(access) || ACCESS_READWRITE.equals(access))) {
            throw new OJBRuntimeException("Try to set unkown field 'access' value: " + access);
        }
        this.m_access = access;
    }

    public boolean isAccessReadOnly() {
        return ACCESS_READONLY.equals(this.getAccess());
    }

    public boolean isAnonymous() {
        return (class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField = FieldDescriptor.class$("org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentField")) : class$org$apache$ojb$broker$metadata$fieldaccess$AnonymousPersistentField).isAssignableFrom(this.getPersistentField().getClass());
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer result = new StringBuffer(1024);
        result.append("      ");
        result.append(tags.getOpeningTagNonClosingById(15));
        result.append(" ");
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(16, this.getAttributeName()));
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(17, this.getColumnName()));
        result.append(eol);
        result.append("        ");
        result.append(tags.getAttribute(18, this.getColumnType()));
        result.append(eol);
        if (this.isPrimaryKey()) {
            result.append("        ");
            result.append(tags.getAttribute(19, "true"));
            result.append(eol);
        }
        if (this.isRequired()) {
            result.append("        ");
            result.append(tags.getAttribute(50, "false"));
            result.append(eol);
        }
        if (this.isAutoIncrement()) {
            result.append("        ");
            result.append(tags.getAttribute(31, "true"));
            result.append(eol);
        }
        if (this.isLocking()) {
            result.append("        ");
            result.append(tags.getAttribute(46, "true"));
            result.append(eol);
        }
        if (!this.isUpdateLock()) {
            result.append("        ");
            result.append(tags.getAttribute(98, "false"));
            result.append(eol);
        }
        if (this.getFieldConversion().getClass() != (class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl = FieldDescriptor.class$("org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl)) {
            result.append("        ");
            result.append(tags.getAttribute(30, this.getFieldConversion().getClass().getName()));
            result.append(eol);
        }
        if (this.isLengthSpecified()) {
            result.append("        ");
            result.append(tags.getAttribute(52, "" + this.getLength()));
            result.append(eol);
        }
        if (this.isPrecisionSpecified()) {
            result.append("        ");
            result.append(tags.getAttribute(53, "" + this.getPrecision()));
            result.append(eol);
        }
        if (this.isScaleSpecified()) {
            result.append("        ");
            result.append(tags.getAttribute(54, "" + this.getScale()));
            result.append(eol);
        }
        result.append("        ");
        result.append(tags.getAttribute(99, this.getAccess()));
        result.append(eol);
        result.append("      />");
        result.append(eol);
        return result.toString();
    }

    public Object clone() {
        return SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

