/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.AbstractPersistentField;

public class PersistentFieldDirectAccessImpl
extends AbstractPersistentField {
    private static final long serialVersionUID = -5458024240998909205L;

    public PersistentFieldDirectAccessImpl() {
    }

    public PersistentFieldDirectAccessImpl(Class type, String fieldname) {
        super(type, fieldname);
    }

    public void doSet(Object obj, Object value) throws MetadataException {
        Field fld = this.getField();
        Class<?> type = fld.getType();
        try {
            if (value != null || !type.isPrimitive()) {
                fld.set(ProxyHelper.getRealObject(obj), value);
            }
        }
        catch (NullPointerException ignored) {
            this.getLog().info("Value for field " + (fld != null ? fld.getName() : null) + " of type " + type.getName() + " is null. Can't write into null.", ignored);
        }
        catch (IllegalAccessException e) {
            this.getLog().error("while set field: " + this.buildMessageString(obj, value, fld));
            throw new MetadataException("IllegalAccess error setting field:" + (fld != null ? fld.getName() : null) + " in object:" + obj.getClass().getName(), e);
        }
        catch (Exception e) {
            this.getLog().error("while set field: " + this.buildMessageString(obj, value, fld), e);
            throw new MetadataException("Error setting field:" + (fld != null ? fld.getName() : null) + " in object:" + obj.getClass().getName(), e);
        }
    }

    public Object doGet(Object obj) throws MetadataException {
        if (obj == null) {
            return null;
        }
        Field fld = this.getField();
        try {
            Object result = fld.get(ProxyHelper.getRealObject(obj));
            return result;
        }
        catch (IllegalAccessException e) {
            throw new MetadataException("IllegalAccess error getting field:" + (fld != null ? fld.getName() : null) + " in object:" + obj != null ? obj.getClass().getName() : null, e);
        }
        catch (Throwable e) {
            throw new MetadataException("Error getting field:" + (fld != null ? fld.getName() : null) + " in object:" + (obj != null ? obj.getClass().getName() : null), e);
        }
    }

    public boolean makeAccessible() {
        return true;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }
}

