/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;
import org.apache.ojb.broker.metadata.torque.TorqueFieldGenerator;
import org.apache.ojb.broker.metadata.torque.TorqueForeignKeyGenerator;
import org.apache.ojb.broker.metadata.torque.TorqueIndexGenerator;

public class TorqueTableGenerator {
    private TorqueFieldGenerator fieldGenerator;
    private TorqueForeignKeyGenerator foreignKeyPreprocessor;
    private TorqueIndexGenerator indexGenerator;

    public TorqueTableGenerator(DescriptorRepository repository, boolean ignoreAutoIncrement) {
        this.fieldGenerator = new TorqueFieldGenerator(ignoreAutoIncrement);
        this.foreignKeyPreprocessor = new TorqueForeignKeyGenerator(repository);
        this.foreignKeyPreprocessor.buildConstraintsMap();
        this.indexGenerator = new TorqueIndexGenerator();
    }

    public void generateMappingTables(StringBuffer buffer, String indexTablespaceName) {
        Iterator mappingTables = this.foreignKeyPreprocessor.getMappingTables().values().iterator();
        while (mappingTables.hasNext()) {
            TableDescriptor mappingTable = (TableDescriptor)mappingTables.next();
            FieldDescriptor[] descriptors = mappingTable.getColumns().toArray(new FieldDescriptor[0]);
            if (descriptors == null || descriptors.length <= 0) continue;
            this.generateTableHeader(buffer, mappingTable, indexTablespaceName);
            this.fieldGenerator.generateMappingFieldDescriptors(descriptors, buffer);
            this.generateForeignKeys(mappingTable, buffer);
            buffer.append("    </table>\n");
        }
    }

    public void generateStandardTable(TableDescriptor tableDescriptor, StringBuffer buffer, String indexTablespaceName) {
        this.generateTableHeader(buffer, tableDescriptor, indexTablespaceName);
        this.fieldGenerator.generateFieldDescriptors(tableDescriptor.getColumns().toArray(new FieldDescriptor[0]), buffer);
        this.indexGenerator.generateIndices(tableDescriptor.getIndices(), buffer);
        this.generateForeignKeys(tableDescriptor, buffer);
        buffer.append("    </table>\n\n");
    }

    private void generateTableHeader(StringBuffer buffer, TableDescriptor tableDescriptor, String indexTablespaceName) {
        buffer.append("    <table name=\"");
        buffer.append(tableDescriptor.getName());
        buffer.append("\" indexTablespace=\"");
        buffer.append(indexTablespaceName);
        buffer.append("\">\n");
    }

    private void generateForeignKeys(TableDescriptor tableDescriptor, StringBuffer buffer) {
        Vector foreignKeys = this.foreignKeyPreprocessor.getForeignKeysForTable(tableDescriptor.getName());
        if (foreignKeys != null) {
            Iterator foreignKeyIterator = foreignKeys.iterator();
            while (foreignKeyIterator.hasNext()) {
                buffer.append(foreignKeyIterator.next());
            }
        }
    }
}

