/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerStoredProcedureImpl
extends AbstractSequenceManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerStoredProcedureImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerStoredProcedureImpl = SequenceManagerStoredProcedureImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerStoredProcedureImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerStoredProcedureImpl);
    protected static final String PROCEDURE_NAME = "ojb_nextval_proc";
    protected static final String SEQ_NAME_STRING = "SEQ_NAME";
    protected static final String SEQ_ID_STRING = "MAX_KEY";
    protected static final String SEQ_TABLE_NAME = "OJB_NEXTVAL_SEQ";
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerStoredProcedureImpl;

    public SequenceManagerStoredProcedureImpl(PersistenceBroker broker) {
        super(broker);
    }

    protected String sp_createSequenceQuery(String sequenceName, long maxKey) {
        String result = "insert into OJB_NEXTVAL_SEQ (SEQ_NAME,MAX_KEY) values ('" + sequenceName + "'," + maxKey + ")";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        boolean needsCommit = false;
        long result = 0L;
        PersistenceBroker targetBroker = this.getBrokerForClass();
        if (!targetBroker.isInTransaction()) {
            targetBroker.beginTransaction();
            needsCommit = true;
        }
        try {
            String sequenceName = this.calculateSequenceName(field);
            try {
                result = this.buildNextSequence(targetBroker, field.getClassDescriptor(), sequenceName);
                if (result == 0L) {
                    throw new SequenceManagerException("No incremented value retrieved");
                }
            }
            catch (Exception e) {
                this.log.info("Could not grab next key, message was " + e.getMessage() + " - try to write a new sequence entry to database");
                try {
                    long maxKey = SequenceManagerHelper.getMaxForExtent(targetBroker, field);
                    this.createSequence(targetBroker, field, sequenceName, maxKey);
                }
                catch (Exception e1) {
                    String eol = SystemUtils.LINE_SEPARATOR;
                    throw new SequenceManagerException(eol + "Could not grab next id, failed with " + eol + e.getMessage() + eol + "Creation of new sequence failed with " + eol + e1.getMessage() + eol, e1);
                }
                try {
                    result = this.buildNextSequence(targetBroker, field.getClassDescriptor(), sequenceName);
                }
                catch (Exception e1) {
                    throw new SequenceManagerException("Could not grab next id although a sequence seems to exist", e);
                }
            }
            Object var11_11 = null;
            if (targetBroker != null && needsCommit) {
                targetBroker.commitTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (targetBroker != null && needsCommit) {
                targetBroker.commitTransaction();
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long buildNextSequence(PersistenceBroker broker, ClassDescriptor cld, String sequenceName) throws LookupException, SQLException, PlatformException {
        long l;
        Statement cs = null;
        try {
            Connection con = broker.serviceConnectionManager().getConnection();
            cs = this.getPlatform().prepareNextValProcedureStatement(con, PROCEDURE_NAME, sequenceName);
            cs.executeUpdate();
            l = cs.getLong(1);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            if (cs != null) {
                cs.close();
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return l;
    }

    /*
     * Loose catch block
     */
    protected void createSequence(PersistenceBroker broker, FieldDescriptor field, String sequenceName, long maxKey) throws Exception {
        block10: {
            Statement stmt = null;
            stmt = broker.serviceStatementManager().getGenericStatement(field.getClassDescriptor(), false);
            stmt.execute(this.sp_createSequenceQuery(sequenceName, maxKey));
            Object var9_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block10;
            }
            catch (SQLException sqle) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Threw SQLException while in createSequence and closing stmt", sqle);
                }
                break block10;
            }
            {
                catch (Exception e) {
                    this.log.error(e);
                    throw new SequenceManagerException("Could not create new row in OJB_NEXTVAL_SEQ table - TABLENAME=" + sequenceName + " field=" + field.getColumnName(), e);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var9_7 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sqle) {
                        if (!this.log.isDebugEnabled()) break block11;
                        this.log.debug("Threw SQLException while in createSequence and closing stmt", sqle);
                    }
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

