/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListImpl;

public class DListEntry
implements Serializable,
PersistenceBrokerAware {
    private static final long serialVersionUID = 5251476492626009907L;
    private transient Logger log;
    protected transient Object realSubject;
    protected PBKey pbKey;
    protected Integer id;
    protected Integer dlistId;
    protected Identity oid;
    protected int position;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListEntry;

    public DListEntry() {
        this.getPBKey();
    }

    public DListEntry(DListImpl theDList, Object theObject) {
        this.dlistId = theDList.getId();
        this.position = theDList.size();
        this.realSubject = theObject;
        this.pbKey = this.getPBKey();
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListEntry == null ? (class$org$apache$ojb$odmg$collections$DListEntry = DListEntry.class$("org.apache.ojb.odmg.collections.DListEntry")) : class$org$apache$ojb$odmg$collections$DListEntry);
        }
        return this.log;
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = this.getTransaction()) != null && tx.isOpen()) {
            this.pbKey = tx.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    protected void prepareForPersistency(PersistenceBroker broker) {
        if (this.oid == null) {
            if (this.realSubject == null) {
                throw new OJBRuntimeException("Identity and real object are 'null' - Can not persist empty entry");
            }
            this.oid = broker.serviceIdentity().buildIdentity(this.realSubject);
        }
    }

    protected void prepareRealSubject(PersistenceBroker broker) {
        if (this.oid == null) {
            throw new OJBRuntimeException("can not return real object, real object and Identity is null");
        }
        this.realSubject = broker.getObjectByIdentity(this.oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRealSubject() {
        if (this.realSubject != null) {
            return this.realSubject;
        }
        TransactionImpl tx = this.getTransaction();
        if (tx != null && tx.isOpen()) {
            this.prepareRealSubject(tx.getBroker());
            if (this.realSubject != null) {
                RuntimeObject rt = new RuntimeObject(this.realSubject, tx, false);
                tx.lockAndRegister(rt, 4, true);
                tx.lockAndRegisterCleanup();
            }
        } else {
            PBKey aPbKey = this.getPBKey();
            if (aPbKey != null) {
                PBCapsule capsule = new PBCapsule(aPbKey, null);
                try {
                    this.prepareRealSubject(capsule.getBroker());
                }
                finally {
                    capsule.destroy();
                }
            } else {
                this.getLog().warn("No tx, no PBKey - can't materialise object with Identity " + this.getOid());
            }
        }
        return this.realSubject;
    }

    public void setRealSubject(Object realSubject) {
        this.realSubject = realSubject;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public Integer getDlistId() {
        return this.dlistId;
    }

    public void setDlistId(Integer dlistId) {
        this.dlistId = dlistId;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Identity getOid() {
        return this.oid;
    }

    public void setOid(Identity oid) {
        this.oid = oid;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("id", (Object)this.id);
        buf.append("dListId", (Object)this.dlistId);
        buf.append("position", this.position);
        buf.append("identity", (Object)this.oid);
        buf.append("realSubject", this.realSubject);
        return buf.toString();
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
        this.prepareForPersistency(broker);
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

