/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.copy;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.IdentityMapFactory;
import org.apache.ojb.otm.copy.ObjectCopyException;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.ReflectiveObjectCopyStrategy;
import org.apache.ojb.otm.copy.SerializeObjectCopyStrategy;

public final class MetadataObjectCopyStrategy
implements ObjectCopyStrategy {
    private static final ReflectiveObjectCopyStrategy _reflective = new ReflectiveObjectCopyStrategy();
    private static final SerializeObjectCopyStrategy _serialize = new SerializeObjectCopyStrategy();

    public Object copy(Object obj, PersistenceBroker broker) {
        return MetadataObjectCopyStrategy.clone(obj, IdentityMapFactory.getIdentityMap(), broker);
    }

    private static Object clone(Object toCopy, Map objMap, PersistenceBroker broker) {
        Object retval;
        if (objMap.containsKey(toCopy)) {
            return objMap.get(toCopy);
        }
        if (toCopy == null) {
            return null;
        }
        if (ProxyHelper.isVirtualOjbProxy(toCopy)) {
            return _reflective.copy(toCopy, null);
        }
        if (ProxyHelper.isNormalOjbProxy(toCopy)) {
            return _serialize.copy(toCopy, null);
        }
        ClassDescriptor cld = broker.getClassDescriptor(toCopy.getClass());
        if (cld == null) {
            return _reflective.copy(toCopy, null);
        }
        try {
            Constructor con = cld.getZeroArgumentConstructor();
            retval = ConstructorHelper.instantiate(con);
            objMap.put(toCopy, retval);
        }
        catch (InstantiationException e) {
            throw new ObjectCopyException("InstantiationException", e);
        }
        FieldDescriptor[] fieldDescs = cld.getFieldDescriptions();
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f = fd.getPersistentField();
            Object fieldValue = f.get(toCopy);
            f.set(retval, fieldValue);
        }
        Vector refDescsCol = cld.getObjectReferenceDescriptors();
        ObjectReferenceDescriptor[] rds = refDescsCol.toArray(new ObjectReferenceDescriptor[refDescsCol.size()]);
        for (int i = 0; i < rds.length; ++i) {
            ObjectReferenceDescriptor rd = rds[i];
            PersistentField f = rd.getPersistentField();
            Object object = f.get(toCopy);
            Object clone = MetadataObjectCopyStrategy.clone(object, objMap, broker);
            objMap.put(object, clone);
            f.set(retval, clone);
        }
        Vector colDescsCol = cld.getCollectionDescriptors();
        Iterator it = colDescsCol.iterator();
        while (it.hasNext()) {
            CollectionDescriptor cd = (CollectionDescriptor)it.next();
            PersistentField f = cd.getPersistentField();
            Object collection = f.get(toCopy);
            if (collection == null) {
                f.set(retval, null);
                continue;
            }
            if (collection instanceof CollectionProxyDefaultImpl) {
                f.set(retval, _reflective.copy(collection, null));
                continue;
            }
            if (collection instanceof Collection) {
                try {
                    Collection newCollection = (Collection)collection.getClass().newInstance();
                    Iterator tempIter = ((Collection)collection).iterator();
                    while (tempIter.hasNext()) {
                        Object obj = tempIter.next();
                        if (ProxyHelper.isNormalOjbProxy(obj)) {
                            newCollection.add(obj);
                            continue;
                        }
                        Object clone = MetadataObjectCopyStrategy.clone(obj, objMap, broker);
                        objMap.put(obj, clone);
                        newCollection.add(clone);
                    }
                    f.set(retval, newCollection);
                    continue;
                }
                catch (InstantiationException e) {
                    throw new ObjectCopyException("InstantiationException", e);
                }
                catch (IllegalAccessException e) {
                    throw new ObjectCopyException("IllegalAccessException", e);
                }
            }
            throw new UnsupportedOperationException("MetadataObjectCopyStrategy cannot handle Collection of type: " + collection.getClass().getName());
        }
        return retval;
    }
}

