/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.ConcreteEditingContext;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.core.TransactionInProgressException;
import org.apache.ojb.otm.core.TransactionListener;
import org.apache.ojb.otm.core.TransactionNotInProgressException;

public class Transaction {
    private boolean _isInProgress;
    private List _listeners = new ArrayList();
    private List _connections = new ArrayList();
    private OTMKit _kit;

    public OTMKit getKit() {
        return this._kit;
    }

    public void setKit(OTMKit kit) {
        this._kit = kit;
    }

    public void begin() throws TransactionException {
        if (this._isInProgress) {
            throw new TransactionInProgressException("Transaction already in progress, cannot restart");
        }
        this._isInProgress = true;
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            BaseConnection connection = (BaseConnection)iterator.next();
            connection.transactionBegin();
        }
        iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            TransactionListener listener = (TransactionListener)iterator.next();
            listener.transactionBegan(this);
        }
    }

    public void commit() throws TransactionException {
        BaseConnection connection;
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, nothing to commit");
        }
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            TransactionListener listener = (TransactionListener)iterator.next();
            listener.transactionCommitting(this);
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            connection = (BaseConnection)iterator.next();
            ConcreteEditingContext context = (ConcreteEditingContext)connection.getEditingContext();
            context.commit();
            connection.transactionPrepare();
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            connection = (BaseConnection)iterator.next();
            connection.transactionCommit();
            connection.setTransaction(null);
        }
        this._connections.clear();
        this._isInProgress = false;
    }

    public void checkpoint() throws TransactionException {
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, cannot checkpoint");
        }
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            BaseConnection connection = (BaseConnection)iterator.next();
            ConcreteEditingContext context = (ConcreteEditingContext)connection.getEditingContext();
            context.checkpoint();
        }
    }

    public void rollback() throws TransactionException {
        if (!this._isInProgress) {
            throw new TransactionNotInProgressException("Transaction not in progress, nothing to commit");
        }
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            TransactionListener listener = (TransactionListener)iterator.next();
            listener.transactionRollingBack(this);
        }
        iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            BaseConnection connection = (BaseConnection)iterator.next();
            ConcreteEditingContext context = (ConcreteEditingContext)connection.getEditingContext();
            context.rollback();
            connection.transactionRollback();
            connection.setTransaction(null);
        }
        this._connections.clear();
        this._isInProgress = false;
    }

    public boolean isInProgress() {
        return this._isInProgress;
    }

    public void registerConnection(OTMConnection connection) {
        Transaction connectionTx = connection.getTransaction();
        if (connectionTx != null && connectionTx != this) {
            throw new TransactionException("Attempt to re-assign a different transaction to a open connection");
        }
        if (!this._connections.contains(connection)) {
            this._connections.add(connection);
            connection.setTransaction(this);
        }
    }

    public void registerListener(TransactionListener listener) {
        if (this._listeners.indexOf(listener) < 0) {
            this._listeners.add(listener);
        }
    }
}

