/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.soda;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.query.Query;
import org.odbms.ObjectSet;

public class ObjectSetImpl
implements ObjectSet {
    protected Iterator ojbIterator;
    protected int length;
    protected Vector elements;
    protected int position = 0;
    protected int scrolled = 0;
    protected boolean resultSetClosed;

    public ObjectSetImpl(PersistenceBroker broker, Query query, int limit) {
        Collection col = broker.getCollectionByQuery(query);
        this.ojbIterator = col.iterator();
        this.length = col.size();
        if (limit >= 0) {
            this.length = Math.min(this.length, limit);
        }
        this.elements = new Vector(this.length);
        this.setResultSetClosed(false);
    }

    public synchronized boolean hasNext() {
        if (this.position < this.length) {
            if (this.position < this.scrolled) {
                return true;
            }
            boolean result = this.ojbIterator.hasNext();
            return result;
        }
        this.releaseJdbcResources();
        return false;
    }

    protected void releaseJdbcResources() {
        if (!this.isResultSetClosed()) {
            if (this.ojbIterator instanceof RsIterator) {
                ((RsIterator)this.ojbIterator).releaseDbResources();
            }
            this.setResultSetClosed(true);
        }
    }

    public synchronized Object next() {
        if (this.position < this.scrolled) {
            ++this.position;
            return this.elements.get(this.position - 1);
        }
        Object next = this.ojbIterator.next();
        this.elements.add(next);
        ++this.position;
        ++this.scrolled;
        return next;
    }

    public synchronized void reset() {
        this.position = 0;
    }

    public int size() {
        return this.length;
    }

    public boolean isResultSetClosed() {
        return this.resultSetClosed;
    }

    public void setResultSetClosed(boolean resultSetClosed) {
        this.resultSetClosed = resultSetClosed;
    }
}

