/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.logging.LoggerWrapperPrintWriter;

public class ConnectionFactoryDBCPImpl
extends ConnectionFactoryAbstractImpl {
    public static final String PARAM_NAME_UNWRAP_ALLOWED = "accessToUnderlyingConnectionAllowed";
    public static final String PARAM_NAME_POOL_STATEMENTS = "poolPreparedStatements";
    public static final String PARAM_NAME_STATEMENT_POOL_MAX_TOTAL = "maxOpenPreparedStatements";
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl = ConnectionFactoryDBCPImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl);
    private Map poolMap = Collections.synchronizedMap(new HashMap());
    private Map dsMap = Collections.synchronizedMap(new HashMap());
    private final Object poolSynch = new Object();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl;

    public Connection checkOutJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection;
        DataSource dataSource = this.getDataSource(jdbcConnectionDescriptor);
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            throw new LookupException("Could not get connection from DBCP DataSource", sQLException);
        }
        return connection;
    }

    public void releaseJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws LookupException {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.log.warn("Connection close failed", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        super.releaseAllResources();
        Object object = this.poolSynch;
        synchronized (object) {
            if (!this.poolMap.isEmpty()) {
                Collection collection = this.poolMap.values();
                Iterator iterator = collection.iterator();
                ObjectPool objectPool = null;
                while (iterator.hasNext()) {
                    try {
                        objectPool = (ObjectPool)iterator.next();
                        objectPool.close();
                    }
                    catch (Exception exception) {
                        this.log.error("Exception occured while closing ObjectPool " + objectPool, exception);
                    }
                }
                this.poolMap.clear();
            }
            this.dsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getDataSource(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        PBKey pBKey = jdbcConnectionDescriptor.getPBKey();
        DataSource dataSource = (DataSource)this.dsMap.get(pBKey);
        if (dataSource == null) {
            try {
                Object object = this.poolSynch;
                synchronized (object) {
                    ObjectPool objectPool = this.setupPool(jdbcConnectionDescriptor);
                    this.poolMap.put(pBKey, objectPool);
                    dataSource = this.wrapAsDataSource(jdbcConnectionDescriptor, objectPool);
                    this.dsMap.put(pBKey, dataSource);
                }
            }
            catch (Exception exception) {
                this.log.error("Could not setup DBCP DataSource for " + jdbcConnectionDescriptor, exception);
                throw new LookupException(exception);
            }
        }
        return dataSource;
    }

    protected ObjectPool setupPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        this.log.info("Create new ObjectPool for DBCP connections:" + jdbcConnectionDescriptor);
        try {
            ClassHelper.newInstance(jdbcConnectionDescriptor.getDriver());
        }
        catch (InstantiationException instantiationException) {
            this.log.fatal("Unable to instantiate the driver class: " + jdbcConnectionDescriptor.getDriver() + " in ConnectionFactoryDBCImpl!", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.fatal("IllegalAccessException while instantiating the driver class: " + jdbcConnectionDescriptor.getDriver() + " in ConnectionFactoryDBCImpl!", illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.fatal("Could not find the driver class : " + jdbcConnectionDescriptor.getDriver() + " in ConnectionFactoryDBCImpl!", classNotFoundException);
        }
        GenericObjectPool.Config config = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getObjectPoolConfig();
        AbandonedConfig abandonedConfig = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getAbandonedConfig();
        ObjectPool objectPool = this.createConnectionPool(config, abandonedConfig);
        ConnectionFactory connectionFactory = this.createConnectionFactory(jdbcConnectionDescriptor);
        KeyedObjectPoolFactory keyedObjectPoolFactory = this.createStatementPoolFactory(jdbcConnectionDescriptor);
        String string = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getValidationQuery();
        boolean bl = jdbcConnectionDescriptor.getUseAutoCommit() != 2;
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, objectPool, keyedObjectPoolFactory, string, false, bl, abandonedConfig);
        return poolableConnectionFactory.getPool();
    }

    protected ObjectPool createConnectionPool(GenericObjectPool.Config config, AbandonedConfig abandonedConfig) {
        boolean bl = abandonedConfig != null && abandonedConfig.getRemoveAbandoned();
        Object object = bl ? new AbandonedObjectPool(null, abandonedConfig) : new GenericObjectPool();
        object.setMaxActive(config.maxActive);
        object.setMaxIdle(config.maxIdle);
        object.setMinIdle(config.minIdle);
        object.setMaxWait(config.maxWait);
        object.setTestOnBorrow(config.testOnBorrow);
        object.setTestOnReturn(config.testOnReturn);
        object.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
        object.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        object.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        object.setTestWhileIdle(config.testWhileIdle);
        return object;
    }

    protected KeyedObjectPoolFactory createStatementPoolFactory(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        String string = jdbcConnectionDescriptor.getDbms();
        if (string.startsWith("Oracle9i")) {
            return null;
        }
        GenericKeyedObjectPoolFactory genericKeyedObjectPoolFactory = null;
        Properties properties = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getDbcpProperties();
        String string2 = properties.getProperty(PARAM_NAME_POOL_STATEMENTS);
        if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
            int n = -1;
            String string3 = properties.getProperty(PARAM_NAME_STATEMENT_POOL_MAX_TOTAL);
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            genericKeyedObjectPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, n);
        }
        return genericKeyedObjectPoolFactory;
    }

    protected DataSource wrapAsDataSource(JdbcConnectionDescriptor jdbcConnectionDescriptor, ObjectPool objectPool) {
        Properties properties;
        String string;
        boolean bl = jdbcConnectionDescriptor == null ? false : (string = (properties = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getDbcpProperties()).getProperty(PARAM_NAME_UNWRAP_ALLOWED)) != null && Boolean.valueOf(string) != false;
        properties = new PoolingDataSource(objectPool);
        properties.setAccessToUnderlyingConnectionAllowed(bl);
        if (jdbcConnectionDescriptor != null && (string = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getAbandonedConfig()).getRemoveAbandoned() && string.getLogAbandoned()) {
            LoggerWrapperPrintWriter loggerWrapperPrintWriter = new LoggerWrapperPrintWriter(this.log, 4);
            properties.setLogWriter(loggerWrapperPrintWriter);
        }
        return properties;
    }

    protected ConnectionFactory createConnectionFactory(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        Properties properties = this.getJdbcProperties(jdbcConnectionDescriptor);
        ConPoolFactory conPoolFactory = new ConPoolFactory(jdbcConnectionDescriptor, properties);
        return conPoolFactory;
    }

    protected ObjectPool createObjectPool(GenericObjectPool.Config config) {
        return this.createConnectionPool(config, null);
    }

    protected PoolingDataSource createPoolingDataSource(ObjectPool objectPool) {
        return (PoolingDataSource)this.wrapAsDataSource(null, objectPool);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConPoolFactory
    extends DriverManagerConnectionFactory {
        private final JdbcConnectionDescriptor jcd;

        public ConPoolFactory(JdbcConnectionDescriptor jdbcConnectionDescriptor, Properties properties) {
            super(ConnectionFactoryDBCPImpl.this.getDbURL(jdbcConnectionDescriptor), properties);
            this.jcd = jdbcConnectionDescriptor;
        }

        public Connection createConnection() throws SQLException {
            Connection connection = super.createConnection();
            if (connection != null) {
                try {
                    ConnectionFactoryDBCPImpl.this.initializeJdbcConnection(connection, this.jcd);
                }
                catch (LookupException lookupException) {
                    ConnectionFactoryDBCPImpl.this.log.error("Platform dependent initialization of connection failed", (Throwable)((Object)lookupException));
                }
            }
            return connection;
        }
    }
}

