/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryPooledImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl);
    private Map poolMap = new HashMap();
    private final Object poolSynch = new Object();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public void releaseJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws LookupException {
        ObjectPool objectPool = (ObjectPool)this.poolMap.get(jdbcConnectionDescriptor.getPBKey());
        try {
            objectPool.returnObject((Object)connection);
        }
        catch (Exception exception) {
            throw new LookupException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection checkOutJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Object object;
        ObjectPool objectPool = (ObjectPool)this.poolMap.get(jdbcConnectionDescriptor.getPBKey());
        if (objectPool == null) {
            object = this.poolSynch;
            synchronized (object) {
                this.log.info("Create new connection pool:" + jdbcConnectionDescriptor);
                objectPool = this.createConnectionPool(jdbcConnectionDescriptor);
                this.poolMap.put(jdbcConnectionDescriptor.getPBKey(), objectPool);
            }
        }
        try {
            object = (Connection)objectPool.borrowObject();
        }
        catch (NoSuchElementException noSuchElementException) {
            int n = 0;
            int n2 = 0;
            try {
                n = objectPool.getNumActive();
                n2 = objectPool.getNumIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LookupException("Could not borrow connection from pool, seems ObjectPool is exhausted. Active/Idle instances in pool=" + n + "/" + n2 + ". " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jdbcConnectionDescriptor, noSuchElementException);
        }
        catch (Exception exception) {
            int n = 0;
            int n3 = 0;
            try {
                n = objectPool.getNumActive();
                n3 = objectPool.getNumIdle();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new LookupException("Could not borrow connection from pool. Active/Idle instances in pool=" + n + "/" + n3 + ". " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jdbcConnectionDescriptor, exception);
        }
        return object;
    }

    public ObjectPool createConnectionPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createPool was called");
        }
        ConPoolFactory conPoolFactory = new ConPoolFactory(this, jdbcConnectionDescriptor);
        GenericObjectPool.Config config = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getObjectPoolConfig();
        return new GenericObjectPool((PoolableObjectFactory)conPoolFactory, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        Object object = this.poolSynch;
        synchronized (object) {
            Collection collection = this.poolMap.values();
            this.poolMap = new HashMap(this.poolMap.size());
            ObjectPool objectPool = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    objectPool = (ObjectPool)iterator.next();
                    objectPool.close();
                }
                catch (Exception exception) {
                    this.log.error("Exception occured while closing pool " + objectPool, exception);
                }
            }
        }
        super.releaseAllResources();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConPoolFactory
    extends BasePoolableObjectFactory {
        private final JdbcConnectionDescriptor jcd;
        private final ConnectionFactoryPooledImpl cf;
        private int failedValidationQuery;

        public ConPoolFactory(ConnectionFactoryPooledImpl connectionFactoryPooledImpl2, JdbcConnectionDescriptor jdbcConnectionDescriptor) {
            this.cf = connectionFactoryPooledImpl2;
            this.jcd = jdbcConnectionDescriptor;
        }

        public boolean validateObject(Object object) {
            boolean bl = false;
            if (object != null) {
                String string;
                Connection connection = (Connection)object;
                try {
                    bl = !connection.isClosed();
                }
                catch (SQLException sQLException) {
                    ConnectionFactoryPooledImpl.this.log.warn("Connection validation failed: " + sQLException.getMessage());
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug(sQLException);
                    }
                    bl = false;
                }
                if (bl && (string = this.jcd.getConnectionPoolDescriptor().getValidationQuery()) != null) {
                    bl = this.validateConnection(connection, string);
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean validateConnection(Connection connection, String string) {
            boolean bl;
            block25: {
                SQLException sQLException2222;
                ResultSet resultSet;
                PreparedStatement preparedStatement;
                block24: {
                    block23: {
                        preparedStatement = null;
                        resultSet = null;
                        bl = false;
                        if (this.failedValidationQuery > 100) {
                            --this.failedValidationQuery;
                            throw new OJBRuntimeException("Validation of connection " + connection + " using validation query '" + string + "' failed more than 100 times.");
                        }
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setMaxRows(1);
                        preparedStatement.setFetchSize(1);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            this.failedValidationQuery = 0;
                            bl = true;
                            break block23;
                        }
                        ++this.failedValidationQuery;
                        ConnectionFactoryPooledImpl.this.log.warn("Validation query '" + string + "' result set does not match, discard connection");
                        bl = false;
                    }
                    Object var8_6 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2222) {
                        if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block24;
                        ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", sQLException2222);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    break block25;
                }
                catch (SQLException sQLException2222) {
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", sQLException2222);
                    }
                    break block25;
                }
                {
                    catch (SQLException sQLException3) {
                        SQLException sQLException42222;
                        block26: {
                            ++this.failedValidationQuery;
                            ConnectionFactoryPooledImpl.this.log.warn("Validation query for connection failed, discard connection. Query was '" + string + "', Message was " + sQLException3.getMessage());
                            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                                ConnectionFactoryPooledImpl.this.log.debug(sQLException3);
                            }
                            Object var8_7 = null;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (SQLException sQLException42222) {
                                if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block26;
                                ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", sQLException42222);
                            }
                        }
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            break block25;
                        }
                        catch (SQLException sQLException42222) {
                            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                                ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", sQLException42222);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block28: {
                        SQLException sQLException52222;
                        block27: {
                            Object var8_8 = null;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (SQLException sQLException52222) {
                                if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block27;
                                ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", sQLException52222);
                            }
                        }
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sQLException52222) {
                            if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block28;
                            ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", sQLException52222);
                        }
                    }
                    throw throwable;
                }
            }
            return bl;
        }

        public Object makeObject() throws Exception {
            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                ConnectionFactoryPooledImpl.this.log.debug("makeObject called");
            }
            return this.cf.newConnectionFromDriverManager(this.jcd);
        }

        public void destroyObject(Object object) throws Exception {
            ConnectionFactoryPooledImpl.this.log.info("Destroy object was called, try to close connection: " + object);
            try {
                ((Connection)object).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

