/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.ant.DBUtility;
import org.apache.ojb.broker.ant.VerifyMappingsTask;
import org.apache.ojb.broker.locking.IsolationLevels;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryVerifierHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger;
    private DescriptorRepository m_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private ClassDescriptor m_CurrentCLD;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private String m_CurrentString;
    private VerifyMappingsTask m_callingTask;
    private DBUtility m_dBUtility;
    private Class m_currentClass = null;
    private String m_CurrentTable = null;
    private boolean m_currentTableExists = false;
    private int defIsoLevel = 2;
    private RepositoryTags tags = RepositoryTags.getInstance();
    private Collection m_VerifyExceptions = new ArrayList(69);
    private Collection m_VerifyWarnings = new ArrayList(69);
    private int m_lastId = 0;
    private Constructor m_persistConstructor = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    public RepositoryVerifierHandler(VerifyMappingsTask verifyMappingsTask) {
        this.m_callingTask = verifyMappingsTask;
        this.m_callingTask.logWarning("Loaded RepositoryVerifierHandler.");
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private int getLiteralId(String string) throws PersistenceBrokerException {
        try {
            return this.tags.getIdByTag(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new MetadataException("unknown literal: '" + string + "'", nullPointerException);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.m_CurrentString = null;
        try {
            switch (this.getLiteralId(string3)) {
                case 0: {
                    String string4 = attributes.getValue(this.tags.getTagById(34));
                    if (string4 == null) break;
                    this.defIsoLevel = this.getIsoLevel(string4);
                    break;
                }
                case 1: {
                    this.m_CurrentJCD = new JdbcConnectionDescriptor();
                    String string5 = attributes.getValue(this.tags.getTagById(2));
                    this.m_CurrentJCD.setDbms(string5);
                    String string6 = attributes.getValue(this.tags.getTagById(45));
                    this.m_CurrentJCD.setJdbcLevel(string6);
                    String string7 = attributes.getValue(this.tags.getTagById(6));
                    this.m_CurrentJCD.setDriver(string7);
                    String string8 = attributes.getValue(this.tags.getTagById(7));
                    this.m_CurrentJCD.setProtocol(string8);
                    String string9 = attributes.getValue(this.tags.getTagById(8));
                    this.m_CurrentJCD.setSubProtocol(string9);
                    String string10 = attributes.getValue(this.tags.getTagById(9));
                    this.m_CurrentJCD.setDbAlias(string10);
                    String string11 = attributes.getValue(this.tags.getTagById(44));
                    this.m_CurrentJCD.setDatasourceName(string11);
                    String string12 = attributes.getValue(this.tags.getTagById(10));
                    this.m_CurrentJCD.setUserName(string12);
                    String string13 = attributes.getValue(this.tags.getTagById(11));
                    this.m_CurrentJCD.setPassWord(string13);
                    this.m_dBUtility = this.getDBUtility(this.m_CurrentJCD);
                    break;
                }
                case 12: {
                    String string14 = attributes.getValue(this.tags.getTagById(34));
                    String string15 = attributes.getValue(this.tags.getTagById(13));
                    try {
                        this.m_currentClass = this.m_callingTask.loadClass(string15);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MetadataException("Can't load class-descriptor class '" + string15 + "'.");
                    }
                    this.m_CurrentTable = attributes.getValue(this.tags.getTagById(14));
                    if (this.m_CurrentTable == null) break;
                    this.m_currentTableExists = this.m_dBUtility.exists(this.m_CurrentTable);
                    if (this.m_currentTableExists) break;
                    throw new MetadataException("The table '" + this.m_CurrentTable + "' does not exist in the database.");
                }
                case 33: {
                    String string16 = attributes.getValue("class-ref");
                    try {
                        Class clazz = this.m_callingTask.loadClass(string16);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MetadataException("Can't load extent-class class '" + string16 + "'.");
                    }
                }
                case 15: {
                    String string17 = attributes.getValue("id");
                    this.m_lastId = string17 == null ? this.m_lastId + 1 : Integer.parseInt(string17);
                    this.m_CurrentFLD = new FieldDescriptor(null, this.m_lastId);
                    String string18 = attributes.getValue(this.tags.getTagById(16));
                    if (this.m_currentClass == null) break;
                    this.confirmFieldExists(this.m_currentClass, string18);
                    String string19 = attributes.getValue(this.tags.getTagById(17));
                    this.m_CurrentFLD.setColumnName(string19);
                    String string20 = attributes.getValue(this.tags.getTagById(18));
                    this.m_CurrentFLD.setColumnType(string20);
                    if (!this.m_currentTableExists) break;
                    if (this.m_callingTask.getUseStrictTypeChecking()) {
                        this.m_dBUtility.exists(this.m_CurrentTable, string19, string20, this.m_callingTask.getIgnoreFieldNameCase());
                        break;
                    }
                    this.m_dBUtility.existsUseWarnings(this.m_CurrentTable, string19, string20, this.m_callingTask.getIgnoreFieldNameCase());
                    break;
                }
                case 20: {
                    if (this.m_currentClass == null) break;
                    string2 = attributes.getValue(this.tags.getTagById(16));
                    this.confirmFieldExists(this.m_currentClass, string2);
                    String string21 = attributes.getValue(this.tags.getTagById(22));
                    try {
                        Class clazz = this.m_callingTask.loadClass(string21);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MetadataException("Can't find class-ref '" + string21 + "' in reference-descriptor '" + string2 + "'.");
                    }
                }
                case 27: {
                    Object object;
                    if (this.m_currentClass == null) break;
                    string2 = attributes.getValue(this.tags.getTagById(16));
                    this.confirmFieldExists(this.m_currentClass, string2);
                    String string22 = attributes.getValue(this.tags.getTagById(37));
                    if (string22 != null) {
                        try {
                            object = this.m_callingTask.loadClass(string22);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new MetadataException("Can't find collection-class '" + string22 + "' in collection-descriptor '" + string2 + "'.");
                        }
                    }
                    if ((object = attributes.getValue(this.tags.getTagById(29))) == null) break;
                    try {
                        Class clazz = this.m_callingTask.loadClass((String)object);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MetadataException("Can't find element-class-ref '" + (String)object + "' in collection-descriptor '" + string2 + "'.");
                    }
                }
            }
        }
        catch (MetadataException metadataException) {
            this.m_callingTask.logWarning(" --> Mapping Error: " + metadataException.getMessage());
            this.m_VerifyExceptions.add(metadataException);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLWarning sQLWarning) {
            this.m_callingTask.logInfo(" --> DB Mapping Warning: " + sQLWarning.getMessage());
            this.m_VerifyWarnings.add(sQLWarning);
        }
        catch (SQLException sQLException) {
            this.m_callingTask.logWarning(" --> DB Mapping Error: " + sQLException.getMessage());
            this.m_VerifyExceptions.add(sQLException);
        }
        catch (Exception exception) {
            this.logger.error(exception);
            throw new PersistenceBrokerException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) {
        try {
            switch (this.getLiteralId(string3)) {
                case 0: {
                    if (this.m_dBUtility == null) break;
                    this.m_dBUtility.release();
                    break;
                }
                case 1: {
                    break;
                }
                case 12: {
                    this.m_currentClass = null;
                    this.m_CurrentTable = null;
                    this.m_currentTableExists = false;
                    this.m_CurrentCLD = null;
                    break;
                }
                case 33: {
                    break;
                }
                case 15: {
                    this.m_CurrentFLD = null;
                    break;
                }
                case 20: {
                    this.m_CurrentORD = null;
                    break;
                }
                case 27: 
                case 49: {
                    this.m_CurrentCOD = null;
                    break;
                }
                case 38: {
                    break;
                }
                case 41: {
                    break;
                }
                case 40: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(cArray, n, n2) : this.m_CurrentString + new String(cArray, n, n2);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        try {
            if (this.m_dBUtility != null) {
                this.m_dBUtility.release();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        try {
            if (this.m_dBUtility != null) {
                this.m_dBUtility.release();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private int getIsoLevel(String string) {
        if (string.equalsIgnoreCase("read-uncommitted")) {
            return 2;
        }
        if (string.equalsIgnoreCase("read-committed")) {
            return 3;
        }
        if (string.equalsIgnoreCase("repeatable-read")) {
            return 5;
        }
        if (string.equalsIgnoreCase("serializable")) {
            return 7;
        }
        if (string.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        return this.defIsoLevel;
    }

    public int getErrorCount() {
        return this.m_VerifyExceptions.size();
    }

    public int getWarningCount() {
        return this.m_VerifyWarnings.size();
    }

    private DBUtility getDBUtility(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws MetadataException, MalformedURLException, ClassNotFoundException {
        String string;
        String string2;
        String string3;
        String string4;
        DBUtility dBUtility = null;
        if (this.m_callingTask.hasConnectionInfo()) {
            this.m_callingTask.logWarning("Using DB conection info from Ant task.");
            string4 = this.m_callingTask.getJdbcDriver();
            string3 = this.m_callingTask.getLogon();
            string2 = this.m_callingTask.getPassword();
            string = this.m_callingTask.getUrl();
        } else {
            this.m_callingTask.logWarning("Using DB conection info from ojb repository connection descriptor.");
            string4 = jdbcConnectionDescriptor.getDriver();
            string3 = jdbcConnectionDescriptor.getUserName();
            string2 = jdbcConnectionDescriptor.getPassWord();
            string = jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + jdbcConnectionDescriptor.getDbAlias();
        }
        try {
            Class clazz = this.m_callingTask.loadClass(string4);
            DriverManager.registerDriver((Driver)clazz.newInstance());
            dBUtility = new DBUtility(string, string3, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MetadataException("Could not connect to database with url (" + string + "), driver (" + string4 + "), logon (" + string3 + "), password (" + string2 + ").", exception);
        }
        return dBUtility;
    }

    private Constructor getPersistenceClassConstructor() throws NoSuchMethodException {
        if (this.m_persistConstructor == null) {
            Class clazz = this.m_callingTask.getPersistentFieldClass();
            Class[] classArray = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = RepositoryVerifierHandler.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = RepositoryVerifierHandler.class$("java.lang.String")) : class$java$lang$String};
            this.m_persistConstructor = clazz.getConstructor(classArray);
        }
        return this.m_persistConstructor;
    }

    protected void confirmFieldExists(Class clazz, String string) throws MetadataException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object[] objectArray = new Object[]{clazz, string};
        try {
            this.getPersistenceClassConstructor().newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MetadataException(invocationTargetException.getTargetException().getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

