/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryFactory;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.interceptor.InterceptorFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactoryBaseImpl
implements PersistenceBrokerFactoryIF {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl);
    private Class implementationClass;
    private long instanceCount;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF;

    public PersistenceBrokerFactoryBaseImpl() {
        this.configure(OjbConfigurator.getInstance().getConfigurationFor(null));
    }

    public void setDefaultKey(PBKey pBKey) {
        try {
            MetadataManager.getInstance().setDefaultPBKey(pBKey);
        }
        catch (Exception exception) {
            throw new PBFactoryException(exception);
        }
    }

    public PBKey getDefaultKey() {
        return MetadataManager.getInstance().getDefaultPBKey();
    }

    protected PersistenceBrokerInternal createNewBrokerInstance(PBKey pBKey) throws PBFactoryException {
        if (pBKey == null) {
            throw new PBFactoryException("Could not create new broker with PBkey argument 'null'");
        }
        if (MetadataManager.getInstance().connectionRepository().getDescriptor(pBKey) == null) {
            throw new PBFactoryException("Given PBKey " + pBKey + " does not match in metadata configuration");
        }
        if (log.isEnabledFor(2)) {
            log.info("Create new PB instance for PBKey " + pBKey + ", already created persistence broker instances: " + this.instanceCount);
            ++this.instanceCount;
        }
        PersistenceBrokerInternal persistenceBrokerInternal = null;
        Class[] classArray = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryIF")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF};
        Object[] objectArray = new Object[]{pBKey, this};
        try {
            persistenceBrokerInternal = (PersistenceBrokerInternal)ClassHelper.newInstance(this.implementationClass, classArray, objectArray);
            OjbConfigurator.getInstance().configure(persistenceBrokerInternal);
            persistenceBrokerInternal = (PersistenceBrokerInternal)InterceptorFactory.getInstance().createInterceptorFor(persistenceBrokerInternal);
        }
        catch (Exception exception) {
            log.error("Creation of a new PB instance failed", exception);
            throw new PBFactoryException("Creation of a new PB instance failed", exception);
        }
        return persistenceBrokerInternal;
    }

    public PersistenceBrokerInternal createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pBKey);
        }
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        try {
            return this.createNewBrokerInstance(pBKey);
        }
        catch (Exception exception) {
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pBKey, exception);
        }
    }

    public PersistenceBrokerInternal createPersistenceBroker(String string, String string2, String string3) throws PBFactoryException {
        return this.createPersistenceBroker(new PBKey(string, string2, string3));
    }

    public PersistenceBrokerInternal defaultPersistenceBroker() throws PBFactoryException {
        if (this.getDefaultKey() == null) {
            throw new PBFactoryException("There was no 'default-connection' attribute enabled in the jdbc connection descriptor");
        }
        return this.createPersistenceBroker(this.getDefaultKey());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.implementationClass = ((PersistenceBrokerConfiguration)((Object)configuration)).getPersistenceBrokerClass();
    }

    public synchronized void releaseAllInstances() {
        this.instanceCount = 0L;
    }

    public int activePersistenceBroker() {
        return 0;
    }

    public void shutdown() {
        try {
            ConnectionFactoryFactory.getInstance().createConnectionFactory().releaseAllResources();
            PersistenceBrokerThreadMapping.shutdown();
            MetadataManager.getInstance().shutdown();
        }
        catch (RuntimeException runtimeException) {
            log.error("Error while shutdown of OJB", runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

