/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.DelegatingPersistenceBroker;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactorySyncImpl
extends PersistenceBrokerFactoryDefaultImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl);
    private TransactionManager txMan;
    private TxRegistry txRegistry;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl;
    static /* synthetic */ Class class$javax$transaction$Status;

    public PersistenceBrokerFactorySyncImpl() {
        try {
            this.txMan = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException transactionManagerFactoryException) {
            throw new PBFactoryException("Can't instantiate TransactionManager of managed environment", (Throwable)((Object)transactionManagerFactoryException));
        }
        this.txRegistry = new TxRegistry();
    }

    public PersistenceBrokerInternal createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        Transaction transaction;
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        try {
            transaction = this.searchForValidTx();
        }
        catch (SystemException systemException) {
            throw new PBFactoryException("Can't create PB instance, failure while lookup running JTA transaction", systemException);
        }
        DelegatingPersistenceBroker delegatingPersistenceBroker = null;
        if (transaction != null) {
            delegatingPersistenceBroker = this.txRegistry.findBroker(transaction, pBKey);
        }
        PersistenceBrokerSyncHandle persistenceBrokerSyncHandle = delegatingPersistenceBroker == null || delegatingPersistenceBroker.isClosed() ? (PersistenceBrokerSyncHandle)super.createPersistenceBroker(pBKey) : new PersistenceBrokerSyncHandle((PersistenceBrokerSyncImpl)delegatingPersistenceBroker);
        return persistenceBrokerSyncHandle;
    }

    protected PersistenceBrokerInternal wrapBrokerWithPoolingHandle(PersistenceBrokerInternal persistenceBrokerInternal, KeyedObjectPool keyedObjectPool) {
        return new PersistenceBrokerSyncImpl(persistenceBrokerInternal, keyedObjectPool);
    }

    protected PersistenceBrokerInternal wrapRequestedBrokerInstance(PersistenceBrokerInternal persistenceBrokerInternal) {
        PersistenceBrokerSyncImpl persistenceBrokerSyncImpl;
        block8: {
            if (!(persistenceBrokerInternal instanceof PersistenceBrokerSyncImpl)) {
                throw new PBFactoryException("Expect instance of " + (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl) + ", found " + persistenceBrokerInternal.getClass());
            }
            persistenceBrokerSyncImpl = (PersistenceBrokerSyncImpl)persistenceBrokerInternal;
            try {
                Transaction transaction = this.searchForValidTx();
                if (transaction == null) break block8;
                this.txRegistry.register(transaction, persistenceBrokerSyncImpl);
                try {
                    persistenceBrokerSyncImpl.internBegin();
                }
                catch (Exception exception) {
                    this.log.error("Unexpected exception when start intern pb-tx", exception);
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new PBFactoryException("Unexpected exception when start intern pb-tx", exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof PBFactoryException) {
                    throw (PBFactoryException)((Object)exception);
                }
                throw new PBFactoryException("Error while try to participate in JTA transaction", exception);
            }
        }
        return new PersistenceBrokerSyncHandle(persistenceBrokerSyncImpl);
    }

    private Transaction searchForValidTx() throws SystemException {
        int n;
        Transaction transaction = this.txMan.getTransaction();
        if (transaction != null && (n = transaction.getStatus()) != 0 && n != 6) {
            throw new PBFactoryException("Transaction synchronization failed - wrong status of external JTA tx. Expected was an 'active' or 'no transaction', found status is '" + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(n) + "'");
        }
        return transaction;
    }

    private static String getStatusFlagAsString(int n) {
        String string = "no match, unknown status!";
        try {
            Field[] fieldArray = (class$javax$transaction$Status == null ? (class$javax$transaction$Status = PersistenceBrokerFactorySyncImpl.class$("javax.transaction.Status")) : class$javax$transaction$Status).getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getInt(null) != n) continue;
                string = fieldArray[i].getName();
                break;
            }
        }
        catch (Exception exception) {
            string = "no match, unknown status!";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PersistenceBrokerSyncHandle
    extends PersistenceBrokerHandle {
        public PersistenceBrokerSyncHandle(PersistenceBrokerSyncImpl persistenceBrokerSyncImpl) {
            super(persistenceBrokerSyncImpl);
            persistenceBrokerSyncImpl.registerHandle(this);
        }

        public boolean isClosed() {
            return super.isClosed();
        }

        public boolean close() {
            if (this.getDelegate() != null) {
                ((PersistenceBrokerSyncImpl)this.getDelegate()).deregisterHandle(this);
            }
            return super.close();
        }
    }

    class TxRegistry {
        Map txBoxMap = Collections.synchronizedMap(new WeakHashMap());

        void register(Transaction transaction, PersistenceBrokerSyncImpl persistenceBrokerSyncImpl) throws RollbackException, SystemException {
            TransactionBox transactionBox = (TransactionBox)this.txBoxMap.get(transaction);
            if (transactionBox == null || transactionBox.isClosed) {
                if (transactionBox != null) {
                    this.txBoxMap.remove(transaction);
                }
                transactionBox = new TransactionBox(transaction);
                transaction.registerSynchronization((Synchronization)transactionBox);
                this.txBoxMap.put(transaction, transactionBox);
            }
            transactionBox.add(persistenceBrokerSyncImpl);
        }

        PersistenceBrokerSyncImpl findBroker(Transaction transaction, PBKey pBKey) {
            PersistenceBrokerSyncImpl persistenceBrokerSyncImpl = null;
            TransactionBox transactionBox = (TransactionBox)this.txBoxMap.get(transaction);
            if (transactionBox != null) {
                persistenceBrokerSyncImpl = transactionBox.find(pBKey);
            }
            return persistenceBrokerSyncImpl;
        }

        TransactionBox findTxBox(Transaction transaction) {
            return (TransactionBox)this.txBoxMap.get(transaction);
        }

        void removeTxBox(Transaction transaction) {
            this.txBoxMap.remove(transaction);
        }
    }

    class TransactionBox
    implements Synchronization {
        Transaction jtaTx;
        Map syncMap = new HashMap();
        boolean isLocked = false;
        boolean isClosed = false;

        public TransactionBox(Transaction transaction) {
            this.jtaTx = transaction;
        }

        PersistenceBrokerSyncImpl find(PBKey pBKey) {
            return (PersistenceBrokerSyncImpl)this.syncMap.get(pBKey);
        }

        void add(PersistenceBrokerSyncImpl persistenceBrokerSyncImpl) {
            if (this.isLocked) {
                throw new PBFactoryException("Can't associate object with JTA transaction, because tx-completion started");
            }
            this.syncMap.put(persistenceBrokerSyncImpl.getPBKey(), persistenceBrokerSyncImpl);
        }

        public void afterCompletion(int n) {
            boolean bl = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.afterCompletion(n);
                }
                catch (Exception exception) {
                    bl = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#afterCompletion method call on object " + synchronization, exception);
                }
            }
            this.isClosed = true;
            PersistenceBrokerFactorySyncImpl.this.txRegistry.removeTxBox(this.jtaTx);
            if (bl) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#afterCompletion method");
            }
        }

        public void beforeCompletion() {
            boolean bl = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.beforeCompletion();
                }
                catch (Exception exception) {
                    bl = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#beforeCompletion method call on object " + synchronization, exception);
                }
            }
            this.isLocked = true;
            if (bl) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#beforeCompletion method");
            }
        }
    }

    public static class PersistenceBrokerSyncImpl
    extends PoolablePersistenceBroker
    implements Synchronization {
        private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl);
        private List handleList = new ArrayList();

        public PersistenceBrokerSyncImpl(PersistenceBrokerInternal persistenceBrokerInternal, KeyedObjectPool keyedObjectPool) {
            super(persistenceBrokerInternal, keyedObjectPool);
        }

        public void beforeCompletion() {
            ConnectionManagerIF connectionManagerIF;
            if (this.log.isDebugEnabled()) {
                this.log.debug("beforeCompletion was called, nothing to do");
            }
            if (this.handleList.size() > 0) {
                for (int i = 0; i < this.handleList.size(); ++i) {
                    this.log.warn("Found unclosed PersistenceBroker handle, will do automatic close. Please make sure that all used PB instances will be closed.");
                    PersistenceBrokerHandle persistenceBrokerHandle = (PersistenceBrokerHandle)this.handleList.get(i);
                    persistenceBrokerHandle.close();
                }
                this.handleList.clear();
            }
            if ((connectionManagerIF = this.serviceConnectionManager()).isBatchMode()) {
                connectionManagerIF.executeBatch();
            }
            if (connectionManagerIF.isInLocalTransaction()) {
                this.log.warn("Seems the used PersistenceBroker handle wasn't closed, close the used handle before the transaction completes.");
                connectionManagerIF.localCommit();
            }
            connectionManagerIF.releaseConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int n) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("afterCompletion was called");
            }
            try {
                if (n != 3) {
                    if (n == 4 || n == 9) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Aborting PB-tx due to JTA initiated Rollback: " + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(n));
                        }
                    } else {
                        this.log.error("Aborting PB-tx due to inconsistent, and unexpected, status of JTA tx: " + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(n));
                    }
                    this.internAbort();
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Commit PB-tx");
                    }
                    this.internCommit();
                }
            }
            finally {
                this.doRealClose();
            }
        }

        private void internBegin() {
            this.setManaged(true);
            super.beginTransaction();
        }

        private void internCommit() {
            super.commitTransaction();
        }

        private void internAbort() {
            super.abortTransaction();
        }

        private void doRealClose() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Now do real close of PB instance");
            }
            super.close();
        }

        public boolean close() {
            if (!this.isInTransaction()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, pass the close call to underlying PB instance");
                }
                this.doRealClose();
            } else if (this.handleList.size() > 0) {
                if (this.log.isEnabledFor(2)) {
                    this.log.info("PB.close(): Active used by " + this.handleList.size() + " handle objects, will skip close call");
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, only close the PB handle when in JTA-tx");
                }
                PersistenceBrokerImpl persistenceBrokerImpl = (PersistenceBrokerImpl)this.getInnermostDelegate();
                persistenceBrokerImpl.fireBrokerEvent(persistenceBrokerImpl.BEFORE_CLOSE_EVENT);
                ConnectionManagerIF connectionManagerIF = this.serviceConnectionManager();
                if (connectionManagerIF.isInLocalTransaction()) {
                    connectionManagerIF.localCommit();
                }
                connectionManagerIF.releaseConnection();
            }
            return true;
        }

        void registerHandle(PersistenceBrokerHandle persistenceBrokerHandle) {
            this.handleList.add(persistenceBrokerHandle);
        }

        void deregisterHandle(PersistenceBrokerHandle persistenceBrokerHandle) {
            this.handleList.remove(persistenceBrokerHandle);
        }

        public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void abortTransaction() throws TransactionNotInProgressException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }
    }
}

