/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.OJBSerializableProxy;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractIndirectionHandler
implements IndirectionHandler {
    static final long serialVersionUID = -1993879565033755826L;
    private PBKey _brokerKey;
    private Object _realSubject = null;
    private Identity _id = null;
    private transient ArrayList _listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$proxy$IndirectionHandler;

    public AbstractIndirectionHandler(PBKey pBKey, Identity identity) {
        this.setBrokerKey(pBKey);
        this.setIdentity(identity);
    }

    public Identity getIdentity() {
        return this._id;
    }

    protected void setIdentity(Identity identity) {
        this._id = identity;
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this._brokerKey = pBKey;
    }

    public synchronized void addListener(MaterializationListener materializationListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(materializationListener)) {
            this._listeners.add(materializationListener);
        }
    }

    public synchronized void removeListener(MaterializationListener materializationListener) {
        if (this._listeners != null) {
            this._listeners.remove(materializationListener);
        }
    }

    protected void beforeMaterialization() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this._listeners.get(i);
                materializationListener.beforeMaterialization(this, this._id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this._listeners != null) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this._listeners.get(i);
                materializationListener.afterMaterialization(this, this._realSubject);
            }
        }
    }

    protected TemporaryBrokerWrapper getBroker() throws PBFactoryException {
        boolean bl = false;
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBrokerInternal persistenceBrokerInternal = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBrokerInternal == null || persistenceBrokerInternal.isClosed()) {
            persistenceBrokerInternal = (PersistenceBrokerInternal)PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            bl = true;
        }
        return new TemporaryBrokerWrapper(persistenceBrokerInternal, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        try {
            if ("finalize".equals(string) && this._realSubject == null) {
                return null;
            }
            if ("writeReplace".equals(string)) {
                if (this._realSubject == null) {
                    return this.generateSerializableProxy();
                }
                return this.getRealSubject();
            }
            if ("equals".equals(string) && objectArray[0] != null) {
                TemporaryBrokerWrapper temporaryBrokerWrapper = this.getBroker();
                try {
                    objectArray[0] = temporaryBrokerWrapper.broker.getProxyFactory().getRealObject(objectArray[0]);
                }
                finally {
                    temporaryBrokerWrapper.close();
                }
            }
            if ("getIndirectionHandler".equals(string) && objectArray[0] != null) {
                return this;
            }
            Object object2 = this.getRealSubject();
            return method.invoke(object2, objectArray);
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Error invoking method " + method.getName(), exception);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this._realSubject == null) {
            this.beforeMaterialization();
            this._realSubject = this.materializeSubject();
            this.afterMaterialization();
        }
        return this._realSubject;
    }

    public void setRealSubject(Object object) {
        this._realSubject = object;
    }

    protected synchronized Object materializeSubject() throws PersistenceBrokerException {
        TemporaryBrokerWrapper temporaryBrokerWrapper = this.getBroker();
        try {
            Object object = temporaryBrokerWrapper.broker.getObjectByIdentity(this._id);
            if (object == null) {
                LoggerFactory.getLogger(class$org$apache$ojb$broker$core$proxy$IndirectionHandler == null ? (class$org$apache$ojb$broker$core$proxy$IndirectionHandler = AbstractIndirectionHandler.class$("org.apache.ojb.broker.core.proxy.IndirectionHandler")) : class$org$apache$ojb$broker$core$proxy$IndirectionHandler).warn("Can not materialize object for Identity " + this._id + " - using PBKey " + this.getBrokerKey());
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            temporaryBrokerWrapper.close();
        }
    }

    public boolean alreadyMaterialized() {
        return this._realSubject != null;
    }

    private Object generateSerializableProxy() {
        return new OJBSerializableProxy(this.getIdentity().getObjectsRealClass(), this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class TemporaryBrokerWrapper {
        boolean needsClose;
        PersistenceBrokerInternal broker;

        public TemporaryBrokerWrapper(PersistenceBrokerInternal persistenceBrokerInternal, boolean bl) {
            this.broker = persistenceBrokerInternal;
            this.needsClose = bl;
        }

        public void close() {
            if (this.needsClose) {
                this.broker.close();
            }
        }
    }
}

