/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.ojb.broker.locking.CommonsOJBLockManager;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerCommonsImpl
implements LockManager {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$locking$LockManagerCommonsImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl = LockManagerCommonsImpl.class$("org.apache.ojb.broker.locking.LockManagerCommonsImpl")) : class$org$apache$ojb$broker$locking$LockManagerCommonsImpl);
    private long lockTimeout = 60000L;
    private long blockTimeout = 1000L;
    private LoggerFacade logFacade = new LoggerFacadeImpl();
    private OJBLockManager lm = new OJBLockManager(this.logFacade, this.blockTimeout, 500L);
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerCommonsImpl;

    private boolean ignore(int n) {
        return n == 4 || n == -1;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long l) {
        this.lockTimeout = l;
    }

    public long getBlockTimeout() {
        return this.blockTimeout;
    }

    public void setBlockTimeout(long l) {
        this.blockTimeout = l;
    }

    public String getLockInfo() {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer("Class: " + (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerCommonsImpl = LockManagerCommonsImpl.class$("org.apache.ojb.broker.locking.LockManagerCommonsImpl")) : class$org$apache$ojb$broker$locking$LockManagerCommonsImpl).getName() + string);
        stringBuffer.append("lock timeout: " + this.getLockTimeout() + " [ms]" + string);
        stringBuffer.append("block timeout: " + this.getBlockTimeout() + " [ms]" + string);
        stringBuffer.append("commons-tx lock-manger info ==> " + string);
        stringBuffer.append((Object)this.lm);
        return stringBuffer.toString();
    }

    public boolean readLock(Object object, Object object2, int n) {
        return this.ignore(n) ? true : this.lm.readLock(object, object2, new Integer(n), this.blockTimeout);
    }

    public boolean writeLock(Object object, Object object2, int n) {
        return this.ignore(n) ? true : this.lm.writeLock(object, object2, new Integer(n), this.blockTimeout);
    }

    public boolean upgradeLock(Object object, Object object2, int n) {
        return this.ignore(n) ? true : this.lm.upgradeLock(object, object2, new Integer(n), this.blockTimeout);
    }

    public boolean releaseLock(Object object, Object object2) {
        boolean bl = true;
        try {
            this.lm.release(object, object2);
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Can't release lock for owner key " + object + ", on resource " + object2, runtimeException);
            bl = false;
        }
        return bl;
    }

    public void releaseLocks(Object object) {
        try {
            this.lm.releaseAll(object);
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Can't release all locks for owner key " + object, runtimeException);
        }
    }

    public boolean hasRead(Object object, Object object2) {
        return this.lm.hasRead(object, object2);
    }

    public boolean hasWrite(Object object, Object object2) {
        return this.lm.hasWrite(object, object2);
    }

    public boolean hasUpgrade(Object object, Object object2) {
        return this.lm.hasUpgrade(object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class LoggerFacadeImpl
    implements LoggerFacade {
        LoggerFacadeImpl() {
        }

        public LoggerFacade createLogger(String string) {
            return this;
        }

        public void logInfo(String string) {
            LockManagerCommonsImpl.this.log.info(string);
        }

        public void logFine(String string) {
            LockManagerCommonsImpl.this.log.debug(string);
        }

        public boolean isFineEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logFiner(String string) {
            LockManagerCommonsImpl.this.log.debug(string);
        }

        public boolean isFinerEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logFinest(String string) {
            LockManagerCommonsImpl.this.log.debug(string);
        }

        public boolean isFinestEnabled() {
            return LockManagerCommonsImpl.this.log.isDebugEnabled();
        }

        public void logWarning(String string) {
            LockManagerCommonsImpl.this.log.warn(string);
        }

        public void logWarning(String string, Throwable throwable) {
            LockManagerCommonsImpl.this.log.warn(string, throwable);
        }

        public void logSevere(String string) {
            LockManagerCommonsImpl.this.log.error(string);
        }

        public void logSevere(String string, Throwable throwable) {
            LockManagerCommonsImpl.this.log.error(string, throwable);
        }
    }

    final class OJBLockManager
    extends CommonsOJBLockManager {
        public OJBLockManager(LoggerFacade loggerFacade, long l, long l2) throws IllegalArgumentException {
            super(loggerFacade, l, l2);
        }

        private CommonsOJBLockManager.OJBLock lookupLock(Object object) {
            return (CommonsOJBLockManager.OJBLock)this.getLock(object);
        }

        boolean readLock(Object object, Object object2, Integer n, long l) {
            int n2 = this.mapLockLevelDependendOnIsolationLevel(n, 101);
            return this.tryLock(object, object2, n2, true, n);
        }

        boolean writeLock(Object object, Object object2, Integer n, long l) {
            try {
                int n2 = this.mapLockLevelDependendOnIsolationLevel(n, 107);
                this.lock(object, object2, n2, 1, false, l, n);
                return true;
            }
            catch (LockException lockException) {
                if (LockManagerCommonsImpl.this.log.isEnabledFor(2)) {
                    LockManagerCommonsImpl.this.log.info("Can't get write lock for " + object, lockException);
                }
                return false;
            }
        }

        boolean upgradeLock(Object object, Object object2, Integer n, long l) {
            try {
                int n2 = this.mapLockLevelDependendOnIsolationLevel(n, 113);
                this.lock(object, object2, n2, 1, false, l, n);
                return true;
            }
            catch (LockException lockException) {
                if (LockManagerCommonsImpl.this.log.isEnabledFor(2)) {
                    LockManagerCommonsImpl.this.log.info("Can't get upgrade lock for " + object, lockException);
                }
                return false;
            }
        }

        boolean hasRead(Object object, Object object2) {
            CommonsOJBLockManager.OJBLock oJBLock = this.lookupLock(object2);
            boolean bl = false;
            if (oJBLock != null) {
                bl = oJBLock.hasRead(object);
            }
            return bl;
        }

        boolean hasWrite(Object object, Object object2) {
            CommonsOJBLockManager.OJBLock oJBLock = this.lookupLock(object2);
            boolean bl = false;
            if (oJBLock != null) {
                bl = oJBLock.hasWrite(object);
            }
            return bl;
        }

        boolean hasUpgrade(Object object, Object object2) {
            CommonsOJBLockManager.OJBLock oJBLock = this.lookupLock(object2);
            boolean bl = false;
            if (oJBLock != null) {
                bl = oJBLock.hasUpgrade(object);
            }
            return bl;
        }
    }
}

