/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.locking.IsolationLevels;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public final class DescriptorRepository
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    static final long serialVersionUID = -1556339982311359524L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = DescriptorRepository.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
    private static final String VERSION = "1.0";
    private int defaultIsolationLevel = 2;
    private final HashMap descriptorTable = new HashMap();
    private Map extentTable = new HashMap();
    private Map superClassMultipleJoinedTablesMap = new HashMap();
    private transient Map m_multiMappedTableMap;
    private transient Map m_topLevelClassTable;
    private transient Map m_firstConcreteClassMap;
    private transient Map m_allConcreteSubClass;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$DescriptorRepository;

    public static String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExtent(String string, ClassDescriptor classDescriptor) {
        Map map = this.extentTable;
        synchronized (map) {
            this.extentTable.put(string, classDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtent(String string) {
        Map map = this.extentTable;
        synchronized (map) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.extentTable.remove(string);
            if (classDescriptor != null && this.m_topLevelClassTable != null) {
                Class clazz = null;
                try {
                    clazz = ClassHelper.getClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MetadataException("Can't instantiate class object for needed extent remove", classNotFoundException);
                }
                classDescriptor.removeExtentClass(string);
                this.m_topLevelClassTable.remove(clazz);
                this.m_firstConcreteClassMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getTopLevelClass(Class clazz) throws ClassNotPersistenceCapableException {
        Class clazz2;
        if (this.m_topLevelClassTable == null) {
            this.m_topLevelClassTable = new HashMap();
        }
        if ((clazz2 = (Class)this.m_topLevelClassTable.get(clazz)) == null) {
            Map map = this.extentTable;
            synchronized (map) {
                ClassDescriptor classDescriptor = (ClassDescriptor)this.extentTable.get(clazz.getName());
                if (classDescriptor == null) {
                    classDescriptor = this.getDescriptorFor(clazz).getSuperClassDescriptor();
                }
                if (classDescriptor != null) {
                    clazz2 = this.getTopLevelClass(classDescriptor.getClassOfObject());
                    if (clazz2 == null) {
                        clazz2 = clazz;
                    }
                } else {
                    ClassDescriptor classDescriptor2 = this.getDescriptorFor(clazz);
                    clazz2 = classDescriptor2.getClassOfObject();
                }
                this.m_topLevelClassTable.put(clazz, clazz2);
            }
        }
        return clazz2;
    }

    public synchronized FieldDescriptor[] getFieldDescriptorsForMultiMappedTable(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray;
        if (this.m_multiMappedTableMap == null) {
            this.m_multiMappedTableMap = new HashMap();
        }
        if ((fieldDescriptorArray = (FieldDescriptor[])this.m_multiMappedTableMap.get(classDescriptor.getClassNameOfObject())) == null) {
            fieldDescriptorArray = this.getAllMappedColumns(this.getClassesMappedToSameTable(classDescriptor));
            this.m_multiMappedTableMap.put(classDescriptor.getClassNameOfObject(), fieldDescriptorArray);
        }
        return fieldDescriptorArray;
    }

    private FieldDescriptor[] getAllMappedColumns(List list) {
        Vector<FieldDescriptor> vector = new Vector<FieldDescriptor>();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        ClassDescriptor classDescriptor = null;
        while (iterator.hasNext()) {
            classDescriptor = (ClassDescriptor)iterator.next();
            FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
            if (fieldDescriptorArray == null) continue;
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                String string = fieldDescriptorArray[i].getColumnName();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                vector.add(fieldDescriptorArray[i]);
            }
        }
        FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[vector.size()];
        vector.toArray(fieldDescriptorArray);
        return fieldDescriptorArray;
    }

    private List getClassesMappedToSameTable(ClassDescriptor classDescriptor) {
        Iterator iterator = ((HashMap)this.descriptorTable.clone()).values().iterator();
        ArrayList<ClassDescriptor> arrayList = new ArrayList<ClassDescriptor>();
        arrayList.add(classDescriptor);
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
            if (classDescriptor2.getFullTableName() == null || !classDescriptor2.getFullTableName().equals(classDescriptor.getFullTableName()) || classDescriptor.getClassOfObject().equals(classDescriptor2.getClassOfObject())) continue;
            arrayList.add(classDescriptor2);
        }
        return arrayList;
    }

    public Map getDescriptorTable() {
        return this.descriptorTable;
    }

    public ClassDescriptor findFirstConcreteClass(ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2;
        if (this.m_firstConcreteClassMap == null) {
            this.m_firstConcreteClassMap = new HashMap();
        }
        if ((classDescriptor2 = (ClassDescriptor)this.m_firstConcreteClassMap.get(classDescriptor.getClassNameOfObject())) == null) {
            if (classDescriptor.isInterface() || classDescriptor.isAbstract()) {
                if (classDescriptor.isExtent()) {
                    Class clazz;
                    Vector vector = classDescriptor.getExtentClasses();
                    for (int i = 0; i < vector.size() && (classDescriptor2 = this.findFirstConcreteClass(this.getDescriptorFor(clazz = (Class)vector.get(i)))) == null; ++i) {
                    }
                } else {
                    LoggerFactory.getDefaultLogger().error("[" + this.getClass().getName() + "] Found interface/abstract class" + " in metadata declarations without concrete class: " + classDescriptor.getClassNameOfObject());
                }
                this.m_firstConcreteClassMap.put(classDescriptor.getClassNameOfObject(), classDescriptor2);
            } else {
                classDescriptor2 = classDescriptor;
            }
        }
        return classDescriptor2;
    }

    public Collection getAllConcreteSubclassDescriptors(ClassDescriptor classDescriptor) {
        ArrayList<ClassDescriptor> arrayList;
        if (this.m_allConcreteSubClass == null) {
            this.m_allConcreteSubClass = new HashMap();
        }
        if ((arrayList = (ArrayList<ClassDescriptor>)this.m_allConcreteSubClass.get(classDescriptor.getClassOfObject())) == null) {
            arrayList = new ArrayList<ClassDescriptor>();
            Iterator iterator = classDescriptor.getExtentClasses().iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                ClassDescriptor classDescriptor2 = this.getDescriptorFor(clazz);
                if (classDescriptor.equals(classDescriptor2)) continue;
                if (!(classDescriptor2.isInterface() || classDescriptor2.isAbstract() || arrayList.contains(classDescriptor2))) {
                    arrayList.add(classDescriptor2);
                }
                Iterator iterator2 = this.getAllConcreteSubclassDescriptors(classDescriptor2).iterator();
                while (iterator2.hasNext()) {
                    ClassDescriptor classDescriptor3 = (ClassDescriptor)iterator2.next();
                    if (arrayList.contains(classDescriptor3)) continue;
                    arrayList.add(classDescriptor3);
                }
            }
            this.m_allConcreteSubClass.put(classDescriptor.getClassOfObject(), arrayList);
        }
        return arrayList;
    }

    public boolean hasDescriptorFor(Class clazz) {
        return this.descriptorTable.containsKey(clazz.getName());
    }

    public ClassDescriptor getDescriptorFor(String string) throws ClassNotPersistenceCapableException {
        ClassDescriptor classDescriptor = this.discoverDescriptor(string);
        if (classDescriptor == null) {
            throw new ClassNotPersistenceCapableException(string + " not found in OJB Repository");
        }
        return classDescriptor;
    }

    public ClassDescriptor getDescriptorFor(Class clazz) throws ClassNotPersistenceCapableException {
        return this.getDescriptorFor(clazz.getName());
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.put(classDescriptor.getClassNameOfObject(), classDescriptor);
    }

    public void put(Class clazz, ClassDescriptor classDescriptor) {
        this.put(clazz.getName(), classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, ClassDescriptor classDescriptor) {
        classDescriptor.setRepository(this);
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            this.descriptorTable.put(string, classDescriptor);
            Vector vector = classDescriptor.getExtentClasses();
            for (int i = 0; i < vector.size(); ++i) {
                this.addExtent(((Class)vector.get(i)).getName(), classDescriptor);
            }
            this.changeDescriptorEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.remove(string);
            if (classDescriptor != null) {
                Iterator iterator = this.descriptorTable.values().iterator();
                while (iterator.hasNext()) {
                    ((ClassDescriptor)iterator.next()).removeExtentClass(string);
                }
                this.removeExtent(string);
                Vector vector = classDescriptor.getExtentClasses();
                for (int i = 0; i < vector.size(); ++i) {
                    this.removeExtent(((Class)vector.get(i)).getName());
                }
                this.changeDescriptorEvent();
                this.deregisterSuperClassMultipleJoinedTables(classDescriptor);
            }
        }
    }

    public void remove(Class clazz) {
        this.remove(clazz.getName());
    }

    private synchronized void changeDescriptorEvent() {
        this.m_multiMappedTableMap = null;
        this.m_topLevelClassTable = null;
        this.m_firstConcreteClassMap = null;
        this.m_allConcreteSubClass = null;
    }

    public Iterator iterator() {
        return ((HashMap)this.descriptorTable.clone()).values().iterator();
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    public String toString() {
        Iterator iterator = this.descriptorTable.entrySet().iterator();
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        String string = "class name: ";
        String string2 = "> table name: ";
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClassDescriptor classDescriptor = (ClassDescriptor)entry.getValue();
            toStringBuilder.append(string + entry.getKey() + " =", (Object)(string2 + classDescriptor.getFullTableName()));
        }
        return toStringBuilder.toString();
    }

    public String toXML() {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((XmlCapable)iterator.next()).toXML() + string);
        }
        return stringBuffer.toString();
    }

    protected String getIsolationLevelAsString() {
        if (this.defaultIsolationLevel == 2) {
            return "read-uncommitted";
        }
        if (this.defaultIsolationLevel == 3) {
            return "read-committed";
        }
        if (this.defaultIsolationLevel == 5) {
            return "repeatable-read";
        }
        if (this.defaultIsolationLevel == 7) {
            return "serializable";
        }
        if (this.defaultIsolationLevel == 4) {
            return "optimistic";
        }
        return "read-uncommitted";
    }

    protected ClassDescriptor discoverDescriptor(String string) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.get(string);
        if (classDescriptor == null) {
            Class clazz;
            try {
                clazz = ClassHelper.getClass(string, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OJBRuntimeException("Class, " + string + ", could not be found.", classNotFoundException);
            }
            classDescriptor = this.discoverDescriptor(clazz);
        }
        return classDescriptor;
    }

    private ClassDescriptor discoverDescriptor(Class clazz) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.get(clazz.getName());
        if (classDescriptor == null) {
            Class<?>[] classArray;
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                classDescriptor = this.discoverDescriptor(clazz2);
            }
            if (classDescriptor == null && (classArray = clazz.getInterfaces()) != null && classArray.length > 0) {
                for (int i = 0; i < classArray.length && classDescriptor == null; ++i) {
                    classDescriptor = this.discoverDescriptor(classArray[i]);
                }
            }
            if (classDescriptor != null) {
                this.descriptorTable.put(clazz.getName(), classDescriptor);
            }
        }
        return classDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSuperClassMultipleJoinedTables(ClassDescriptor classDescriptor) {
        if (classDescriptor.getBaseClass() != null) {
            try {
                Class clazz = ClassHelper.getClass(classDescriptor.getBaseClass());
                Class clazz2 = classDescriptor.getClassOfObject();
                HashMap hashMap = this.descriptorTable;
                synchronized (hashMap) {
                    ArrayList<Class> arrayList = (ArrayList<Class>)this.superClassMultipleJoinedTablesMap.get(clazz);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Class>();
                        this.superClassMultipleJoinedTablesMap.put(clazz, arrayList);
                    }
                    if (!arrayList.contains(clazz2)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("(MultipleJoinedTables): Register sub-class '" + clazz2 + "' for class '" + clazz);
                        }
                        arrayList.add(clazz2);
                    }
                }
            }
            catch (Exception exception) {
                throw new MetadataException("Can't register super class '" + classDescriptor.getBaseClass() + "' for class-descriptor: " + classDescriptor, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterSuperClassMultipleJoinedTables(ClassDescriptor classDescriptor) {
        try {
            Class clazz = classDescriptor.getClassOfObject();
            HashMap hashMap = this.descriptorTable;
            synchronized (hashMap) {
                boolean bl;
                Class clazz2;
                List list = (List)this.superClassMultipleJoinedTablesMap.remove(clazz);
                if (list != null && this.log.isDebugEnabled()) {
                    this.log.debug("(MultipleJoinedTables): Deregister class " + clazz + " with sub classes " + list);
                }
                if (classDescriptor.getBaseClass() != null && (list = (List)this.superClassMultipleJoinedTablesMap.get(clazz2 = ClassHelper.getClass(classDescriptor.getBaseClass()))) != null && (bl = list.remove(clazz)) && this.log.isDebugEnabled()) {
                    this.log.debug("(MultipleJoinedTables): Remove sub-class entry '" + clazz + "' in mapping for class '" + clazz2 + "'");
                }
            }
        }
        catch (Exception exception) {
            throw new MetadataException("Can't deregister super class '" + classDescriptor.getBaseClass() + "' for class-descriptor: " + classDescriptor, exception);
        }
    }

    public Class[] getSubClassesMultipleJoinedTables(ClassDescriptor classDescriptor, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.createResultSubClassesMultipleJoinedTables(arrayList, classDescriptor, bl);
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void createResultSubClassesMultipleJoinedTables(List list, ClassDescriptor classDescriptor, boolean bl) {
        List list2 = (List)this.superClassMultipleJoinedTablesMap.get(classDescriptor.getClassOfObject());
        if (list2 != null) {
            list.addAll(list2);
            if (bl) {
                for (int i = 0; i < list2.size(); ++i) {
                    Class clazz = (Class)list2.get(i);
                    ClassDescriptor classDescriptor2 = this.getDescriptorFor(clazz);
                    this.createResultSubClassesMultipleJoinedTables(list, classDescriptor2, bl);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.log.info("# finalize DescriptorRepository instance #");
        super.finalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

