/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import javax.sql.DataSource;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class JdbcConnectionDescriptor
extends DescriptorBase
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -600900924512028960L;
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = JdbcConnectionDescriptor.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor);
    public static final int AUTO_COMMIT_IGNORE_STATE = 0;
    public static final int AUTO_COMMIT_SET_TRUE_AND_TEMPORARY_FALSE = 1;
    public static final int AUTO_COMMIT_SET_FALSE = 2;
    private String m_jcdAlias;
    private String m_Dbms;
    private String m_Driver;
    private String m_Protocol;
    private String m_SubProtocol;
    private String m_DbAlias;
    private String m_DatasourceName;
    private String m_UserName;
    private String m_Password;
    private double m_JdbcLevel = 2.0;
    private boolean m_eagerRelease = false;
    private boolean m_batchMode = false;
    private boolean defaultConnection = false;
    private int useAutoCommit = 1;
    private boolean ignoreAutoCommitExceptions = false;
    private PBKey pbKey;
    private ConnectionPoolDescriptor cpd = new ConnectionPoolDescriptor();
    private SequenceDescriptor sequenceDescriptor;
    private ObjectCacheDescriptor objectCacheDescriptor = new ObjectCacheDescriptor();
    private transient DataSource dataSource;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public ObjectCacheDescriptor getObjectCacheDescriptor() {
        return this.objectCacheDescriptor;
    }

    public void setObjectCacheDescriptor(ObjectCacheDescriptor objectCacheDescriptor) {
        this.objectCacheDescriptor = objectCacheDescriptor;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getJcdAlias() {
        return this.m_jcdAlias;
    }

    public void setJcdAlias(String string) {
        this.clearPBKey();
        this.m_jcdAlias = string;
    }

    public boolean isDefaultConnection() {
        return this.defaultConnection;
    }

    public boolean isDataSource() {
        return this.getDataSource() != null || this.getDatasourceName() != null;
    }

    public void setDefaultConnection(boolean bl) {
        this.defaultConnection = bl;
    }

    public SequenceDescriptor getSequenceDescriptor() {
        return this.sequenceDescriptor;
    }

    public void setSequenceDescriptor(SequenceDescriptor sequenceDescriptor) {
        this.sequenceDescriptor = sequenceDescriptor;
    }

    public ConnectionPoolDescriptor getConnectionPoolDescriptor() {
        return this.cpd;
    }

    public void setConnectionPoolDescriptor(ConnectionPoolDescriptor connectionPoolDescriptor) {
        this.cpd = connectionPoolDescriptor;
    }

    public PBKey getPBKey() {
        if (this.pbKey == null) {
            this.pbKey = new PBKey(this.getJcdAlias(), this.getUserName(), this.getPassWord());
        }
        return this.pbKey;
    }

    private void clearPBKey() {
        this.pbKey = null;
    }

    public int getUseAutoCommit() {
        return this.useAutoCommit;
    }

    public void setUseAutoCommit(int n) {
        this.useAutoCommit = n;
    }

    public boolean isIgnoreAutoCommitExceptions() {
        return this.ignoreAutoCommitExceptions;
    }

    public void setIgnoreAutoCommitExceptions(boolean bl) {
        this.ignoreAutoCommitExceptions = bl;
    }

    public String getDbms() {
        return this.m_Dbms;
    }

    public void setDbms(String string) {
        this.m_Dbms = string;
    }

    public String getDriver() {
        return this.m_Driver;
    }

    public void setDriver(String string) {
        this.m_Driver = string;
    }

    public String getProtocol() {
        return this.m_Protocol;
    }

    public void setProtocol(String string) {
        this.m_Protocol = string;
    }

    public String getSubProtocol() {
        return this.m_SubProtocol;
    }

    public void setSubProtocol(String string) {
        this.m_SubProtocol = string;
    }

    public String getDbAlias() {
        return this.m_DbAlias;
    }

    public void setDbAlias(String string) {
        this.m_DbAlias = string;
    }

    public String getUserName() {
        return this.m_UserName;
    }

    public void setUserName(String string) {
        this.clearPBKey();
        this.m_UserName = string;
    }

    public String getPassWord() {
        return this.m_Password;
    }

    public void setPassWord(String string) {
        this.clearPBKey();
        this.m_Password = string;
    }

    public String getDatasourceName() {
        return this.m_DatasourceName;
    }

    public void setDatasourceName(String string) {
        this.m_DatasourceName = string;
    }

    public double getJdbcLevel() {
        return this.m_JdbcLevel;
    }

    public void setJdbcLevel(String string) {
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                this.setJdbcLevel(d);
            }
            catch (NumberFormatException numberFormatException) {
                this.setJdbcLevel(2.0);
                this.logger.info("Specified JDBC level was not numeric (Value=" + string + "), used default jdbc level of 2.0 ");
            }
        } else {
            this.setJdbcLevel(2.0);
            this.logger.info("Specified JDBC level was null, used default jdbc level of 2.0 ");
        }
    }

    public void setJdbcLevel(double d) {
        this.m_JdbcLevel = d;
    }

    public boolean getEagerRelease() {
        return this.m_eagerRelease;
    }

    public void setEagerRelease(boolean bl) {
        this.m_eagerRelease = bl;
    }

    public boolean getBatchMode() {
        return this.m_batchMode;
    }

    public void setBatchMode(boolean bl) {
        this.m_batchMode = bl;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append("jcd-alias", (Object)this.m_jcdAlias).append("default-connection", this.defaultConnection).append("dbms", (Object)this.m_Dbms).append("jdbc-level", this.m_JdbcLevel).append("driver", (Object)this.m_Driver).append("protocol", (Object)this.m_Protocol).append("sub-protocol", (Object)this.m_SubProtocol).append("db-alias", (Object)this.m_DbAlias).append("user", (Object)this.m_UserName).append("password", (Object)"*****").append("eager-release", this.m_eagerRelease).append("ConnectionPoolDescriptor", (Object)this.cpd).append("batchMode", this.m_batchMode).append("useAutoCommit", (Object)JdbcConnectionDescriptor.getUseAutoCommitAsString(this.useAutoCommit)).append("ignoreAutoCommitExceptions", this.ignoreAutoCommitExceptions).append("sequenceDescriptor", (Object)this.sequenceDescriptor);
        return toStringBuilder.toString();
    }

    public String toXML() {
        String string;
        String string2;
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string3 = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string3);
        stringBuffer.append("  <!-- Descriptor for Connection ");
        stringBuffer.append(this.getProtocol());
        stringBuffer.append(":");
        stringBuffer.append(this.getSubProtocol());
        stringBuffer.append(":");
        stringBuffer.append(this.getDbAlias());
        stringBuffer.append(" -->");
        stringBuffer.append(string3);
        stringBuffer.append("  ");
        stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(1));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(82, this.getJcdAlias()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(80, "" + this.isDefaultConnection()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(2, this.getDbms()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(45, "" + this.getJdbcLevel()));
        stringBuffer.append(string3);
        String string4 = this.getUserName();
        if (string4 != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(10, string4));
            stringBuffer.append(string3);
        }
        if ((string2 = this.getPassWord()) != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(11, string2));
            stringBuffer.append(string3);
        }
        if ((string = this.getDatasourceName()) != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(44, this.getDatasourceName()));
            stringBuffer.append(string3);
        } else {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(6, this.getDriver()));
            stringBuffer.append(string3);
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(7, this.getProtocol()));
            stringBuffer.append(string3);
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(8, this.getSubProtocol()));
            stringBuffer.append(string3);
            stringBuffer.append("    ");
            stringBuffer.append(JdbcConnectionDescriptor.encode(repositoryTags.getAttribute(9, this.getDbAlias())));
            stringBuffer.append(string3);
        }
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(74, "" + this.getEagerRelease()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(83, "" + this.getBatchMode()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(90, "" + this.getUseAutoCommit()));
        stringBuffer.append(string3);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(91, "" + this.isIgnoreAutoCommitExceptions()));
        stringBuffer.append(string3);
        stringBuffer.append("  >");
        stringBuffer.append(string3);
        stringBuffer.append(string3);
        stringBuffer.append(this.getConnectionPoolDescriptor().toXML());
        stringBuffer.append(string3);
        if (this.getSequenceDescriptor() != null) {
            stringBuffer.append(this.getSequenceDescriptor().toXML());
        }
        stringBuffer.append(string3);
        stringBuffer.append("  ");
        stringBuffer.append(repositoryTags.getClosingTagById(1));
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("&nbsp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String getUseAutoCommitAsString(int n) {
        switch (n) {
            case 1: {
                return "AUTO_COMMIT_SET_TRUE_AND_TEMPORARY_FALSE";
            }
            case 2: {
                return "AUTO_COMMIT_SET_FALSE";
            }
            case 0: {
                return "AUTO_COMMIT_IGNORE_STATE";
            }
        }
        return "UNKOWN_STATE";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

