/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.ClassHelper;

public class BlobWrapper {
    protected Object m_blob;
    protected static Field durationSession;
    protected static Field durationCall;
    protected static Field modeReadOnly;
    protected static Field modeReadWrite;
    protected static Method createTemporary;
    protected static Method freeTemporary;
    protected static Method open;
    protected static Method isOpen;
    protected static Method getBinaryStream;
    protected static Method getBinaryOutputStream;
    protected static Method getBufferSize;
    protected static Method close;
    protected static Method trim;
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getBlob() {
        return this.m_blob;
    }

    public void setBlob(Object object) {
        this.m_blob = object;
    }

    protected static int staticIntFieldValue(Field field) {
        int n = 0;
        try {
            n = field.getInt(null);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public static int getDurationSessionValue() {
        return BlobWrapper.staticIntFieldValue(durationSession);
    }

    public static int getDurationCallValue() {
        return BlobWrapper.staticIntFieldValue(durationCall);
    }

    public static int getModeReadOnlyValue() {
        return BlobWrapper.staticIntFieldValue(modeReadOnly);
    }

    public static int getModeReadWriteValue() {
        return BlobWrapper.staticIntFieldValue(modeReadWrite);
    }

    public static BlobWrapper createTemporary(Connection connection, boolean bl, int n) throws Exception {
        BlobWrapper blobWrapper = new BlobWrapper();
        blobWrapper.setBlob(createTemporary.invoke(null, connection, BooleanUtils.toBooleanObject((boolean)bl), new Integer(n)));
        return blobWrapper;
    }

    public void open(int n) throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            open.invoke(this.m_blob, new Integer(n));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public boolean isOpen() throws SQLException {
        if (this.m_blob == null) {
            return false;
        }
        boolean bl = false;
        try {
            Boolean bl2 = (Boolean)isOpen.invoke(this.m_blob, null);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return bl;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.m_blob == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)getBinaryStream.invoke(this.m_blob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return inputStream;
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.m_blob == null) {
            return null;
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)getBinaryOutputStream.invoke(this.m_blob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return outputStream;
    }

    public int getBufferSize() throws SQLException {
        if (this.m_blob == null) {
            return 0;
        }
        Integer n = null;
        try {
            n = (Integer)getBufferSize.invoke(this.m_blob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return n;
    }

    public void close() throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            close.invoke(this.m_blob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void trim(long l) throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            trim.invoke(this.m_blob, new Long(l));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void freeTemporary() throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            freeTemporary.invoke(this.m_blob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class clazz = ClassHelper.getClass("oracle.sql.BLOB", false);
            createTemporary = clazz.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = BlobWrapper.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            freeTemporary = clazz.getMethod("freeTemporary", null);
            open = clazz.getMethod("open", Integer.TYPE);
            isOpen = clazz.getMethod("isOpen", null);
            getBinaryStream = clazz.getMethod("getBinaryStream", null);
            getBinaryOutputStream = clazz.getMethod("getBinaryOutputStream", null);
            getBufferSize = clazz.getMethod("getBufferSize", null);
            close = clazz.getMethod("close", null);
            trim = clazz.getMethod("trim", Long.TYPE);
            durationSession = ClassHelper.getField(clazz, "DURATION_SESSION");
            durationCall = ClassHelper.getField(clazz, "DURATION_CALL");
            modeReadOnly = ClassHelper.getField(clazz, "MODE_READONLY");
            modeReadWrite = ClassHelper.getField(clazz, "MODE_READWRITE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

