/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformPostgreSQLImpl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if (object instanceof byte[] && n2 == -4) {
            preparedStatement.setBytes(n, (byte[])object);
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    public String createSequenceQuery(String string) {
        return "create sequence " + string;
    }

    public String createSequenceQuery(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(this.createSequenceQuery(string));
        if (properties != null) {
            Boolean bl;
            Long l = SequenceManagerHelper.getSeqIncrementBy(properties);
            if (l != null) {
                stringBuffer.append(" INCREMENT ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMinValue(properties)) != null) {
                stringBuffer.append(" MINVALUE ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMaxValue(properties)) != null) {
                stringBuffer.append(" MAXVALUE ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqStart(properties)) != null) {
                stringBuffer.append(" START ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqCacheValue(properties)) != null) {
                stringBuffer.append(" CACHE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqCycleValue(properties)) != null && bl.booleanValue()) {
                stringBuffer.append(" CYCLE");
            }
        }
        return stringBuffer.toString();
    }

    public String nextSequenceQuery(String string) {
        return "select nextval('" + string + "')";
    }

    public String dropSequenceQuery(String string) {
        return "drop sequence " + string;
    }

    public void addPagingSql(StringBuffer stringBuffer) {
        stringBuffer.append(" LIMIT ? OFFSET ?");
    }

    public boolean supportsPaging() {
        return true;
    }

    public int bindPagingParameters(PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException {
        preparedStatement.setInt(n, n3 - (n2 - 1));
        preparedStatement.setInt(++n, n2 - 1);
        return ++n;
    }

    public String getEscapeClause(LikeCriteria likeCriteria) {
        if (LikeCriteria.getEscapeCharacter() != '\\') {
            return super.getEscapeClause(likeCriteria);
        }
        return "";
    }
}

