/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.dbhandling;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.dbhandling.DBHandling;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.SQLExec;
import org.apache.tools.ant.types.FileSet;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.torque.task.TorqueSQLExec;
import org.apache.torque.task.TorqueSQLTask;

public class TorqueDBHandling
implements DBHandling {
    protected static final String TORQUE_PLATFORM_DB2 = "db2";
    protected static final String TORQUE_PLATFORM_HYPERSONIC = "hypersonic";
    protected static final String TORQUE_PLATFORM_INTERBASE = "interbase";
    protected static final String TORQUE_PLATFORM_MSSQL = "mssql";
    protected static final String TORQUE_PLATFORM_MYSQL = "mysql";
    protected static final String TORQUE_PLATFORM_ORACLE = "oracle";
    protected static final String TORQUE_PLATFORM_POSTGRESQL = "postgresql";
    protected static final String TORQUE_PLATFORM_SAPDB = "sapdb";
    protected static final String TORQUE_PLATFORM_SYBASE = "sybase";
    private static final String CREATION_SCRIPT_NAME = "create-db.sql";
    private static final String SQL_DB_MAP_NAME = "sqldb.map";
    private static HashMap _dbmsToTorqueDb = new HashMap();
    private JdbcConnectionDescriptor _jcd;
    private String _targetDatabase;
    private File _workDir;
    private HashMap _torqueSchemata = new HashMap();
    private byte[] _creationScript;
    private HashMap _initScripts = new HashMap();

    public void setConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws PlatformException {
        this._jcd = jdbcConnectionDescriptor;
        String string = (String)_dbmsToTorqueDb.get(this._jcd.getDbms().toLowerCase());
        if (string == null) {
            throw new PlatformException("Database " + this._jcd.getDbms() + " is not supported by torque");
        }
        if (!string.equals(this._targetDatabase)) {
            this._targetDatabase = string;
            this._creationScript = null;
            this._initScripts.clear();
        }
    }

    public JdbcConnectionDescriptor getConnection() {
        return this._jcd;
    }

    public String getTargetTorquePlatform() {
        return this._targetDatabase;
    }

    public void addDBDefinitionFiles(String string, String string2) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        File file = new File(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() <= 0) continue;
            this._torqueSchemata.put("schema" + this._torqueSchemata.size() + ".xml", this.readTextCompressed(new File(file, string3)));
        }
    }

    public void addDBDefinitionFile(InputStream inputStream) throws IOException {
        this._torqueSchemata.put("schema" + this._torqueSchemata.size() + ".xml", this.readStreamCompressed(inputStream));
    }

    private String writeSchemata(File file) throws IOException {
        this.writeCompressedTexts(file, this._torqueSchemata);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._torqueSchemata.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public void createCreationScript() throws PlatformException {
        Project project = new Project();
        TorqueDataModelTask torqueDataModelTask = new TorqueDataModelTask();
        File file = null;
        File file2 = null;
        this._creationScript = null;
        try {
            file = new File(this.getWorkDir(), "schemas");
            file.mkdir();
            String string = this.writeSchemata(file);
            file2 = new File(file, CREATION_SCRIPT_NAME);
            project.setBasedir(file.getAbsolutePath());
            torqueDataModelTask.setProject(project);
            torqueDataModelTask.setUseClasspath(true);
            torqueDataModelTask.setControlTemplate("sql/db-init/Control.vm");
            torqueDataModelTask.setOutputDirectory(file);
            torqueDataModelTask.setOutputFile(CREATION_SCRIPT_NAME);
            torqueDataModelTask.setTargetDatabase(this._targetDatabase);
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes(string);
            torqueDataModelTask.addFileset(fileSet);
            torqueDataModelTask.execute();
            this._creationScript = this.readTextCompressed(file2);
            this.deleteDir(file);
        }
        catch (Exception exception) {
            if (file != null && file.exists()) {
                this.deleteDir(file);
            }
            throw new PlatformException(exception);
        }
    }

    public void createDB() throws PlatformException {
        if (this._creationScript == null) {
            this.createCreationScript();
        }
        Project project = new Project();
        TorqueDataModelTask torqueDataModelTask = new TorqueDataModelTask();
        File file = null;
        File file2 = null;
        try {
            file = new File(this.getWorkDir(), "schemas");
            file.mkdir();
            file2 = new File(file, CREATION_SCRIPT_NAME);
            this.writeCompressedText(file2, this._creationScript);
            project.setBasedir(file.getAbsolutePath());
            SQLExec sQLExec = new SQLExec();
            SQLExec.OnError onError = new SQLExec.OnError();
            onError.setValue("continue");
            sQLExec.setProject(project);
            sQLExec.setAutocommit(true);
            sQLExec.setDriver(this._jcd.getDriver());
            sQLExec.setOnerror(onError);
            sQLExec.setUserid(this._jcd.getUserName());
            sQLExec.setPassword(this._jcd.getPassWord() == null ? "" : this._jcd.getPassWord());
            sQLExec.setUrl(this.getDBCreationUrl());
            sQLExec.setSrc(file2);
            sQLExec.execute();
            this.deleteDir(file);
        }
        catch (Exception exception) {
            if (file != null && file.exists()) {
                try {
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    LoggerFactory.getLogger(this.getClass()).error("NPE While deleting scriptFile [" + file2.getName() + "]", nullPointerException);
                }
            }
            throw new PlatformException(exception);
        }
    }

    public void createInitScripts() throws PlatformException {
        Project project = new Project();
        TorqueSQLTask torqueSQLTask = new TorqueSQLTask();
        File file = null;
        File file2 = null;
        this._initScripts.clear();
        try {
            File file3 = this.getWorkDir();
            file = new File(file3, "schemas");
            file2 = new File(file3, "sql");
            file.mkdir();
            file2.mkdir();
            String string = this.writeSchemata(file);
            File file4 = new File(file2, SQL_DB_MAP_NAME);
            file4.createNewFile();
            project.setBasedir(file2.getAbsolutePath());
            torqueSQLTask.setProject(project);
            torqueSQLTask.setUseClasspath(true);
            torqueSQLTask.setBasePathToDbProps("sql/base/");
            torqueSQLTask.setControlTemplate("sql/base/Control.vm");
            torqueSQLTask.setOutputDirectory(file2);
            torqueSQLTask.setOutputFile("../report.sql.generation");
            torqueSQLTask.setSqlDbMap(SQL_DB_MAP_NAME);
            torqueSQLTask.setTargetDatabase(this._targetDatabase);
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes(string);
            torqueSQLTask.addFileset(fileSet);
            torqueSQLTask.execute();
            this.readTextsCompressed(file2, this._initScripts);
            this.deleteDir(file);
            this.deleteDir(file2);
        }
        catch (Exception exception) {
            if (file != null && file.exists()) {
                this.deleteDir(file);
            }
            if (file2 != null && file2.exists()) {
                this.deleteDir(file2);
            }
            throw new PlatformException(exception);
        }
    }

    public void initDB() throws PlatformException {
        if (this._initScripts.isEmpty()) {
            this.createInitScripts();
        }
        Project project = new Project();
        TorqueSQLTask torqueSQLTask = new TorqueSQLTask();
        File file = null;
        try {
            file = new File(this.getWorkDir(), "sql");
            file.mkdir();
            this.writeCompressedTexts(file, this._initScripts);
            project.setBasedir(file.getAbsolutePath());
            TorqueSQLExec torqueSQLExec = new TorqueSQLExec();
            TorqueSQLExec.OnError onError = new TorqueSQLExec.OnError();
            torqueSQLExec.setProject(project);
            onError.setValue("continue");
            torqueSQLExec.setAutocommit(true);
            torqueSQLExec.setDriver(this._jcd.getDriver());
            torqueSQLExec.setOnerror(onError);
            torqueSQLExec.setUserid(this._jcd.getUserName());
            torqueSQLExec.setPassword(this._jcd.getPassWord() == null ? "" : this._jcd.getPassWord());
            torqueSQLExec.setUrl(this.getDBManipulationUrl());
            torqueSQLExec.setSrcDir(file.getAbsolutePath());
            torqueSQLExec.setSqlDbMap(SQL_DB_MAP_NAME);
            torqueSQLExec.execute();
            this.deleteDir(file);
        }
        catch (Exception exception) {
            if (file != null) {
                this.deleteDir(file);
            }
            throw new PlatformException(exception);
        }
    }

    protected String getDBCreationUrl() {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = this.getConnection();
        if (TORQUE_PLATFORM_MYSQL.equals(this.getTargetTorquePlatform())) {
            int n;
            String string = jdbcConnectionDescriptor.getDbAlias();
            String string2 = "";
            int n2 = string.indexOf(63);
            if (n2 > 0) {
                string2 = string.substring(n2);
                string = string.substring(0, n2);
            }
            if ((n = string.lastIndexOf(47)) > 0) {
                string = string.substring(0, n + 1);
            }
            return jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + string + string2;
        }
        if (TORQUE_PLATFORM_POSTGRESQL.equals(this.getTargetTorquePlatform())) {
            int n;
            String string = jdbcConnectionDescriptor.getDbAlias();
            String string3 = "";
            int n3 = string.indexOf(63);
            if (n3 > 0) {
                string3 = string.substring(n3);
                string = string.substring(0, n3);
            }
            string = (n = string.lastIndexOf(47)) > 0 ? string.substring(0, n + 1) : string + "/";
            string = string + "template1";
            if (string3.length() > 0) {
                string = string + "/";
            }
            return jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + string + string3;
        }
        return jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + jdbcConnectionDescriptor.getDbAlias();
    }

    protected String getDBManipulationUrl() {
        JdbcConnectionDescriptor jdbcConnectionDescriptor = this.getConnection();
        return jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + jdbcConnectionDescriptor.getDbAlias();
    }

    private byte[] readTextCompressed(File file) throws IOException {
        return this.readStreamCompressed(new FileInputStream(file));
    }

    private byte[] readStreamCompressed(InputStream inputStream) throws IOException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gZIPOutputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            outputStreamWriter.write(string);
            outputStreamWriter.write(10);
        }
        bufferedReader.close();
        inputStream.close();
        outputStreamWriter.close();
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void readTextsCompressed(File file, HashMap hashMap) throws IOException {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) continue;
                hashMap.put(fileArray[i].getName(), this.readTextCompressed(fileArray[i]));
            }
        }
    }

    private void writeCompressedText(File file, byte[] byArray) throws IOException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(gZIPInputStream));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string);
            bufferedWriter.write(10);
        }
        bufferedReader.close();
        gZIPInputStream.close();
        byteArrayInputStream.close();
        bufferedWriter.close();
    }

    private void writeCompressedTexts(File file, HashMap hashMap) throws IOException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeCompressedText(new File(file, string), (byte[])hashMap.get(string));
        }
    }

    public void setWorkDir(String string) throws IOException {
        File file = new File(string);
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            throw new IOException("Cannot access directory " + string);
        }
        this._workDir = file;
    }

    private File getWorkDir() throws IOException {
        if (this._workDir == null) {
            File file = File.createTempFile("dummy", ".log");
            String string = file.getPath().substring(0, file.getPath().lastIndexOf(File.separatorChar));
            if (string == null || string.length() == 0) {
                string = ".";
            }
            file.delete();
            this._workDir = new File(string);
        }
        return this._workDir;
    }

    private void deleteDir(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].exists()) continue;
                if (fileArray[i].isDirectory()) {
                    this.deleteDir(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            file.delete();
        }
    }

    static {
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_DB2, TORQUE_PLATFORM_DB2);
        _dbmsToTorqueDb.put("hsqldb", TORQUE_PLATFORM_HYPERSONIC);
        _dbmsToTorqueDb.put("firebird", TORQUE_PLATFORM_INTERBASE);
        _dbmsToTorqueDb.put("mssqlserver", TORQUE_PLATFORM_MSSQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_MYSQL, TORQUE_PLATFORM_MYSQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_ORACLE, TORQUE_PLATFORM_ORACLE);
        _dbmsToTorqueDb.put("oracle9i", TORQUE_PLATFORM_ORACLE);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_POSTGRESQL, TORQUE_PLATFORM_POSTGRESQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_SAPDB, TORQUE_PLATFORM_SAPDB);
        _dbmsToTorqueDb.put("sybaseasa", TORQUE_PLATFORM_SYBASE);
        _dbmsToTorqueDb.put("sybasease", TORQUE_PLATFORM_SYBASE);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_SYBASE, TORQUE_PLATFORM_SYBASE);
    }
}

