/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LoggingConfiguration
extends ConfigurationAbstractImpl {
    public static final String PROPERTY_COMMONS_LOGGING_LOG = "org.apache.commons.logging.Log";
    public static final String PROPERTY_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    public static final String PROPERTY_OJB_LOGGERCLASS = "org.apache.ojb.broker.util.logging.Logger.class";
    public static final String PROPERTY_OJB_LOGGERCONFIGFILE = "org.apache.ojb.broker.util.logging.Logger.configFile";
    public static final String OJB_LOGGING_PROPERTIES_FILE = "OJB-logging.properties";
    public static final String OJB_DEFAULT_LOG_LEVEL = "WARN";
    public static final String OJB_DEFAULT_BOOT_LOG_LEVEL = "INFO";
    private Class _loggerClass;
    private String _loggerConfigFile;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        InputStream inputStream;
        String string;
        ClassLoader classLoader;
        Logger logger;
        block30: {
            String string2;
            logger = LoggerFactory.getBootLogger();
            classLoader = ClassHelper.getClassLoader();
            this._loggerClass = null;
            this.properties = new Properties();
            string = this.getLoggerClass(System.getProperties());
            this._loggerConfigFile = this.getLoggerConfigFile(System.getProperties());
            if (string == null) {
                string2 = System.getProperty(OJB_LOGGING_PROPERTIES_FILE, OJB_LOGGING_PROPERTIES_FILE);
                try {
                    URL uRL = ClassHelper.getResource(string2);
                    if (uRL == null) {
                        uRL = new File(string2).toURL();
                    }
                    inputStream = uRL.openStream();
                    try {
                        logger.info("Found logging properties file: " + string2);
                        this.properties.load(inputStream);
                        this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                        string = this.getLoggerClass(this.properties);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    if (string == null) {
                        logger.warn("Can't read logging properties file using path '" + string2 + "', message is: " + SystemUtils.LINE_SEPARATOR + exception.getMessage() + SystemUtils.LINE_SEPARATOR + "Will try to load logging properties from OJB.properties file");
                    }
                    logger.info("Problems while closing resources for path '" + string2 + "', message is: " + SystemUtils.LINE_SEPARATOR + exception.getMessage(), exception);
                }
            }
            if (string == null) {
                string2 = System.getProperty("OJB.properties", "OJB.properties");
                try {
                    inputStream = classLoader.getResourceAsStream(string2);
                    if (inputStream == null) break block30;
                    try {
                        this.properties.load(inputStream);
                        string = this.getLoggerClass(this.properties);
                        this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                        if (string != null) {
                            logger.warn("Please use a separate 'OJB-logging.properties' file to specify your logging settings");
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            try {
                this._loggerClass = ClassHelper.getClass(string);
                logger.info("Logging: Found logger class '" + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                logger.warn("Could not load logger class " + string + ", defaulting to " + this._loggerClass.getName(), classNotFoundException);
            }
        } else if (System.getProperty(PROPERTY_COMMONS_LOGGING_LOG) != null || System.getProperty(PROPERTY_COMMONS_LOGGING_LOGFACTORY) != null) {
            this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
            logger.info("Logging: Found commons logging properties, use " + this._loggerClass);
        } else {
            try {
                inputStream = classLoader.getResourceAsStream("log4j.properties");
                if (inputStream != null) {
                    this._loggerClass = class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;
                    this._loggerConfigFile = "log4j.properties";
                    logger.info("Logging: Found 'log4j.properties' file, use " + this._loggerClass);
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._loggerClass == null) {
                try {
                    inputStream = classLoader.getResourceAsStream("commons-logging.properties");
                    if (inputStream != null) {
                        this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
                        this._loggerConfigFile = "commons-logging.properties";
                        logger.info("Logging: Found 'commons-logging.properties' file, use " + this._loggerClass);
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._loggerClass == null) {
                    logger.info("** Can't find logging configuration file, use default logger **");
                    this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                }
            }
        }
    }

    private String getLoggerClass(Properties properties) {
        String string = properties.getProperty(PROPERTY_OJB_LOGGERCLASS);
        if (string == null) {
            string = properties.getProperty("LoggerClass");
        }
        return string;
    }

    private String getLoggerConfigFile(Properties properties) {
        String string = properties.getProperty(PROPERTY_OJB_LOGGERCONFIGFILE);
        if (string == null) {
            string = properties.getProperty("LoggerConfigFile");
        }
        return string;
    }

    public String getLogLevel(String string) {
        return this.getString(string + ".LogLevel", this.getString("ROOT.LogLevel", OJB_DEFAULT_LOG_LEVEL));
    }

    public void setLogger(Logger logger) {
    }

    public Class getLoggerClass() {
        return this._loggerClass;
    }

    public String getLoggerConfigFile() {
        return this._loggerConfigFile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

