/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class StringBufferLoggerImpl
extends PoorMansLoggerImpl {
    protected String EOL = SystemUtils.LINE_SEPARATOR;
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean errorLog;

    public StringBufferLoggerImpl(String string) {
        super(string);
    }

    protected void log(String string, Object object, Throwable throwable) {
        this.buffer.append("[").append(this.getName()).append("] ").append(string);
        if (object != null && object instanceof Throwable) {
            try {
                this.buffer.append(((Throwable)object).getMessage()).append(this.EOL);
                ((Throwable)object).printStackTrace();
            }
            catch (Throwable throwable2) {}
        } else {
            try {
                this.buffer.append(object).append(this.EOL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (throwable != null) {
            try {
                this.buffer.append(throwable.getMessage()).append(this.EOL);
                this.buffer.append(ExceptionUtils.getFullStackTrace((Throwable)throwable)).append(this.EOL);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        if (!this.errorLog && (string.equals("ERROR") || string.equals("FATAL"))) {
            this.errorLog = true;
        }
    }

    public boolean isErrorLog() {
        return this.errorLog;
    }

    public String flushLogBuffer() {
        String string = this.buffer.toString();
        this.buffer = new StringBuffer(1000);
        return string;
    }
}

