/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.Type;
import org.apache.ojb.jdo.jdoql.Visitor;

public class UnaryExpression
extends Expression {
    public static final int OPERATOR_MINUS = 0;
    public static final int OPERATOR_PLUS = 1;
    public static final int OPERATOR_BITWISE_COMPLEMENT = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_CAST = 4;
    private int _operator;
    private Expression _inner;
    private Type _castType;
    private Class _type;

    public UnaryExpression(int n, Expression expression) {
        this._operator = n;
        this._inner = expression;
    }

    public UnaryExpression(Type type, Expression expression) {
        this._operator = 4;
        this._castType = type;
        this._inner = expression;
    }

    public int getOperator() {
        return this._operator;
    }

    public Expression getInnerExpression() {
        return this._inner;
    }

    public void replaceChild(Expression expression, Expression expression2) {
        this._inner.setParent(null);
        this._inner = expression2;
        this._inner.setParent(this);
    }

    public Type getCastType() {
        return this._castType;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        switch (this._operator) {
            case 1: {
                stringBuffer.append("+");
                break;
            }
            case 0: {
                stringBuffer.append("-");
                break;
            }
            case 2: {
                stringBuffer.append("~");
                break;
            }
            case 3: {
                stringBuffer.append("!");
                break;
            }
            case 4: {
                stringBuffer.append("(");
                stringBuffer.append(this._castType.toString());
                stringBuffer.append(")");
            }
        }
        stringBuffer.append(this._inner.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setType(Class clazz) {
        this._type = clazz;
    }

    public Class getType() {
        return this._type;
    }
}

