/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.Hashtable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.odmg.TransactionNotInProgressException;

public class LocalTxManager
implements OJBTxManager {
    private static TransactionTable tx_table = new TransactionTable();

    public TransactionImpl getCurrentTransaction() {
        TransactionImpl transactionImpl = tx_table.get(Thread.currentThread());
        if (transactionImpl == null) {
            throw new TransactionNotInProgressException("Calling method needed transaction, but no transaction found for current thread :-(");
        }
        return transactionImpl;
    }

    public TransactionImpl getTransaction() {
        return tx_table.get(Thread.currentThread());
    }

    public void registerTx(TransactionImpl transactionImpl) {
        tx_table.put(Thread.currentThread(), transactionImpl);
    }

    public void deregisterTx(Object object) {
        tx_table.remove(Thread.currentThread());
    }

    public void abortExternalTx(TransactionImpl transactionImpl) {
    }

    public void configure(Configuration configuration) {
    }

    static final class TransactionTable {
        private Hashtable m_table = new Hashtable();

        public TransactionImpl get(Thread thread) {
            return (TransactionImpl)this.m_table.get(thread);
        }

        public void put(Thread thread, TransactionImpl transactionImpl) {
            this.m_table.put(thread, transactionImpl);
        }

        public void remove(Thread thread) {
            this.m_table.remove(thread);
        }
    }
}

