/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeOrdering;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.link.LinkEntry;
import org.apache.ojb.odmg.link.LinkEntryMtoN;
import org.apache.ojb.odmg.states.StateOldClean;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelopeTable == null ? (class$org$apache$ojb$odmg$ObjectEnvelopeTable = ObjectEnvelopeTable.class$("org.apache.ojb.odmg.ObjectEnvelopeTable")) : class$org$apache$ojb$odmg$ObjectEnvelopeTable);
    private TransactionImpl transaction;
    private List newAssociatedIdentites = new ArrayList();
    private List m2nLinkList = new ArrayList();
    private List m2nUnlinkList = new ArrayList();
    private List markedForDeletionList = new ArrayList();
    private List markedForInsertList = new ArrayList();
    private Map mhtObjectEnvelopes = new HashMap();
    private ArrayList mvOrderOfIds = new ArrayList();
    private boolean needsCommit = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelopeTable;

    public ObjectEnvelopeTable(TransactionImpl transactionImpl) {
        this.transaction = transactionImpl;
    }

    TransactionImpl getTransaction() {
        return this.transaction;
    }

    public void refresh() {
        this.needsCommit = false;
        this.mhtObjectEnvelopes = new HashMap();
        this.mvOrderOfIds = new ArrayList();
        this.afterWriteCleanup();
    }

    void afterWriteCleanup() {
        this.m2nLinkList.clear();
        this.m2nUnlinkList.clear();
        this.newAssociatedIdentites.clear();
        this.markedForDeletionList.clear();
        this.markedForInsertList.clear();
    }

    public void writeObjects(boolean bl) throws TransactionAbortedException, LockNotGrantedException {
        PersistenceBroker persistenceBroker = this.transaction.getBroker();
        ConnectionManagerIF connectionManagerIF = persistenceBroker.serviceConnectionManager();
        boolean bl2 = connectionManagerIF.isBatchMode();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PB is in internal tx: " + persistenceBroker.isInTransaction() + "  broker was: " + persistenceBroker);
            }
            if (!persistenceBroker.isInTransaction()) {
                this.log.error("PB associated with current odmg-tx is not in tx");
                throw new TransactionAbortedException("Underlying PB is not in tx, was begin call done before commit?");
            }
            connectionManagerIF.setBatchMode(true);
            this.checkAllEnvelopes(persistenceBroker);
            this.cascadingDependents();
            this.upgradeLockIfNeeded();
            this.reorder();
            this.writeAllEnvelopes(bl);
            connectionManagerIF.executeBatch();
            this.prepareForReuse(bl);
            this.afterWriteCleanup();
        }
        catch (Exception exception) {
            connectionManagerIF.clearBatch();
            if (exception instanceof OptimisticLockException) {
                this.log.error("Optimistic lock exception while write objects", exception);
                Object object = ((OptimisticLockException)((Object)exception)).getSourceObject();
                throw new LockNotGrantedException("Optimistic lock exception occur, source object was (" + object + ")," + " message was (" + exception.getMessage() + ")");
            }
            if (!(exception instanceof RuntimeException)) {
                this.log.warn("Error while write objects for tx " + this.transaction, exception);
                throw new ODMGRuntimeException("Unexpected error while write objects: " + exception.getMessage());
            }
            this.log.warn("Error while write objects for tx " + this.transaction, exception);
            throw (RuntimeException)exception;
        }
        finally {
            this.needsCommit = false;
            connectionManagerIF.setBatchMode(bl2);
        }
    }

    private void writeAllEnvelopes(boolean bl) {
        this.performM2NUnlinkEntries();
        Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iterator.hasNext()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
            boolean bl2 = false;
            if (this.needsCommit) {
                bl2 = objectEnvelope.needsInsert();
                objectEnvelope.getModificationState().commit(objectEnvelope);
                if (bl && bl2) {
                    this.getTransaction().doSingleLock(objectEnvelope.getClassDescriptor(), objectEnvelope.getObject(), objectEnvelope.getIdentity(), 4);
                }
            }
            objectEnvelope.cleanup(bl, bl2);
        }
        this.performM2NLinkEntries();
    }

    private void checkAllEnvelopes(PersistenceBroker persistenceBroker) {
        Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iterator.hasNext()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
            if (objectEnvelope.getModificationState().isTransient()) continue;
            objectEnvelope.markReferenceElements(persistenceBroker);
        }
    }

    private void prepareForReuse(boolean bl) {
        if (bl) {
            Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                if (!this.needsCommit || objectEnvelope.getModificationState() == StateOldClean.getInstance() || objectEnvelope.getModificationState().isTransient()) continue;
                objectEnvelope.setModificationState(objectEnvelope.getModificationState().markClean());
            }
        }
    }

    private void upgradeLockIfNeeded() {
        Iterator iterator = ((List)this.mvOrderOfIds.clone()).iterator();
        TransactionImpl transactionImpl = this.getTransaction();
        while (iterator.hasNext()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
            if (objectEnvelope.getModificationState().isTransient()) continue;
            if (!objectEnvelope.needsInsert()) {
                if (!objectEnvelope.needsDelete() && !objectEnvelope.needsUpdate() && !objectEnvelope.hasChanged(transactionImpl.getBroker())) continue;
                this.needsCommit = true;
                objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
                ClassDescriptor classDescriptor = objectEnvelope.getClassDescriptor();
                if (objectEnvelope.isWriteLocked()) continue;
                transactionImpl.doSingleLock(classDescriptor, objectEnvelope.getObject(), objectEnvelope.getIdentity(), 4);
                continue;
            }
            this.needsCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            Iterator iterator = this.mvOrderOfIds.iterator();
            while (iterator.hasNext()) {
                ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iterator.next());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("rollback: " + objectEnvelope);
                }
                if (objectEnvelope.hasChanged(this.transaction.getBroker())) {
                    objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
                }
                objectEnvelope.getModificationState().rollback(objectEnvelope);
            }
        }
        finally {
            this.needsCommit = false;
        }
        this.afterWriteCleanup();
    }

    public void remove(Object object) {
        Identity identity = object instanceof Identity ? (Identity)object : this.transaction.getBroker().serviceIdentity().buildIdentity(object);
        this.mhtObjectEnvelopes.remove(identity);
        this.mvOrderOfIds.remove(identity);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.mhtObjectEnvelopes.values());
    }

    public ObjectEnvelope getByIdentity(Identity identity) {
        return (ObjectEnvelope)this.mhtObjectEnvelopes.get(identity);
    }

    public ObjectEnvelope get(Object object, boolean bl) {
        PersistenceBroker persistenceBroker = this.transaction.getBroker();
        Identity identity = persistenceBroker.serviceIdentity().buildIdentity(object);
        return this.get(identity, object, bl);
    }

    public ObjectEnvelope get(Identity identity, Object object, boolean bl) {
        ObjectEnvelope objectEnvelope = this.getByIdentity(identity);
        if (objectEnvelope == null) {
            objectEnvelope = new ObjectEnvelope(this, identity, object, bl);
            this.mhtObjectEnvelopes.put(identity, objectEnvelope);
            this.mvOrderOfIds.add(identity);
            if (this.log.isDebugEnabled()) {
                this.log.debug("register: " + objectEnvelope);
            }
        }
        return objectEnvelope;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        String string = SystemUtils.LINE_SEPARATOR;
        toStringBuilder.append((Object)("# ObjectEnvelopeTable dump:" + string + "start["));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            toStringBuilder.append((Object)(objectEnvelope.toString() + string));
        }
        toStringBuilder.append((Object)"]end");
        return toStringBuilder.toString();
    }

    public boolean contains(Identity identity) {
        return this.mhtObjectEnvelopes.containsKey(identity);
    }

    private void reorder() {
        if (this.getTransaction().isOrdering() && this.needsCommit && this.mhtObjectEnvelopes.size() > 1) {
            ObjectEnvelopeOrdering objectEnvelopeOrdering = new ObjectEnvelopeOrdering(this.mvOrderOfIds, this.mhtObjectEnvelopes);
            objectEnvelopeOrdering.reorder();
            Identity[] identityArray = objectEnvelopeOrdering.getOrdering();
            this.mvOrderOfIds.clear();
            for (int i = 0; i < identityArray.length; ++i) {
                this.mvOrderOfIds.add(identityArray[i]);
            }
        }
    }

    void cascadingDependents() {
        Iterator iterator = this.mhtObjectEnvelopes.values().iterator();
        while (iterator.hasNext()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)iterator.next();
            if (objectEnvelope.needsDelete()) {
                this.addForDeletionDependent(objectEnvelope);
                continue;
            }
            if (!objectEnvelope.needsInsert()) continue;
            this.addForInsertDependent(objectEnvelope);
        }
        this.cascadeMarkedForDeletion();
        this.cascadeMarkedForInsert();
    }

    void addNewAssociatedIdentity(Identity identity) {
        this.newAssociatedIdentites.add(identity);
    }

    boolean isNewAssociatedObject(Identity identity) {
        return this.newAssociatedIdentites.contains(identity);
    }

    void addForInsertDependent(ObjectEnvelope objectEnvelope) {
        this.markedForInsertList.add(objectEnvelope);
    }

    private void cascadeMarkedForInsert() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.markedForInsertList.size(); ++i) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.markedForInsertList.get(i);
            if (!objectEnvelope.needsInsert()) continue;
            this.cascadeInsertFor(objectEnvelope, arrayList);
            arrayList.clear();
        }
        this.markedForInsertList.clear();
    }

    private void cascadeInsertFor(ObjectEnvelope objectEnvelope, List list) {
        if (list.contains(objectEnvelope.getIdentity())) {
            return;
        }
        list.add(objectEnvelope.getIdentity());
        ClassDescriptor classDescriptor = this.getTransaction().getBroker().getClassDescriptor(objectEnvelope.getObject().getClass());
        List list2 = classDescriptor.getObjectReferenceDescriptors(true);
        this.cascadeInsertSingleReferences(objectEnvelope, list2, list);
        List list3 = classDescriptor.getCollectionDescriptors(true);
        this.cascadeInsertCollectionReferences(objectEnvelope, list3, list);
    }

    private void cascadeInsertSingleReferences(ObjectEnvelope objectEnvelope, List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            ObjectEnvelope objectEnvelope2;
            RuntimeObject runtimeObject;
            Identity identity;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)list.get(i);
            Object object = objectReferenceDescriptor.getPersistentField().get(objectEnvelope.getObject());
            if (object == null) continue;
            objectEnvelope.addLinkOneToOne(objectReferenceDescriptor, false);
            IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
            if (indirectionHandler != null && !indirectionHandler.alreadyMaterialized() || list2.contains(identity = (runtimeObject = indirectionHandler != null ? new RuntimeObject(indirectionHandler.getRealSubject(), this.getTransaction(), false) : new RuntimeObject(object, this.getTransaction())).getIdentity()) || (objectEnvelope2 = this.getByIdentity(identity)) != null || !runtimeObject.isNew()) continue;
            this.getTransaction().lockAndRegister(runtimeObject, 4, false, this.getTransaction().getRegistrationList());
            objectEnvelope2 = this.getByIdentity(identity);
            this.cascadeInsertFor(objectEnvelope2, list2);
        }
    }

    private void cascadeInsertCollectionReferences(ObjectEnvelope objectEnvelope, List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)list.get(i);
            Object object = collectionDescriptor.getPersistentField().get(objectEnvelope.getObject());
            CollectionProxy collectionProxy = ProxyHelper.getCollectionProxy(object);
            if (collectionProxy != null || object == null) continue;
            Iterator iterator = BrokerHelper.getCollectionIterator(object);
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (object2 == null) continue;
                RuntimeObject runtimeObject = new RuntimeObject(object2, this.getTransaction());
                Identity identity = runtimeObject.getIdentity();
                if (!objectEnvelope.needsInsert()) continue;
                object2 = ProxyHelper.getRealObject(object2);
                ObjectEnvelope objectEnvelope2 = this.getByIdentity(identity);
                if (objectEnvelope2 == null) {
                    this.getTransaction().lockAndRegister(runtimeObject, 4, false, this.getTransaction().getRegistrationList());
                    objectEnvelope2 = this.getByIdentity(identity);
                }
                if (collectionDescriptor.isMtoNRelation()) {
                    this.addM2NLinkEntry(collectionDescriptor, objectEnvelope.getObject(), object2);
                } else {
                    objectEnvelope2.addLinkOneToN(collectionDescriptor, objectEnvelope.getObject(), false);
                    objectEnvelope2.setModificationState(objectEnvelope2.getModificationState().markDirty());
                }
                this.cascadeInsertFor(objectEnvelope2, list2);
            }
        }
    }

    void addForDeletionDependent(ObjectEnvelope objectEnvelope) {
        this.markedForDeletionList.add(objectEnvelope);
    }

    private void cascadeMarkedForDeletion() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.markedForDeletionList.size(); ++i) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.markedForDeletionList.get(i);
            if (this.isNewAssociatedObject(objectEnvelope.getIdentity())) continue;
            this.cascadeDeleteFor(objectEnvelope, arrayList);
            arrayList.clear();
        }
        this.markedForDeletionList.clear();
    }

    private void cascadeDeleteFor(ObjectEnvelope objectEnvelope, List list) {
        if (list.contains(objectEnvelope.getIdentity())) {
            return;
        }
        list.add(objectEnvelope.getIdentity());
        ClassDescriptor classDescriptor = this.getTransaction().getBroker().getClassDescriptor(objectEnvelope.getObject().getClass());
        List list2 = classDescriptor.getObjectReferenceDescriptors(true);
        this.cascadeDeleteSingleReferences(objectEnvelope, list2, list);
        List list3 = classDescriptor.getCollectionDescriptors(true);
        this.cascadeDeleteCollectionReferences(objectEnvelope, list3, list);
    }

    private void cascadeDeleteSingleReferences(ObjectEnvelope objectEnvelope, List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            Identity identity;
            Object object;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)list.get(i);
            if (!this.getTransaction().cascadeDeleteFor(objectReferenceDescriptor) || (object = objectReferenceDescriptor.getPersistentField().get(objectEnvelope.getObject())) == null || this.isNewAssociatedObject(identity = this.getTransaction().getBroker().serviceIdentity().buildIdentity(object))) continue;
            ObjectEnvelope objectEnvelope2 = this.get(identity, object, false);
            objectEnvelope2.setModificationState(objectEnvelope2.getModificationState().markDelete());
            this.cascadeDeleteFor(objectEnvelope2, list2);
        }
    }

    private void cascadeDeleteCollectionReferences(ObjectEnvelope objectEnvelope, List list, List list2) {
        PersistenceBroker persistenceBroker = this.getTransaction().getBroker();
        for (int i = 0; i < list.size(); ++i) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)list.get(i);
            boolean bl = this.getTransaction().cascadeDeleteFor(collectionDescriptor);
            Object object = collectionDescriptor.getPersistentField().get(objectEnvelope.getObject());
            CollectionProxyDefaultImpl collectionProxyDefaultImpl = (CollectionProxyDefaultImpl)ProxyHelper.getCollectionProxy(object);
            if (collectionProxyDefaultImpl != null) {
                object = collectionProxyDefaultImpl.getData();
            }
            if (object == null) continue;
            Iterator iterator = BrokerHelper.getCollectionIterator(object);
            while (iterator.hasNext()) {
                Object object2 = ProxyHelper.getRealObject(iterator.next());
                Identity identity = persistenceBroker.serviceIdentity().buildIdentity(object2);
                ObjectEnvelope objectEnvelope2 = this.get(identity, object2, false);
                if (bl) {
                    objectEnvelope2.setModificationState(objectEnvelope2.getModificationState().markDelete());
                    this.cascadeDeleteFor(objectEnvelope2, list2);
                } else if (!collectionDescriptor.isMtoNRelation()) {
                    objectEnvelope2.addLinkOneToN(collectionDescriptor, objectEnvelope.getObject(), true);
                    objectEnvelope2.setModificationState(objectEnvelope2.getModificationState().markDirty());
                }
                if (!collectionDescriptor.isMtoNRelation()) continue;
                this.addM2NUnlinkEntry(collectionDescriptor, objectEnvelope.getObject(), object2);
            }
        }
    }

    void addM2NLinkEntry(CollectionDescriptor collectionDescriptor, Object object, Object object2) {
        if (!collectionDescriptor.isMtoNRelation()) {
            throw new OJBRuntimeException("Expect a m:n releation, but specified a 1:n");
        }
        this.m2nLinkList.add(new LinkEntryMtoN(object, collectionDescriptor, object2, false));
    }

    void performM2NLinkEntries() {
        PersistenceBroker persistenceBroker = this.getTransaction().getBroker();
        for (int i = 0; i < this.m2nLinkList.size(); ++i) {
            LinkEntry linkEntry = (LinkEntry)this.m2nLinkList.get(i);
            linkEntry.execute(persistenceBroker);
        }
    }

    void addM2NUnlinkEntry(CollectionDescriptor collectionDescriptor, Object object, Object object2) {
        if (!collectionDescriptor.isMtoNRelation()) {
            throw new OJBRuntimeException("Expect a m:n releation, but specified a 1:n");
        }
        this.m2nUnlinkList.add(new LinkEntryMtoN(object, collectionDescriptor, object2, true));
    }

    void performM2NUnlinkEntries() {
        PersistenceBroker persistenceBroker = this.getTransaction().getBroker();
        for (int i = 0; i < this.m2nUnlinkList.size(); ++i) {
            LinkEntry linkEntry = (LinkEntry)this.m2nUnlinkList.get(i);
            linkEntry.execute(persistenceBroker);
        }
    }

    boolean replaceRegisteredIdentity(Identity identity, Identity identity2) {
        boolean bl = false;
        Object v = this.mhtObjectEnvelopes.remove(identity2);
        if (v != null) {
            this.mhtObjectEnvelopes.put(identity, v);
            int n = this.mvOrderOfIds.indexOf(identity2);
            this.mvOrderOfIds.remove(n);
            this.mvOrderOfIds.add(n, identity);
            bl = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Replace identity: " + identity2 + " --replaced-by--> " + identity);
            }
        } else {
            this.log.warn("Can't replace unregistered object identity (" + identity2 + ") with new identity (" + identity + ")");
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

