/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockManagerOdmgImpl;

public class LockManagerFactory {
    private static LockManagerFactory lockManagerFactory = null;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$locking$LockManagerFactory == null ? (class$org$apache$ojb$odmg$locking$LockManagerFactory = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManagerFactory")) : class$org$apache$ojb$odmg$locking$LockManagerFactory);
    private LockManager lockManager;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManagerFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManager;

    private LockManagerFactory() {
        this.init();
    }

    private void init() {
        Configuration configuration = OjbConfigurator.getInstance().getConfigurationFor(null);
        Class clazz = configuration.getClass("LockMapClass", class$java$lang$Object == null ? (class$java$lang$Object = LockManagerFactory.class$("java.lang.Object")) : class$java$lang$Object);
        Class clazz2 = configuration.getClass("LockManagerClass", null);
        if (clazz2 == null) {
            throw new OJBRuntimeException(this.buildErrorMsg(clazz, clazz2));
        }
        if (!clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = LockManagerFactory.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.log.info("Setup *deprecated* odmg-locking api.");
            this.log.info("Used LockManagerClass=" + clazz2);
            this.log.info("Used LockMapClass=" + clazz);
            if (!(class$org$apache$ojb$odmg$locking$LockManager == null ? (class$org$apache$ojb$odmg$locking$LockManager = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManager")) : class$org$apache$ojb$odmg$locking$LockManager).isAssignableFrom(clazz2)) {
                throw new OJBRuntimeException(this.buildErrorMsg(clazz, clazz2));
            }
            this.setupLockManager(clazz2);
        } else {
            this.log.info("Setup odmg-locking api.");
            this.log.info("Used LockManagerClass=" + clazz2);
            if ((class$org$apache$ojb$odmg$locking$LockManager == null ? (class$org$apache$ojb$odmg$locking$LockManager = LockManagerFactory.class$("org.apache.ojb.odmg.locking.LockManager")) : class$org$apache$ojb$odmg$locking$LockManager).isAssignableFrom(clazz2)) {
                throw new OJBRuntimeException(this.buildErrorMsg(clazz, clazz2));
            }
            this.setupLockManager(configuration, clazz2);
        }
    }

    private void setupLockManager(Configuration configuration, Class clazz) {
        long l = configuration.getInteger("LockTimeout", 60000);
        this.log.info("LockTimeout=" + l);
        try {
            org.apache.ojb.broker.locking.LockManager lockManager = (org.apache.ojb.broker.locking.LockManager)ClassHelper.newInstance(clazz);
            lockManager.setLockTimeout(l);
            this.lockManager = new LockManagerOdmgImpl(lockManager);
        }
        catch (Exception exception) {
            throw new OJBRuntimeException("Can't setup odmg lock manager instance", exception);
        }
    }

    private void setupLockManager(Class clazz) {
        try {
            this.lockManager = (LockManager)ClassHelper.newInstance(clazz);
        }
        catch (Exception exception) {
            throw new OJBRuntimeException("Can't setup odmg lock manager instance", exception);
        }
    }

    private String buildErrorMsg(Class clazz, Class clazz2) {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer("Can't setup LockManager. Current used properties are:" + string);
        stringBuffer.append("LockMapClass=").append(clazz != null ? clazz.getName() : null).append(string).append("LockManagerClass=").append(clazz2 != null ? clazz2.getName() : null).append(string).append("For correct setup of the lock manager, please enable the 'LockManagerClass' property").append(" in OJB configuration, OJB expects an 'org.apache.ojb.broker.locking.LockManager' implementation class.").append(string).append("Or to enable the *deprecated* odmg-locking api enable the 'LockMapClass' AND the 'LockManager' properties").append(", in this case OJB expects an 'org.apache.ojb.odmg.locking.LockManager' implementation class.");
        return stringBuffer.toString();
    }

    private LockManager getManager() {
        return this.lockManager;
    }

    public static synchronized LockManager getLockManager() {
        if (lockManagerFactory == null) {
            lockManagerFactory = new LockManagerFactory();
        }
        return lockManagerFactory.getManager();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

