/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.util.LinkedList;
import java.util.List;
import one.edee.babylon.enums.PropertyType;
import org.springframework.util.StringUtils;

public class Property {
    static final String MULTILINE_SEPARATOR = "\\";
    private PropertyType type;
    private String value;
    private final List<String> lines = new LinkedList();

    public Property(PropertyType type, String value) {
        this.value = value;
        this.type = type;
    }

    void addLine(String line) {
        this.lines.add(line.replace(System.lineSeparator(), ""));
    }

    public Integer getRowCount() {
        return this.lines.size();
    }

    public PropertyType getType() {
        return this.type;
    }

    public String getValue() {
        if (this.isPropValueMultiLine()) {
            return this.getMultilineValue();
        }
        if (this.isPropEmptyLine()) {
            return "";
        }
        return this.value;
    }

    public void setValue(String value) {
        if (this.isPropValueMultiLine()) {
            this.setMultilineValue(value);
            return;
        }
        this.value = value;
    }

    public boolean isPropValue() {
        return this.type == PropertyType.VALUE;
    }

    public boolean isPropValueMultiLine() {
        return this.type == PropertyType.MULTILINE;
    }

    public boolean isPropEmptyLine() {
        return this.type == PropertyType.EMPTY;
    }

    public boolean isPropComment() {
        return this.type == PropertyType.COMMENT;
    }

    private void setMultilineValue(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            this.lines.clear();
            return;
        }
        String[] split = value.split("\\\\\r\n");
        this.lines.clear();
        for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            if (i < split.length - 1 && !line.endsWith(MULTILINE_SEPARATOR)) {
                line = line + MULTILINE_SEPARATOR;
            }
            this.lines.add(line);
        }
    }

    private String getMultilineValue() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.get(i);
            sb.append(line);
            if (i >= this.lines.size() - 1 || line.endsWith(System.lineSeparator())) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return "Property{type=" + this.type + ", value='" + this.value + '\'' + '}';
    }
}

