/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.MonocleCursor;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;

final class MonocleWindow
extends Window {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_MINIMIZED = 1;
    private static final int STATE_MAXIMIZED = 2;
    private static final int STATE_FULLSCREEN = 3;
    private int id;
    private int state;
    private int cachedX;
    private int cachedY;
    private int cachedW;
    private int cachedH;
    private int minW;
    private int minH;
    private int maxW = -1;
    private int maxH = -1;
    private float cachedAlpha = 1.0f;

    MonocleWindow(Window owner, Screen screen, int styleMask) {
        super(owner, screen, styleMask);
    }

    protected void _toFront(long ptr) {
        MonocleWindowManager.getInstance().toFront(this);
    }

    protected void _toBack(long ptr) {
        MonocleWindowManager.getInstance().toBack(this);
    }

    protected void _setBounds(long nativeWindowPointer, int x, int y, boolean xSet, boolean ySet, int w, int h, int cw, int ch, float xGravity, float yGravity) {
        int width = w > 0 ? w : (cw > 0 ? cw : this.getWidth());
        int height = h > 0 ? h : (ch > 0 ? ch : this.getHeight());
        if (!xSet) {
            x = this.getX();
        }
        if (!ySet) {
            y = this.getY();
        }
        if (this.maxW >= 0) {
            width = Math.min(width, this.maxW);
        }
        if (this.maxH >= 0) {
            height = Math.min(height, this.maxH);
        }
        width = Math.max(width, this.minW);
        height = Math.max(height, this.minH);
        this.notifyResizeAndMove(x, y, width, height);
    }

    private void notifyResizeAndMove(int x, int y, int width, int height) {
        MonocleView view = (MonocleView)this.getView();
        boolean repaintView = false;
        if (this.getWidth() != width || this.getHeight() != height) {
            this.notifyResize(511, width, height);
            if (view != null) {
                view.notifyResize(width, height);
                repaintView = true;
            }
        }
        if (this.getX() != x || this.getY() != y) {
            this.notifyMove(x, y);
            if (view != null) {
                repaintView = true;
            }
        }
        if (repaintView) {
            view.notifyRepaint();
        }
    }

    protected long _createWindow(long NativeWindow, long NativeScreen2, int mask) {
        this.id = MonocleWindowManager.getInstance().addWindow(this);
        return this.id;
    }

    protected boolean _close(long nativeWindowPointer) {
        return MonocleWindowManager.getInstance().closeWindow(this);
    }

    protected boolean _setView(long nativeWindowPointer, View view) {
        boolean result = true;
        if (view != null) {
            ((MonocleView)view).notifyResize(this.getWidth(), this.getHeight());
        }
        return result;
    }

    protected void _updateViewSize(long ptr) {
    }

    public long getNativeWindow() {
        return this.id;
    }

    protected boolean _setMenubar(long ptr, long menubarPtr) {
        return true;
    }

    protected boolean _minimize(long nativeWindowPointer, boolean minimize) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (minimize && this.state != 1) {
            this.state = 1;
            this.cachedX = x;
            this.cachedY = y;
            this.cachedW = width;
            this.cachedH = height;
            MonocleWindow.remove((Window)this);
            this.notifyResize(531, width, height);
        } else if (!minimize && this.state == 1) {
            this.state = 0;
            x = this.cachedX;
            y = this.cachedY;
            width = this.cachedW;
            height = this.cachedH;
            MonocleWindow.add((Window)this);
            this.notifyResize(533, width, height);
        }
        return true;
    }

    protected boolean _maximize(long nativeWindowPointer, boolean maximize, boolean wasMaximized) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (maximize && !wasMaximized) {
            if (this.state == 0) {
                this.cachedX = x;
                this.cachedY = y;
                this.cachedW = width;
                this.cachedH = height;
            }
            if (this.maxW >= 0) {
                width = this.maxW;
                x = Math.min(x, screen.getWidth() - width);
            } else {
                x = 0;
                width = screen.getWidth();
            }
            if (this.maxH >= 0) {
                height = this.maxH;
                y = Math.min(y, screen.getHeight() - height);
            } else {
                y = 0;
                height = screen.getHeight();
            }
            this.state = 2;
        } else if (!maximize && wasMaximized) {
            x = this.cachedX;
            y = this.cachedY;
            width = this.cachedW;
            height = this.cachedH;
            this.state = 0;
        }
        this.notifyResizeAndMove(x, y, width, height);
        return true;
    }

    void setFullScreen(boolean fullscreen) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (fullscreen) {
            if (this.state == 0) {
                this.cachedX = x;
                this.cachedY = y;
                this.cachedW = width;
                this.cachedH = height;
            }
            x = 0;
            y = 0;
            width = screen.getWidth();
            height = screen.getHeight();
            MonocleView view = (MonocleView)this.getView();
            if (view != null) {
                view.notifyView(431);
            }
            this.state = 3;
        } else {
            x = this.cachedX;
            y = this.cachedY;
            width = this.cachedW;
            height = this.cachedH;
            MonocleView view = (MonocleView)this.getView();
            if (view != null) {
                view.notifyView(432);
            }
            this.state = 0;
        }
        this.notifyResizeAndMove(x, y, width, height);
    }

    protected boolean _setVisible(long ptr, boolean visible) {
        if (visible) {
            this.setAlpha(this.cachedAlpha);
        } else {
            this.cachedAlpha = this.getAlpha();
            this.setAlpha(0.0f);
        }
        return true;
    }

    protected boolean _setResizable(long ptr, boolean resizable) {
        return true;
    }

    protected boolean _requestFocus(long ptr, int event) {
        return MonocleWindowManager.getInstance().requestFocus(this);
    }

    protected void _setFocusable(long ptr, boolean isFocusable) {
    }

    protected boolean _setTitle(long ptr, String title) {
        return true;
    }

    protected void _setLevel(long ptr, int level) {
    }

    protected void _setAlpha(long ptr, float alpha) {
    }

    protected boolean _setBackground(long ptr, float r, float g, float b) {
        return true;
    }

    protected void _setEnabled(long ptr, boolean enabled) {
        if (!enabled && this == MonocleWindowManager.getInstance().getFocusedWindow()) {
            MonocleView view = (MonocleView)this.getView();
            try {
                view.notifyMouse(226, 211, 0, 0, 0, 0, 0, false, false);
            }
            catch (RuntimeException e) {
                Application.reportException((Throwable)e);
            }
        }
    }

    protected boolean _setMinimumSize(long ptr, int width, int height) {
        this.minW = width;
        this.minH = height;
        return true;
    }

    protected boolean _setMaximumSize(long ptr, int width, int height) {
        this.maxW = width;
        this.maxH = height;
        return true;
    }

    protected void _setIcon(long ptr, Pixels pixels) {
    }

    protected boolean _grabFocus(long ptr) {
        return MonocleWindowManager.getInstance().grabFocus(this);
    }

    protected void _ungrabFocus(long ptr) {
        MonocleWindowManager.getInstance().ungrabFocus(this);
    }

    protected void _enterModal(long ptr) {
        throw new UnsupportedOperationException();
    }

    protected void _enterModalWithWindow(long dialog, long window) {
        throw new UnsupportedOperationException();
    }

    protected void _exitModal(long ptr) {
        throw new UnsupportedOperationException();
    }

    protected void notifyClose() {
        super.notifyClose();
        this.close();
    }

    protected void notifyDestroy() {
        super.notifyDestroy();
        MonocleWindowManager.getInstance().repaintAll();
    }

    protected void notifyFocus(int event) {
        super.notifyFocus(event);
    }

    protected void _notifyFocusUngrab() {
        this.notifyFocusUngrab();
    }

    void _notifyFocusDisabled() {
        this.notifyFocusDisabled();
    }

    protected void _setCursor(long ptr, Cursor cursor) {
        ((MonocleCursor)cursor).applyCursor();
    }

    protected void _requestInput(long ptr, String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void _releaseInput(long ptr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

