/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mdfx;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.util.ArrayList;
import java.util.List;

public class MDFXUtil {
    public static List<Chapter> getChapters(String markdown) {
        Parser parser = Parser.builder().build();
        Document document = parser.parse(markdown);
        ArrayList<Chapter> chapters = new ArrayList<Chapter>();
        Chapter currentChapter = null;
        int chapterIndex = 0;
        for (Node node = document.getFirstChild(); node != null; node = node.getNext()) {
            if (node instanceof Heading) {
                Heading heading = (Heading)node;
                int level = heading.getLevel();
                String headingText = heading.getText().toString().trim();
                if (level == 1) {
                    currentChapter = new Chapter(++chapterIndex, headingText);
                    chapters.add(currentChapter);
                    continue;
                }
                if (level != 2) continue;
                if (currentChapter == null) {
                    currentChapter = new Chapter(++chapterIndex, "Unnamed Chapter");
                    chapters.add(currentChapter);
                }
                currentChapter.addSubchapter(headingText);
                continue;
            }
            if (currentChapter == null) continue;
            currentChapter.appendContentToCurrentSubchapterOrChapter(node.getChars().toString());
        }
        return chapters;
    }

    public static class Chapter {
        private final int index;
        private final String headingText;
        private final List<Subchapter> subchapters = new ArrayList<Subchapter>();
        private final StringBuilder chapterContent = new StringBuilder();
        private int subchapterIndexCounter = 0;
        private Subchapter currentSubchapter = null;

        public Chapter(int index, String headingText) {
            this.index = index;
            this.headingText = headingText;
        }

        public void addSubchapter(String headingText) {
            this.currentSubchapter = null;
            ++this.subchapterIndexCounter;
            Subchapter sub = new Subchapter(this.subchapterIndexCounter, headingText);
            this.subchapters.add(sub);
            this.currentSubchapter = sub;
        }

        public void appendContentToCurrentSubchapterOrChapter(String content) {
            if (this.currentSubchapter == null) {
                this.chapterContent.append(content).append("\n");
            } else {
                this.currentSubchapter.appendContent(content);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getFullMD() {
            StringBuilder sb = new StringBuilder();
            sb.append("# ").append(this.headingText).append("\n");
            if (this.chapterContent.length() > 0) {
                sb.append((CharSequence)this.chapterContent);
            }
            for (Subchapter sc : this.subchapters) {
                sb.append(sc.getFullMD());
            }
            return sb.toString();
        }

        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (this.chapterContent.length() > 0) {
                sb.append((CharSequence)this.chapterContent);
            }
            for (Subchapter sc : this.subchapters) {
                sb.append(sc.getContent());
            }
            return sb.toString();
        }

        public String getHeadingText() {
            return this.headingText;
        }

        public List<Subchapter> getSubchapters() {
            return this.subchapters;
        }
    }

    public static class Subchapter {
        private final int index;
        private final String headingText;
        private final StringBuilder content = new StringBuilder();

        public Subchapter(int index, String headingText) {
            this.index = index;
            this.headingText = headingText;
        }

        public void appendContent(String c) {
            this.content.append(c).append("\n");
        }

        public int getIndex() {
            return this.index;
        }

        public String getHeadingText() {
            return this.headingText;
        }

        public String getFullMD() {
            StringBuilder sb = new StringBuilder();
            sb.append("## ").append(this.headingText).append("\n");
            if (this.content.length() > 0) {
                sb.append((CharSequence)this.content);
            }
            return sb.toString();
        }

        public String getContent() {
            return this.content.toString();
        }
    }
}

