/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mdfx.impl;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.Escaping;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.util.Pair;
import one.jpro.platform.mdfx.MarkdownView;

public class MDFXNodeHelper
extends VBox {
    MarkdownView parent;
    static final String ITALIC_CLASS_NAME = "markdown-italic";
    static final String BOLD_CLASS_NAME = "markdown-bold";
    static final String STRIKETHROUGH_CLASS_NAME = "markdown-strikethrough";
    List<String> elemStyleClass = new LinkedList<String>();
    List<Consumer<Pair<Node, String>>> elemFunctions = new LinkedList<Consumer<Pair<Node, String>>>();
    Boolean nodePerWord = false;
    List<String> styles = new LinkedList<String>();
    VBox root = new VBox();
    GridPane grid = null;
    int gridx = 0;
    int gridy = 0;
    TextFlow flow = null;
    boolean isListOrdered = false;
    int orderedListCounter = 0;
    int[] currentChapter = new int[6];

    public boolean shouldShowContent() {
        return this.parent.showChapter(this.currentChapter);
    }

    public void newParagraph() {
        TextFlow newFlow = new TextFlow();
        newFlow.getStyleClass().add((Object)"markdown-normal-flow");
        this.root.getChildren().add((Object)newFlow);
        this.flow = newFlow;
    }

    public MDFXNodeHelper(MarkdownView parent, String mdstring) {
        this.parent = parent;
        this.root.getStyleClass().add((Object)"markdown-paragraph-list");
        this.root.setFillWidth(true);
        LinkedList<Object> extensions = new LinkedList<Object>();
        extensions.add(TablesExtension.create());
        extensions.add(AttributesExtension.create());
        extensions.add(StrikethroughExtension.create());
        extensions.add(TaskListExtension.create());
        Parser parser = ((Parser.Builder)Parser.builder().extensions(extensions)).build();
        Document node = parser.parse(mdstring);
        (MDFXNodeHelper)this.new MDParser((Document)node).visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)node);
        this.getChildren().add((Object)this.root);
    }

    public void addText(String text, String wholeText) {
        if (!text.isEmpty()) {
            javafx.scene.text.Text toAdd = new javafx.scene.text.Text(text);
            toAdd.getStyleClass().add((Object)"markdown-text");
            this.addFeatures((Node)toAdd, wholeText);
            this.flow.getChildren().add((Object)toAdd);
        }
    }

    public void addFeatures(Node toAdd, String wholeText) {
        for (String string : this.elemStyleClass) {
            toAdd.getStyleClass().add((Object)string);
        }
        for (Consumer consumer : this.elemFunctions) {
            consumer.accept(new Pair((Object)toAdd, (Object)wholeText));
        }
        if (!this.styles.isEmpty()) {
            StringBuilder tmp = new StringBuilder();
            for (String style : this.styles) {
                tmp.append(style).append(";");
            }
            toAdd.setStyle(toAdd.getStyle() + String.valueOf(tmp));
        }
    }

    class MDParser {
        Document document;
        NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Code.class, this::visit), new VisitHandler(BlockQuote.class, this::visit), new VisitHandler(Block.class, this::visit), new VisitHandler(Document.class, this::visit), new VisitHandler(Emphasis.class, this::visit), new VisitHandler(StrongEmphasis.class, this::visit), new VisitHandler(FencedCodeBlock.class, this::visit), new VisitHandler(SoftLineBreak.class, this::visit), new VisitHandler(HardLineBreak.class, this::visit), new VisitHandler(Heading.class, this::visit), new VisitHandler(ListItem.class, this::visit), new VisitHandler(BulletListItem.class, this::visit), new VisitHandler(OrderedListItem.class, this::visit), new VisitHandler(TaskListItem.class, this::visit), new VisitHandler(BulletList.class, this::visit), new VisitHandler(OrderedList.class, this::visit), new VisitHandler(Paragraph.class, this::visit), new VisitHandler(Image.class, this::visit), new VisitHandler(Link.class, this::visit), new VisitHandler(TextBase.class, this::visit), new VisitHandler(Text.class, this::visit), new VisitHandler(Strikethrough.class, this::visit), new VisitHandler(TableHead.class, this::visit), new VisitHandler(TableBody.class, this::visit), new VisitHandler(TableRow.class, this::visit), new VisitHandler(TableCell.class, this::visit)});

        MDParser(Document document) {
            this.document = document;
        }

        public void visit(Code code) {
            Label label = new Label(code.getText().normalizeEOL());
            label.getStyleClass().add((Object)"markdown-code");
            Region bgr1 = new Region();
            bgr1.setManaged(false);
            bgr1.getStyleClass().add((Object)"markdown-code-background");
            label.boundsInParentProperty().addListener((p, oldV, newV) -> {
                bgr1.setTranslateX(newV.getMinX() + 2.0);
                bgr1.setTranslateY(newV.getMinY() - 2.0);
                bgr1.resize(newV.getWidth() - 4.0, newV.getHeight() + 4.0);
            });
            MDFXNodeHelper.this.flow.getChildren().add((Object)bgr1);
            MDFXNodeHelper.this.flow.getChildren().add((Object)label);
        }

        public void visit(BlockQuote customBlock) {
            VBox oldRoot = MDFXNodeHelper.this.root;
            MDFXNodeHelper.this.root = new VBox();
            MDFXNodeHelper.this.root.getStyleClass().add((Object)"markdown-normal-block-quote");
            oldRoot.getChildren().add((Object)MDFXNodeHelper.this.root);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customBlock);
            MDFXNodeHelper.this.root = oldRoot;
            MDFXNodeHelper.this.newParagraph();
        }

        public void visit(Block customBlock) {
            MDFXNodeHelper.this.flow.getChildren().add((Object)new javafx.scene.text.Text("\n\n"));
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customBlock);
        }

        public void visit(Document document) {
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)document);
        }

        public void visit(Emphasis emphasis) {
            MDFXNodeHelper.this.elemStyleClass.add(MDFXNodeHelper.ITALIC_CLASS_NAME);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)emphasis);
            MDFXNodeHelper.this.elemStyleClass.remove(MDFXNodeHelper.ITALIC_CLASS_NAME);
        }

        public void visit(StrongEmphasis strongEmphasis) {
            MDFXNodeHelper.this.elemStyleClass.add(MDFXNodeHelper.BOLD_CLASS_NAME);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)strongEmphasis);
            MDFXNodeHelper.this.elemStyleClass.remove(MDFXNodeHelper.BOLD_CLASS_NAME);
        }

        public void visit(Strikethrough strikethrough) {
            MDFXNodeHelper.this.elemStyleClass.add(MDFXNodeHelper.STRIKETHROUGH_CLASS_NAME);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)strikethrough);
            MDFXNodeHelper.this.elemStyleClass.remove(MDFXNodeHelper.STRIKETHROUGH_CLASS_NAME);
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            Label label = new Label(fencedCodeBlock.getContentChars().toString());
            label.getStyleClass().add((Object)"markdown-codeblock");
            VBox vbox = new VBox(new Node[]{label});
            vbox.getStyleClass().add((Object)"markdown-codeblock-box");
            MDFXNodeHelper.this.root.getChildren().add((Object)vbox);
        }

        public void visit(SoftLineBreak softLineBreak) {
            MDFXNodeHelper.this.addText(" ", "");
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)softLineBreak);
        }

        public void visit(HardLineBreak hardLineBreak) {
            MDFXNodeHelper.this.flow.getChildren().add((Object)new javafx.scene.text.Text("\n"));
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)hardLineBreak);
        }

        public void visit(Heading heading) {
            if (heading.getLevel() == 1 || heading.getLevel() == 2) {
                int n = heading.getLevel();
                MDFXNodeHelper.this.currentChapter[n] = MDFXNodeHelper.this.currentChapter[n] + 1;
                for (int i = heading.getLevel() + 1; i <= MDFXNodeHelper.this.currentChapter.length - 1; ++i) {
                    MDFXNodeHelper.this.currentChapter[i] = 0;
                }
            }
            if (MDFXNodeHelper.this.shouldShowContent()) {
                MDFXNodeHelper.this.newParagraph();
                MDFXNodeHelper.this.flow.getStyleClass().add((Object)("markdown-heading-" + heading.getLevel()));
                MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-heading");
                this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)heading);
            }
        }

        public void visitListItem(String text, com.vladsch.flexmark.util.ast.Node node) {
            VBox oldRoot = MDFXNodeHelper.this.root;
            VBox newRoot = new VBox();
            newRoot.getStyleClass().add((Object)"markdown-vbox1");
            newRoot.getStyleClass().add((Object)"markdown-paragraph-list");
            newRoot.setFillWidth(true);
            ++MDFXNodeHelper.this.orderedListCounter;
            Label dot = new Label(text);
            dot.getStyleClass().add((Object)"markdown-listitem-dot");
            dot.getStyleClass().add((Object)"markdown-text");
            HBox hbox = new HBox();
            hbox.getStyleClass().add((Object)"markdown-hbox1");
            hbox.getChildren().add((Object)dot);
            hbox.setAlignment(Pos.TOP_LEFT);
            HBox.setHgrow((Node)newRoot, (Priority)Priority.ALWAYS);
            newRoot.setPrefWidth(1.0);
            hbox.getChildren().add((Object)newRoot);
            oldRoot.getChildren().add((Object)hbox);
            MDFXNodeHelper.this.root = newRoot;
            this.visitor.visitChildren(node);
            MDFXNodeHelper.this.root = oldRoot;
        }

        public void visit(TaskListItem listItem) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            String text = listItem.isItemDoneMarker() ? "\u2611" : "\u2610";
            this.visitListItem(text, (com.vladsch.flexmark.util.ast.Node)listItem);
        }

        public void visit(ListItem listItem) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            String text = MDFXNodeHelper.this.isListOrdered ? " " + (MDFXNodeHelper.this.orderedListCounter + 1) + ". " : " \u2022 ";
            this.visitListItem(text, (com.vladsch.flexmark.util.ast.Node)listItem);
        }

        public void visit(BulletList bulletList) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            boolean prevIsListOrdered = MDFXNodeHelper.this.isListOrdered;
            int prevListCounter = MDFXNodeHelper.this.orderedListCounter;
            MDFXNodeHelper.this.isListOrdered = false;
            VBox oldRoot = MDFXNodeHelper.this.root;
            MDFXNodeHelper.this.root = new VBox();
            oldRoot.getChildren().add((Object)MDFXNodeHelper.this.root);
            MDFXNodeHelper.this.newParagraph();
            MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-normal-flow");
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)bulletList);
            MDFXNodeHelper.this.isListOrdered = prevIsListOrdered;
            MDFXNodeHelper.this.orderedListCounter = prevListCounter;
            MDFXNodeHelper.this.root = oldRoot;
        }

        public void visit(OrderedList orderedList) {
            int previousCounter = MDFXNodeHelper.this.orderedListCounter;
            boolean prevIsListOrdered = MDFXNodeHelper.this.isListOrdered;
            MDFXNodeHelper.this.orderedListCounter = 0;
            MDFXNodeHelper.this.isListOrdered = true;
            VBox oldRoot = MDFXNodeHelper.this.root;
            MDFXNodeHelper.this.root = new VBox();
            oldRoot.getChildren().add((Object)MDFXNodeHelper.this.root);
            MDFXNodeHelper.this.newParagraph();
            MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-normal-flow");
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)orderedList);
            MDFXNodeHelper.this.orderedListCounter = previousCounter;
            MDFXNodeHelper.this.isListOrdered = prevIsListOrdered;
            MDFXNodeHelper.this.root = oldRoot;
        }

        public void visit(Paragraph paragraph) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            ArrayList atts = ((NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.get((DataHolder)this.document)).get((Object)paragraph);
            MDFXNodeHelper.this.newParagraph();
            MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-normal-flow");
            this.setAttrs(atts, true);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)paragraph);
            this.setAttrs(atts, false);
        }

        public void visit(Image image) {
            String url = image.getUrl().toString();
            Node node = MDFXNodeHelper.this.parent.generateImage(url);
            MDFXNodeHelper.this.addFeatures(node, "");
            MDFXNodeHelper.this.flow.getChildren().add((Object)node);
        }

        public void visit(Link link) {
            LinkedList nodes = new LinkedList();
            Consumer<Pair> addProp = pair -> {
                Node node = (Node)pair.getKey();
                String txt = (String)pair.getValue();
                nodes.add(node);
                node.getStyleClass().add((Object)"markdown-link");
                MDFXNodeHelper.this.parent.setLink(node, link.getUrl().normalizeEOL(), txt);
            };
            Platform.runLater(() -> {
                SimpleBooleanProperty lastValue = new SimpleBooleanProperty(false);
                Runnable updateState = () -> MDParser.lambda$visit$2(nodes, (BooleanProperty)lastValue);
                for (Node node : nodes) {
                    node.hoverProperty().addListener((p, o, n) -> updateState.run());
                }
                updateState.run();
            });
            boolean oldNodePerWord = MDFXNodeHelper.this.nodePerWord;
            MDFXNodeHelper.this.nodePerWord = true;
            MDFXNodeHelper.this.elemFunctions.add(addProp);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)link);
            MDFXNodeHelper.this.nodePerWord = oldNodePerWord;
            MDFXNodeHelper.this.elemFunctions.remove(addProp);
        }

        public void visit(TextBase text) {
            ArrayList atts = ((NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.get((DataHolder)this.document)).get((Object)text);
            this.setAttrs(atts, true);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)text);
            this.setAttrs(atts, false);
        }

        public void visit(Text text) {
            String[] textsSplit;
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)text);
            String wholeText = Escaping.unescapeString((CharSequence)text.getChars().normalizeEOL());
            if (MDFXNodeHelper.this.nodePerWord.booleanValue()) {
                textsSplit = wholeText.split("(?<= )");
                for (int i = 0; i <= textsSplit.length - 1; ++i) {
                    if (!textsSplit[i].equals(" ")) continue;
                    if (i == 0) {
                        if (i + 1 > textsSplit.length - 1) continue;
                        textsSplit[i + 1] = " " + textsSplit[i + 1];
                        textsSplit[i] = "";
                        continue;
                    }
                    textsSplit[i - 1] = textsSplit[i - 1] + textsSplit[i];
                    textsSplit[i] = "";
                }
            } else {
                textsSplit = new String[]{wholeText};
            }
            String[] textsSplitFinal = textsSplit;
            for (int i = 0; i <= textsSplit.length - 1; ++i) {
                if (textsSplitFinal[i].isEmpty()) continue;
                MDFXNodeHelper.this.addText(textsSplitFinal[i], wholeText);
            }
        }

        public void visit(TableHead customNode) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            TextFlow oldFlow = MDFXNodeHelper.this.flow;
            MDFXNodeHelper.this.grid = new GridPane();
            MDFXNodeHelper.this.grid.getStyleClass().add((Object)"markdown-table-table");
            MDFXNodeHelper.this.gridx = 0;
            MDFXNodeHelper.this.gridy = -1;
            MDFXNodeHelper.this.root.getChildren().add((Object)MDFXNodeHelper.this.grid);
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customNode);
            for (int i = 1; i <= MDFXNodeHelper.this.gridx; ++i) {
                ColumnConstraints constraint = new ColumnConstraints();
                if (i == MDFXNodeHelper.this.gridx) {
                    constraint.setPercentWidth(100.0 * (2.0 / ((double)MDFXNodeHelper.this.gridx + 1.0)));
                }
                MDFXNodeHelper.this.grid.getColumnConstraints().add((Object)constraint);
            }
            MDFXNodeHelper.this.flow = oldFlow;
            MDFXNodeHelper.this.newParagraph();
        }

        public void visit(TableBody customNode) {
            if (!MDFXNodeHelper.this.shouldShowContent()) {
                return;
            }
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customNode);
        }

        public void visit(TableRow customNode) {
            if (customNode.getRowNumber() != 0) {
                MDFXNodeHelper.this.gridx = 0;
                ++MDFXNodeHelper.this.gridy;
                this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customNode);
            }
        }

        public void visit(TableCell customNode) {
            MDFXNodeHelper.this.flow = new TextFlow();
            MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-normal-flow");
            MDFXNodeHelper.this.flow.setPrefWidth(9999.0);
            MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-table-cell");
            if (MDFXNodeHelper.this.gridy == 0) {
                MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-table-cell-top");
            }
            if (MDFXNodeHelper.this.gridy % 2 == 0) {
                MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-table-odd");
            } else {
                MDFXNodeHelper.this.flow.getStyleClass().add((Object)"markdown-table-even");
            }
            MDFXNodeHelper.this.grid.add((Node)MDFXNodeHelper.this.flow, MDFXNodeHelper.this.gridx, MDFXNodeHelper.this.gridy);
            ++MDFXNodeHelper.this.gridx;
            this.visitor.visitChildren((com.vladsch.flexmark.util.ast.Node)customNode);
        }

        public void setAttrs(List<AttributesNode> atts, boolean add) {
            if (atts == null) {
                return;
            }
            LinkedList<com.vladsch.flexmark.util.ast.Node> atts2 = new LinkedList<com.vladsch.flexmark.util.ast.Node>();
            for (AttributesNode att2 : atts) {
                for (com.vladsch.flexmark.util.ast.Node attChild : att2.getChildren()) {
                    atts2.add(attChild);
                }
            }
            List atts3 = atts2;
            atts3.forEach(att -> {
                if ("style".contentEquals((CharSequence)att.getName().toLowerCase())) {
                    if (add) {
                        MDFXNodeHelper.this.styles.add(att.getValue().toString());
                    } else {
                        MDFXNodeHelper.this.styles.remove(att.getValue().toString());
                    }
                }
                if (att.isClass()) {
                    if (add) {
                        MDFXNodeHelper.this.elemStyleClass.add(att.getValue().toString());
                    } else {
                        MDFXNodeHelper.this.elemStyleClass.remove(att.getValue().toString());
                    }
                }
            });
        }

        private static /* synthetic */ void lambda$visit$2(LinkedList nodes, BooleanProperty lastValue) {
            boolean isHover = false;
            for (Node node : nodes) {
                if (!node.isHover()) continue;
                isHover = true;
            }
            if (isHover != lastValue.get()) {
                lastValue.set(isHover);
                for (Node node : nodes) {
                    if (isHover) {
                        node.getStyleClass().add((Object)"markdown-link-hover");
                        continue;
                    }
                    node.getStyleClass().remove((Object)"markdown-link-hover");
                }
            }
        }
    }
}

