/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.aws.s3.types;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.microstream.X;
import one.microstream.afs.aws.s3.types.S3PathValidator;
import one.microstream.afs.blobstore.types.BlobStoreConnector;
import one.microstream.afs.blobstore.types.BlobStorePath;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.io.ByteBufferInputStream;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public interface S3Connector
extends BlobStoreConnector {
    public static S3Connector New(S3Client s3) {
        return new Default((S3Client)X.notNull((Object)s3), false);
    }

    public static S3Connector Caching(S3Client s3) {
        return new Default((S3Client)X.notNull((Object)s3), true);
    }

    public static class Default
    extends BlobStoreConnector.Abstract<S3Object>
    implements S3Connector {
        private final S3Client s3;

        Default(S3Client s3, boolean useCache) {
            super(S3Object::key, S3Object::size, (BlobStorePath.Validator)S3PathValidator.New(), useCache);
            this.s3 = s3;
        }

        protected Stream<S3Object> blobs(BlobStorePath file) {
            String prefix = Default.toBlobKeyPrefix((BlobStorePath)file);
            Pattern pattern = Pattern.compile(Default.blobKeyRegex((String)prefix));
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(file.container()).prefix(prefix).build();
            return this.s3.listObjectsV2(request).contents().stream().filter(obj -> pattern.matcher(obj.key()).matches()).sorted(this.blobComparator());
        }

        protected Stream<String> childKeys(BlobStorePath directory) {
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(directory.container()).prefix(Default.toChildKeysPrefix((BlobStorePath)directory)).delimiter("/").build();
            return this.s3.listObjectsV2(request).contents().stream().map(S3Object::key);
        }

        protected void internalReadBlobData(BlobStorePath file, S3Object blob, ByteBuffer targetBuffer, long offset, long length) {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(file.container()).key(blob.key()).range("bytes=" + offset + "-" + (offset + length - 1L)).build();
            ResponseBytes response = this.s3.getObjectAsBytes(request);
            targetBuffer.put(response.asByteBuffer());
        }

        protected boolean internalDirectoryExists(BlobStorePath directory) {
            try {
                HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(directory.container()).key(Default.toContainerKey((BlobStorePath)directory)).build();
                this.s3.headObject(request);
                return true;
            }
            catch (NoSuchKeyException e) {
                return false;
            }
        }

        protected boolean internalFileExists(BlobStorePath file) {
            try {
                return super.internalFileExists(file);
            }
            catch (NoSuchBucketException e) {
                return false;
            }
        }

        protected boolean internalCreateDirectory(BlobStorePath directory) {
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(directory.container()).key(Default.toContainerKey((BlobStorePath)directory)).build();
            RequestBody body = RequestBody.empty();
            this.s3.putObject(request, body);
            return true;
        }

        protected boolean internalDeleteBlobs(BlobStorePath file, List<? extends S3Object> blobs) {
            List objects = blobs.stream().map(obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build()).collect(Collectors.toList());
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(file.container()).delete((Delete)Delete.builder().objects(objects).build()).build();
            DeleteObjectsResponse response = this.s3.deleteObjects(request);
            return response.deleted().size() == blobs.size();
        }

        protected long internalWriteData(BlobStorePath file, Iterable<? extends ByteBuffer> sourceBuffers) {
            long nextBlobNumber = this.nextBlobNumber(file);
            long totalSize = this.totalSize(sourceBuffers);
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(file.container()).key(Default.toBlobKey((BlobStorePath)file, (long)nextBlobNumber)).build();
            try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)ByteBufferInputStream.New(sourceBuffers));){
                RequestBody body = RequestBody.fromContentProvider(() -> inputStream, (long)totalSize, (String)"application/octet-stream");
                this.s3.putObject(request, body);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            return totalSize;
        }
    }
}

