/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.aws.s3.types;

import one.microstream.afs.aws.s3.types.S3Connector;
import one.microstream.afs.aws.types.AwsFileSystemCreator;
import one.microstream.afs.blobstore.types.BlobStoreConnector;
import one.microstream.afs.blobstore.types.BlobStoreFileSystem;
import one.microstream.afs.types.AFileSystem;
import one.microstream.configuration.types.Configuration;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3FileSystemCreator
extends AwsFileSystemCreator {
    public AFileSystem create(Configuration configuration) {
        Configuration s3Configuration = configuration.child("aws.s3");
        if (s3Configuration == null) {
            return null;
        }
        S3ClientBuilder clientBuilder = S3Client.builder();
        this.populateBuilder((AwsClientBuilder)clientBuilder, s3Configuration);
        S3Client client = (S3Client)clientBuilder.build();
        boolean cache = configuration.optBoolean("cache").orElse(true);
        S3Connector connector = cache ? S3Connector.Caching(client) : S3Connector.New(client);
        return BlobStoreFileSystem.New((BlobStoreConnector)connector);
    }
}

