/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.nio.types;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.afs.nio.types.NioIoHandler;
import one.microstream.afs.nio.types.NioPathResolver;
import one.microstream.afs.nio.types.NioReadableFile;
import one.microstream.afs.nio.types.NioWritableFile;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.afs.types.AIoHandler;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AResolver;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.VarString;
import one.microstream.io.XIO;

public interface NioFileSystem
extends AFileSystem,
AResolver<Path, Path> {
    public NioIoHandler ioHandler();

    public ADirectory ensureDefaultRoot();

    public static NioFileSystem New() {
        return NioFileSystem.New(Defaults.defaultProtocol());
    }

    public static NioFileSystem New(String defaultProtocol) {
        return NioFileSystem.New(defaultProtocol, NioIoHandler.New());
    }

    public static NioFileSystem New(NioIoHandler ioHandler) {
        return NioFileSystem.New(Defaults.defaultProtocol(), (NioIoHandler)X.notNull((Object)ioHandler));
    }

    public static NioFileSystem New(String defaultProtocol, NioIoHandler ioHandler) {
        return new Default((String)X.notNull((Object)defaultProtocol), (NioIoHandler)X.notNull((Object)ioHandler));
    }

    public static NioFileSystem New(FileSystem fileSystem) {
        return NioFileSystem.New(NioIoHandler.New(NioPathResolver.New(fileSystem)));
    }

    public static class Default
    extends AFileSystem.Abstract<NioIoHandler, Path, Path>
    implements NioFileSystem {
        protected Default(String defaultProtocol, NioIoHandler ioHandler) {
            super(defaultProtocol, (AIoHandler)ioHandler);
        }

        @Override
        public final synchronized ADirectory ensureDefaultRoot() {
            return this.ensureRoot("./");
        }

        public String deriveFileIdentifier(String fileName, String fileType) {
            return XIO.addFileSuffix((String)fileName, (String)fileType);
        }

        public String deriveFileName(String fileIdentifier) {
            return XIO.getFilePrefix((String)fileIdentifier);
        }

        public String deriveFileType(String fileIdentifier) {
            return XIO.getFileSuffix((String)fileIdentifier);
        }

        public String getFileName(AFile file) {
            return XIO.getFilePrefix((String)file.identifier());
        }

        public String getFileType(AFile file) {
            return XIO.getFileSuffix((String)file.identifier());
        }

        public AFile createFile(ADirectory parent, String identifier, String name, String type) {
            if (identifier != null) {
                return super.createFile(parent, identifier, name, type);
            }
            if (type == null) {
                return this.createFile(parent, name);
            }
            return this.createFile(parent, XIO.addFileSuffix((String)name, (String)type));
        }

        public String[] resolveDirectoryToPath(Path directory) {
            return XIO.splitPath((Path)directory);
        }

        public String[] resolveFileToPath(Path file) {
            return XIO.splitPath((Path)file);
        }

        public Path resolve(ADirectory directory) {
            return ((NioIoHandler)this.ioHandler()).toPath((AItem)directory);
        }

        public Path resolve(AFile file) {
            return ((NioIoHandler)this.ioHandler()).toPath((AItem)file);
        }

        protected VarString assembleItemPath(AItem item, VarString vs) {
            return XIO.assemblePath((VarString)vs, (CharSequence[])item.toPath());
        }

        public AReadableFile wrapForReading(AFile file, Object user) {
            Path path = this.resolve(file);
            return NioReadableFile.New(file, user, path);
        }

        public AWritableFile wrapForWriting(AFile file, Object user) {
            Path path = this.resolve(file);
            return NioWritableFile.New(file, user, path);
        }

        public AReadableFile convertToReading(AWritableFile file) {
            NioWritableFile wf = ((NioIoHandler)this.ioHandler()).castWritableFile(file);
            boolean actuallyClosedChannel = wf.closeChannel();
            NioReadableFile rf = NioReadableFile.New((AFile)file, file.user(), wf.path(), null);
            if (actuallyClosedChannel) {
                rf.ensureOpenChannel();
            }
            return rf;
        }

        public AWritableFile convertToWriting(AReadableFile file) {
            NioReadableFile wf = ((NioIoHandler)this.ioHandler()).castReadableFile(file);
            boolean actuallyClosedChannel = wf.closeChannel();
            NioWritableFile rf = NioWritableFile.New((AFile)file, file.user(), wf.path(), null);
            if (actuallyClosedChannel) {
                rf.ensureOpenChannel();
            }
            return rf;
        }
    }

    public static interface Defaults {
        public static String defaultProtocol() {
            return "file:///";
        }
    }
}

