/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.nio.types;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.afs.exceptions.AfsExceptionRetiredFile;
import one.microstream.afs.nio.types.NioItemWrapper;
import one.microstream.afs.types.AFile;
import one.microstream.chars.XChars;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.io.XIO;

public interface NioFileWrapper
extends AFile.Wrapper,
NioItemWrapper {
    public FileChannel fileChannel();

    public boolean retire();

    public boolean isRetired();

    public boolean isChannelOpen();

    public boolean checkChannelOpen();

    public FileChannel ensureOpenChannel();

    public FileChannel ensureOpenChannel(OpenOption ... var1);

    public boolean openChannel() throws IORuntimeException;

    public boolean openChannel(OpenOption ... var1) throws IORuntimeException;

    public boolean reopenChannel(OpenOption ... var1) throws IORuntimeException;

    public boolean closeChannel() throws IORuntimeException;

    public static abstract class Abstract<U>
    extends AFile.Wrapper.Abstract<U>
    implements NioFileWrapper {
        Path path;
        FileChannel fileChannel;
        private static final OpenOption[] EMPTY_OPEN_OPTIONS = new OpenOption[0];

        protected Abstract(AFile actual, U user, Path path, FileChannel fileChannel) {
            super(actual, user);
            this.path = (Path)X.notNull((Object)path);
            this.fileChannel = (FileChannel)X.mayNull((Object)fileChannel);
            this.ensurePositionAtFileEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Path path() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                return this.path;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel fileChannel() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                return this.fileChannel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retire() {
            Object object = this.mutex();
            synchronized (object) {
                block4: {
                    if (this.path != null) break block4;
                    return false;
                }
                this.path = null;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRetired() {
            Object object = this.mutex();
            synchronized (object) {
                return this.path == null;
            }
        }

        public void validateIsNotRetired() {
            if (!this.isRetired()) {
                return;
            }
            throw new AfsExceptionRetiredFile("File is retired: " + XChars.systemString((Object)this) + "(\"" + this.toPathString() + "\").");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean closeChannel() throws IORuntimeException {
            Object object = this.mutex();
            synchronized (object) {
                block4: {
                    if (this.isChannelOpen()) break block4;
                    return false;
                }
                this.ensureClearedFileChannelField();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isChannelOpen() {
            Object object = this.mutex();
            synchronized (object) {
                return this.fileChannel != null && this.fileChannel.isOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkChannelOpen() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                return this.isChannelOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel ensureOpenChannel() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                this.openChannel(this.normalizeOpenOptions(new OpenOption[0]));
                return this.fileChannel();
            }
        }

        protected OpenOption[] normalizeOpenOptions(OpenOption ... options) {
            if (options == null) {
                return EMPTY_OPEN_OPTIONS;
            }
            this.validateOpenOptions(options);
            return options;
        }

        protected abstract void validateOpenOptions(OpenOption ... var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel ensureOpenChannel(OpenOption ... options) {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                this.openChannel(options);
                return this.fileChannel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean openChannel() throws IORuntimeException {
            Object object = this.mutex();
            synchronized (object) {
                return this.openChannel(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean openChannel(OpenOption ... options) throws IORuntimeException {
            Object object = this.mutex();
            synchronized (object) {
                block6: {
                    if (!this.checkChannelOpen()) break block6;
                    return false;
                }
                OpenOption[] effectiveOptions = this.normalizeOpenOptions(options);
                try {
                    FileChannel fileChannel = XIO.openFileChannel((Path)this.path, (OpenOption[])effectiveOptions);
                    this.internalSetFileChannel(fileChannel);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                return true;
            }
        }

        protected void internalSetFileChannel(FileChannel fileChannel) {
            this.fileChannel = fileChannel;
            this.ensurePositionAtFileEnd();
        }

        protected void ensurePositionAtFileEnd() throws IORuntimeException {
            if (this.fileChannel == null) {
                return;
            }
            try {
                long fileSize = this.fileChannel.size();
                if (this.fileChannel.position() != fileSize) {
                    this.fileChannel.position(fileSize);
                }
            }
            catch (IOException e) {
                this.ensureClearedFileChannelField(e);
                throw new IORuntimeException(e);
            }
        }

        private void ensureClearedFileChannelField() {
            this.ensureClearedFileChannelField(null);
        }

        private void ensureClearedFileChannelField(Throwable cause) {
            FileChannel fc = this.fileChannel;
            this.fileChannel = null;
            XIO.unchecked.close((Closeable)fc, (Throwable)cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean reopenChannel(OpenOption ... options) throws IORuntimeException {
            Object object = this.mutex();
            synchronized (object) {
                this.closeChannel();
                return this.openChannel(options);
            }
        }
    }
}

