/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.nio.types;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.io.XIO;

@FunctionalInterface
public interface NioPathResolver {
    public Path resolvePath(String ... var1);

    public static NioPathResolver New() {
        return new Default(FileSystems.getDefault());
    }

    public static NioPathResolver New(FileSystem fileSystem) {
        return new Default((FileSystem)X.notNull((Object)fileSystem));
    }

    public static class Default
    implements NioPathResolver {
        private final FileSystem fileSystem;

        Default(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public Path resolvePath(String ... pathElements) {
            return XIO.Path((FileSystem)this.fileSystem, (String[])pathElements);
        }
    }
}

