/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.nio.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import one.microstream.X;
import one.microstream.afs.nio.types.NioFileWrapper;
import one.microstream.afs.nio.types.NioItemWrapper;
import one.microstream.afs.nio.types.NioPathResolver;
import one.microstream.afs.nio.types.NioReadableFile;
import one.microstream.afs.nio.types.NioWritableFile;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AIoHandler;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.afs.types.WriteController;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.io.BufferProvider;
import one.microstream.io.XIO;

public interface NioIoHandler
extends AIoHandler {
    public NioReadableFile castReadableFile(AReadableFile var1);

    public NioWritableFile castWritableFile(AWritableFile var1);

    public Path toPath(AItem var1);

    public Path toPath(String ... var1);

    public static NioIoHandler New() {
        return NioIoHandler.New(WriteController.Enabled());
    }

    public static NioIoHandler New(WriteController writeController) {
        return new Default((WriteController)X.notNull((Object)writeController), NioPathResolver.New());
    }

    public static NioIoHandler New(NioPathResolver pathResolver) {
        return new Default(WriteController.Enabled(), pathResolver);
    }

    public static NioIoHandler New(WriteController writeController, NioPathResolver pathResolver) {
        return new Default((WriteController)X.notNull((Object)writeController), (NioPathResolver)X.notNull((Object)pathResolver));
    }

    public static final class Default
    extends AIoHandler.Abstract<Path, Path, NioItemWrapper, NioFileWrapper, ADirectory, NioReadableFile, NioWritableFile>
    implements NioIoHandler {
        private final NioPathResolver pathResolver;

        Default(WriteController writeController, NioPathResolver pathResolver) {
            super(writeController, NioItemWrapper.class, NioFileWrapper.class, ADirectory.class, NioReadableFile.class, NioWritableFile.class);
            this.pathResolver = pathResolver;
        }

        @Override
        public Path toPath(AItem item) {
            if (item instanceof NioItemWrapper) {
                return ((NioItemWrapper)item).path();
            }
            return this.pathResolver.resolvePath(item.toPath());
        }

        @Override
        public Path toPath(String ... pathElements) {
            return this.pathResolver.resolvePath(pathElements);
        }

        @Override
        public NioReadableFile castReadableFile(AReadableFile file) {
            return (NioReadableFile)super.castReadableFile(file);
        }

        @Override
        public NioWritableFile castWritableFile(AWritableFile file) {
            return (NioWritableFile)super.castWritableFile(file);
        }

        protected Path toSubjectFile(AFile file) {
            return this.toPath(file.toPath());
        }

        protected Path toSubjectDirectory(ADirectory directory) {
            return this.toPath(directory.toPath());
        }

        protected long subjectFileSize(Path file) {
            return XIO.unchecked.size((Path)file);
        }

        protected boolean subjectFileExists(Path file) {
            return XIO.unchecked.exists((Path)file);
        }

        protected boolean subjectDirectoryExists(Path directory) {
            return XIO.unchecked.exists((Path)directory);
        }

        protected long specificSize(NioFileWrapper file) {
            return this.subjectFileSize(file.path());
        }

        protected boolean specificExists(NioFileWrapper file) {
            return this.subjectFileExists(file.path());
        }

        protected boolean specificExists(ADirectory directory) {
            return this.subjectFileExists(this.toSubjectDirectory(directory));
        }

        protected XGettingEnum<String> specificListItems(ADirectory parent) {
            Path dirPath = this.toSubjectDirectory(parent);
            EqHashEnum files = EqHashEnum.New();
            XIO.unchecked.listEntries((Path)dirPath, p -> files.add((Object)XIO.getFileName((Path)p)));
            return files;
        }

        protected XGettingEnum<String> specificListDirectories(ADirectory parent) {
            Path dirPath = this.toSubjectDirectory(parent);
            EqHashEnum files = EqHashEnum.New();
            XIO.unchecked.listEntries((Path)dirPath, p -> files.add((Object)XIO.getFileName((Path)p)), p -> Files.isDirectory(p, new LinkOption[0]));
            return files;
        }

        protected XGettingEnum<String> specificListFiles(ADirectory parent) {
            Path dirPath = this.toSubjectDirectory(parent);
            EqHashEnum files = EqHashEnum.New();
            XIO.unchecked.listEntries((Path)dirPath, p -> files.add((Object)XIO.getFileName((Path)p)), p -> !Files.isDirectory(p, new LinkOption[0]));
            return files;
        }

        protected void specificInventorize(ADirectory directory) {
            Path dirPath = this.toSubjectDirectory(directory);
            if (!XIO.unchecked.exists((Path)dirPath)) {
                return;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
                for (Path p : stream) {
                    String identifier = XIO.getFileName((Path)p);
                    if (XIO.isDirectory((Path)p)) {
                        directory.ensureDirectory(identifier);
                        continue;
                    }
                    directory.ensureFile(identifier);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected boolean specificIsEmpty(ADirectory directory) {
            return XIO.unchecked.hasNoFiles((Path)this.toSubjectDirectory(directory));
        }

        protected boolean specificOpenReading(NioReadableFile file) {
            return file.openChannel();
        }

        protected boolean specificIsOpen(NioReadableFile file) {
            return file.isChannelOpen();
        }

        protected boolean specificClose(NioReadableFile file) {
            return file.closeChannel();
        }

        protected boolean specificOpenWriting(NioWritableFile file) {
            return file.openChannel();
        }

        protected void specificCreate(ADirectory directory) {
            Path dir = this.toPath((AItem)directory);
            XIO.unchecked.ensureDirectory((Path)dir);
        }

        protected void specificCreate(NioWritableFile file) {
            try {
                Files.createFile(file.path(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected void specificTruncateFile(NioWritableFile targetFile, long newSize) {
            this.openWriting(targetFile);
            try {
                XIO.truncate((FileChannel)targetFile.fileChannel(), (long)newSize);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected boolean specificDeleteFile(NioWritableFile file) {
            try {
                return XIO.delete((Path)file.path());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected ByteBuffer specificReadBytes(NioReadableFile sourceFile) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected ByteBuffer specificReadBytes(NioReadableFile sourceFile, long position) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel(), (long)position);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected ByteBuffer specificReadBytes(NioReadableFile sourceFile, long position, long length) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel(), (long)position, (long)length);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificReadBytes(NioReadableFile sourceFile, ByteBuffer targetBuffer) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel(), (ByteBuffer)targetBuffer);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificReadBytes(NioReadableFile sourceFile, ByteBuffer targetBuffer, long position) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel(), (ByteBuffer)targetBuffer, (long)position);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificReadBytes(NioReadableFile sourceFile, ByteBuffer targetBuffer, long position, long length) {
            try {
                return XIO.read((FileChannel)sourceFile.ensureOpenChannel(), (ByteBuffer)targetBuffer, (long)position, (long)length);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(NioReadableFile sourceFile, BufferProvider bufferProvider) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer());
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(NioReadableFile sourceFile, BufferProvider bufferProvider, long position) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer(), position);
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(NioReadableFile sourceFile, BufferProvider bufferProvider, long position, long length) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer(length), position, length);
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        protected long specificCopyTo(NioReadableFile sourceSubject, AWritableFile target) {
            NioWritableFile handlableTarget = this.castWritableFile(target);
            try {
                return XIO.copyFile((FileChannel)sourceSubject.ensureOpenChannel(), (FileChannel)handlableTarget.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificCopyTo(NioReadableFile sourceSubject, long sourcePosition, AWritableFile target) {
            NioWritableFile handlableTarget = this.castWritableFile(target);
            try {
                return XIO.copyFile((FileChannel)sourceSubject.ensureOpenChannel(), (long)sourcePosition, (FileChannel)handlableTarget.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificCopyTo(NioReadableFile sourceSubject, long sourcePosition, long length, AWritableFile target) {
            NioWritableFile handlableTarget = this.castWritableFile(target);
            try {
                return XIO.copyFile((FileChannel)sourceSubject.ensureOpenChannel(), (long)sourcePosition, (long)length, (FileChannel)handlableTarget.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificCopyFrom(AReadableFile source, NioWritableFile targetSubject) {
            NioReadableFile handlableSource = this.castReadableFile(source);
            try {
                return XIO.copyFile((FileChannel)handlableSource.ensureOpenChannel(), (FileChannel)targetSubject.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificCopyFrom(AReadableFile source, long sourcePosition, NioWritableFile targetSubject) {
            NioReadableFile handlableSource = this.castReadableFile(source);
            try {
                return XIO.copyFile((FileChannel)handlableSource.ensureOpenChannel(), (long)sourcePosition, (FileChannel)targetSubject.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificCopyFrom(AReadableFile source, long sourcePosition, long length, NioWritableFile targetSubject) {
            NioReadableFile handlableSource = this.castReadableFile(source);
            try {
                return XIO.copyFile((FileChannel)handlableSource.ensureOpenChannel(), (long)sourcePosition, (long)length, (FileChannel)targetSubject.ensureOpenChannel());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected long specificWriteBytes(NioWritableFile targetFile, Iterable<? extends ByteBuffer> sourceBuffers) {
            this.openWriting(targetFile);
            try {
                return XIO.write((FileChannel)targetFile.fileChannel(), sourceBuffers);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected void specificMoveFile(NioWritableFile sourceFile, AWritableFile targetFile) {
            if (this.isHandledFile((AFile)targetFile)) {
                NioWritableFile handlableTarget = this.castWritableFile(targetFile);
                this.specificTargetMoveFile(sourceFile, handlableTarget);
                return;
            }
            this.specificCopyTo(sourceFile, targetFile);
            this.specificDeleteFile(sourceFile);
        }

        protected void specificTargetMoveFile(NioWritableFile sourceFile, NioWritableFile targetFile) {
            try {
                XIO.move((Path)sourceFile.path(), (Path)targetFile.path());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }
}

