/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.LongFunction;
import one.microstream.X;
import one.microstream.afs.sql.types.SqlPath;
import one.microstream.afs.sql.types.SqlPathVisitor;
import one.microstream.afs.sql.types.SqlProvider;
import one.microstream.chars.XChars;
import one.microstream.io.ByteBufferInputStream;
import one.microstream.io.LimitedInputStream;
import one.microstream.reference.Reference;
import one.microstream.typing.KeyValue;

public interface SqlConnector {
    public long fileSize(SqlPath var1);

    public boolean fileExists(SqlPath var1);

    public boolean directoryExists(SqlPath var1);

    public void visitDirectories(SqlPath var1, SqlPathVisitor var2);

    public void visitFiles(SqlPath var1, SqlPathVisitor var2);

    public boolean createDirectory(SqlPath var1);

    public boolean deleteFile(SqlPath var1);

    public ByteBuffer readData(SqlPath var1, long var2, long var4);

    public long readData(SqlPath var1, ByteBuffer var2, long var3, long var5);

    public long writeData(SqlPath var1, Iterable<? extends ByteBuffer> var2);

    public void moveFile(SqlPath var1, SqlPath var2);

    public long copyFile(SqlPath var1, SqlPath var2, long var3, long var5);

    public void truncateFile(SqlPath var1, long var2);

    public boolean isEmpty(SqlPath var1);

    public static SqlConnector New(SqlProvider provider) {
        return new Default((SqlProvider)X.notNull((Object)provider), false);
    }

    public static SqlConnector Caching(SqlProvider provider) {
        return new Default((SqlProvider)X.notNull((Object)provider), true);
    }

    public static class Default
    implements SqlConnector {
        public static final int IDENTIFIER_COLUMN_INDEX = 1;
        public static final int START_COLUMN_INDEX = 2;
        public static final int END_COLUMN_INDEX = 3;
        public static final int DATA_COLUMN_INDEX = 4;
        private final SqlProvider provider;
        private Long maxBlobSize;
        private final boolean useCache;
        private Set<String> directoryCache;
        private final Map<String, Boolean> fileExistsCache = new HashMap<String, Boolean>();
        private final Map<String, Long> fileSizeCache = new HashMap<String, Long>();

        Default(SqlProvider provider, boolean useCache) {
            this.provider = provider;
            this.useCache = useCache;
        }

        private boolean queryFileExists(SqlPath file, Connection connection) throws SQLException {
            String sql = this.provider.fileExistsQuery(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                boolean bl;
                block12: {
                    statement.setString(1, file.identifier());
                    ResultSet result = statement.executeQuery();
                    try {
                        boolean bl2 = result.next() ? result.getLong(1) > 0L : (bl = false);
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return bl;
            }
        }

        private boolean queryDirectoryExists(SqlPath directory, Connection connection) throws SQLException {
            return this.provider.queryDirectoryExists(connection, directory.fullQualifiedName());
        }

        private Set<String> queryDirectories(Connection connection) throws SQLException {
            return this.provider.queryDirectories(connection, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalVisitDirectories(SqlPath directory, SqlPathVisitor visitor, Connection connection) throws SQLException {
            String directoryPrefix = directory.fullQualifiedName() + SqlPath.getSeparatorString();
            ArrayList<String> directories = new ArrayList<String>();
            if (this.useCache) {
                Default default_ = this;
                synchronized (default_) {
                    if (this.directoryCache == null) {
                        this.directoryCache = this.queryDirectories(connection);
                    }
                    directories.addAll(this.directoryCache);
                }
            } else {
                directories.addAll(this.provider.queryDirectories(connection, directoryPrefix + "%"));
            }
            directories.stream().filter(name -> name.startsWith(directoryPrefix) && name.length() > directoryPrefix.length()).map(name -> name.replace(directoryPrefix, "")).map(name -> XChars.splitSimple((String)name, (String)SqlPath.getSeparatorString())[0]).forEach(visitor::visitItem);
        }

        private void internalVisitFiles(SqlPath directory, SqlPathVisitor visitor, Connection connection) throws SQLException {
            ArrayList<String> fileNames = new ArrayList<String>();
            String sql = this.provider.listFilesQuery(directory.fullQualifiedName());
            try (Statement statement = connection.createStatement();
                 ResultSet result = statement.executeQuery(sql);){
                while (result.next()) {
                    fileNames.add(result.getString(1));
                }
            }
            fileNames.forEach(visitor::visitItem);
        }

        private boolean internalIsEmpty(SqlPath directory, Connection connection) throws SQLException {
            String sql = this.provider.countFilesQuery(directory.fullQualifiedName());
            try (Statement statement = connection.createStatement();
                 ResultSet result = statement.executeQuery(sql);){
                if (result.next()) {
                    boolean bl = result.getInt(1) <= 0;
                    return bl;
                }
            }
            return false;
        }

        private void queryCreateDirectory(SqlPath directory, Connection connection) throws SQLException {
            for (String sql : this.provider.createDirectoryQueries(directory.fullQualifiedName())) {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(sql);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long internalFileSize(SqlPath file, Connection connection) throws SQLException {
            if (!this.useCache) {
                return this.queryFileSize(file, connection);
            }
            Default default_ = this;
            synchronized (default_) {
                return this.fileSizeCache.computeIfAbsent(file.fullQualifiedName(), name -> {
                    try {
                        return this.queryFileSize(file, connection);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        private Long queryFileSize(SqlPath file, Connection connection) throws SQLException {
            String sql = this.provider.fileSizeQuery(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                Long l;
                block12: {
                    statement.setString(1, file.identifier());
                    ResultSet result = statement.executeQuery();
                    try {
                        result.next();
                        long count = result.getLong(1);
                        long max = result.getLong(2);
                        l = count > 0L ? max + 1L : 0L;
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return l;
            }
        }

        private long internalReadData(SqlPath file, LongFunction<ByteBuffer> bufferProvider, long offset, long length) {
            return this.provider.execute(connection -> {
                KeyValue<ByteBuffer, Long> kv = this.internalReadData(file, bufferProvider, offset, length, connection);
                ByteBuffer targetBuffer = (ByteBuffer)kv.key();
                long amount = (Long)kv.value();
                if (targetBuffer != null) {
                    targetBuffer.position(X.checkArrayRange((long)amount));
                }
                return amount;
            });
        }

        private KeyValue<ByteBuffer, Long> internalReadData(SqlPath file, LongFunction<ByteBuffer> bufferProvider, long offset, long length, Connection connection) throws SQLException {
            if (offset == 0L && length <= 0L) {
                return this.readDataFull(file, bufferProvider, connection);
            }
            if (offset == 0L && length > 0L) {
                return this.readDataBeginning(file, bufferProvider, length, connection);
            }
            if (offset > 0L && length <= 0L) {
                return this.readDataEnd(file, bufferProvider, offset, connection);
            }
            return this.readDataSegment(file, bufferProvider, offset, length, connection);
        }

        private KeyValue<ByteBuffer, Long> readDataFull(SqlPath file, LongFunction<ByteBuffer> bufferProvider, Connection connection) throws SQLException {
            String sql = this.provider.readDataQuery(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                KeyValue keyValue;
                block14: {
                    statement.setString(1, file.identifier());
                    ResultSet result = statement.executeQuery();
                    try {
                        ByteBuffer targetBuffer = null;
                        long capacity = 0L;
                        while (result.next()) {
                            if (targetBuffer == null) {
                                capacity = result.getLong(3) + 1L;
                                targetBuffer = bufferProvider.apply(capacity);
                                targetBuffer.position(X.checkArrayRange((long)capacity));
                            }
                            long rowStart = result.getLong(2);
                            long rowEnd = result.getLong(3);
                            long blobLength = rowEnd - rowStart + 1L;
                            this.readBlob(result, 4, 0L, blobLength, targetBuffer);
                        }
                        keyValue = KeyValue.New(targetBuffer, (Object)capacity);
                        if (result == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return keyValue;
            }
        }

        private KeyValue<ByteBuffer, Long> readDataBeginning(SqlPath file, LongFunction<ByteBuffer> bufferProvider, long length, Connection connection) throws SQLException {
            String sql = this.provider.readDataQueryWithLength(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                KeyValue keyValue;
                block14: {
                    statement.setString(1, file.identifier());
                    statement.setLong(2, length);
                    ResultSet result = statement.executeQuery();
                    try {
                        ByteBuffer targetBuffer = null;
                        while (result.next()) {
                            if (targetBuffer == null) {
                                targetBuffer = bufferProvider.apply(length);
                                targetBuffer.position(X.checkArrayRange((long)length));
                            }
                            long rowStart = result.getLong(2);
                            long rowEnd = result.getLong(3);
                            long blobLength = Math.min(rowEnd + 1L, length) - rowStart;
                            this.readBlob(result, 4, 0L, blobLength, targetBuffer);
                        }
                        keyValue = KeyValue.New(targetBuffer, (Object)length);
                        if (result == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return keyValue;
            }
        }

        private KeyValue<ByteBuffer, Long> readDataEnd(SqlPath file, LongFunction<ByteBuffer> bufferProvider, long offset, Connection connection) throws SQLException {
            String sql = this.provider.readDataQueryWithOffset(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                KeyValue keyValue;
                block14: {
                    statement.setString(1, file.identifier());
                    statement.setLong(2, offset);
                    ResultSet result = statement.executeQuery();
                    try {
                        ByteBuffer targetBuffer = null;
                        long capacity = 0L;
                        while (result.next()) {
                            if (targetBuffer == null) {
                                capacity = result.getLong(3) - offset + 1L;
                                targetBuffer = bufferProvider.apply(capacity);
                                targetBuffer.position(X.checkArrayRange((long)capacity));
                            }
                            long rowStart = result.getLong(2);
                            long rowEnd = result.getLong(3);
                            long blobOffset = rowStart < offset ? offset - rowStart : 0L;
                            long blobLength = rowEnd - rowStart - blobOffset + 1L;
                            this.readBlob(result, 4, blobOffset, blobLength, targetBuffer);
                        }
                        keyValue = KeyValue.New(targetBuffer, (Object)capacity);
                        if (result == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return keyValue;
            }
        }

        private KeyValue<ByteBuffer, Long> readDataSegment(SqlPath file, LongFunction<ByteBuffer> bufferProvider, long offset, long length, Connection connection) throws SQLException {
            String sql = this.provider.readDataQueryWithRange(file.parentPath().fullQualifiedName());
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                KeyValue keyValue;
                block14: {
                    statement.setString(1, file.identifier());
                    statement.setLong(2, offset);
                    statement.setLong(3, offset + length - 1L);
                    ResultSet result = statement.executeQuery();
                    try {
                        ByteBuffer targetBuffer = null;
                        while (result.next()) {
                            if (targetBuffer == null) {
                                targetBuffer = bufferProvider.apply(length);
                                targetBuffer.position(X.checkArrayRange((long)length));
                            }
                            long rowStart = result.getLong(2);
                            long rowEnd = result.getLong(3);
                            long blobOffset = rowStart < offset ? offset - rowStart : 0L;
                            long maxEnd = offset + length - 1L;
                            long blobLength = Math.min(maxEnd, rowEnd) - rowStart - blobOffset + 1L;
                            this.readBlob(result, 4, blobOffset, blobLength, targetBuffer);
                        }
                        keyValue = KeyValue.New(targetBuffer, (Object)length);
                        if (result == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return keyValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readBlob(ResultSet result, int columnIndex, long offset, long length, ByteBuffer reverseTargetBuffer) throws SQLException {
            try {
                Blob blob = result.getBlob(columnIndex);
                try {
                    byte[] bytes = blob.getBytes(offset + 1L, X.checkArrayRange((long)length));
                    int position = reverseTargetBuffer.position() - bytes.length;
                    reverseTargetBuffer.position(position);
                    reverseTargetBuffer.put(bytes);
                    reverseTargetBuffer.position(position);
                }
                finally {
                    blob.free();
                }
            }
            catch (SQLException e) {
                byte[] bytes = result.getBytes(columnIndex);
                int amount = X.checkArrayRange((long)length);
                int position = reverseTargetBuffer.position() - amount;
                reverseTargetBuffer.position(position);
                reverseTargetBuffer.put(bytes, X.checkArrayRange((long)offset), amount);
                reverseTargetBuffer.position(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long maxBlobSize(Connection connection) throws SQLException {
            Default default_ = this;
            synchronized (default_) {
                if (this.maxBlobSize == null) {
                    DatabaseMetaData metaData = connection.getMetaData();
                    long maxLobSize = metaData.getMaxLogicalLobSize();
                    this.maxBlobSize = maxLobSize > 0L ? maxLobSize : 0x100000L;
                }
                return this.maxBlobSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long fileSize(SqlPath file) {
            if (!this.useCache) {
                return this.provider.execute(connection -> this.queryFileSize(file, connection));
            }
            Default default_ = this;
            synchronized (default_) {
                return this.fileSizeCache.computeIfAbsent(file.fullQualifiedName(), name -> this.provider.execute(connection -> this.queryFileSize(file, connection)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean fileExists(SqlPath file) {
            if (!this.directoryExists(file.parentPath())) {
                return false;
            }
            if (!this.useCache) {
                return this.provider.execute(connection -> this.queryFileExists(file, connection));
            }
            Default default_ = this;
            synchronized (default_) {
                return this.fileExistsCache.computeIfAbsent(file.fullQualifiedName(), name -> this.provider.execute(connection -> this.queryFileExists(file, connection)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean directoryExists(SqlPath directory) {
            if (!this.useCache) {
                return this.provider.execute(connection -> this.queryDirectoryExists(directory, connection));
            }
            Default default_ = this;
            synchronized (default_) {
                if (this.directoryCache == null) {
                    this.directoryCache = this.provider.execute(this::queryDirectories);
                }
                return this.directoryCache.contains(directory.fullQualifiedName());
            }
        }

        @Override
        public void visitDirectories(SqlPath directory, SqlPathVisitor visitor) {
            this.provider.execute(connection -> {
                this.internalVisitDirectories(directory, visitor, connection);
                return null;
            });
        }

        @Override
        public void visitFiles(SqlPath directory, SqlPathVisitor visitor) {
            this.provider.execute(connection -> {
                this.internalVisitFiles(directory, visitor, connection);
                return null;
            });
        }

        @Override
        public boolean isEmpty(SqlPath directory) {
            return this.provider.execute(connection -> this.internalIsEmpty(directory, connection));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean createDirectory(SqlPath directory) {
            boolean success = this.provider.execute(connection -> {
                this.queryCreateDirectory(directory, connection);
                return true;
            });
            if (this.useCache && success) {
                Default default_ = this;
                synchronized (default_) {
                    this.directoryCache.add(directory.fullQualifiedName());
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deleteFile(SqlPath file) {
            boolean success = this.provider.execute(connection -> {
                String sql = this.provider.deleteFileQuery(file.parentPath().fullQualifiedName());
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    statement.setString(1, file.identifier());
                    int affectedRows = statement.executeUpdate();
                    Boolean bl = affectedRows > 0;
                    return bl;
                }
            });
            if (this.useCache) {
                Default default_ = this;
                synchronized (default_) {
                    this.fileExistsCache.remove(file.fullQualifiedName());
                    this.fileSizeCache.remove(file.fullQualifiedName());
                }
            }
            return success;
        }

        @Override
        public ByteBuffer readData(SqlPath file, long offset, long length) {
            if (length == 0L) {
                return ByteBuffer.allocateDirect(0);
            }
            Reference bufferRef = Reference.New(null);
            LongFunction<ByteBuffer> bufferProvider = capacity -> {
                ByteBuffer buffer = ByteBuffer.allocateDirect(X.checkArrayRange((long)capacity));
                bufferRef.set((Object)buffer);
                return buffer;
            };
            this.internalReadData(file, bufferProvider, offset, length);
            ByteBuffer buffer = (ByteBuffer)bufferRef.get();
            if (buffer != null) {
                buffer.flip();
                return buffer;
            }
            return ByteBuffer.allocateDirect(0);
        }

        @Override
        public long readData(SqlPath file, ByteBuffer targetBuffer, long offset, long length) {
            if (length == 0L) {
                return 0L;
            }
            LongFunction<ByteBuffer> bufferProvider = capacity -> {
                if ((long)targetBuffer.remaining() < capacity) {
                    throw new IllegalArgumentException("Provided target buffer has not enough space remaining to load the content: " + targetBuffer.remaining() + " < " + capacity);
                }
                return targetBuffer;
            };
            return this.internalReadData(file, bufferProvider, offset, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long writeData(SqlPath file, Iterable<? extends ByteBuffer> sourceBuffers) {
            long written = this.provider.execute(connection -> {
                long currentBatchSize;
                String sql = this.provider.writeDataQuery(file.parentPath().fullQualifiedName());
                long buffersLength = 0L;
                for (ByteBuffer buffer : sourceBuffers) {
                    buffersLength += (long)buffer.remaining();
                }
                long maxBatchSize = Math.min(this.maxBlobSize(connection), buffersLength);
                ByteBufferInputStream inputStream = ByteBufferInputStream.New((Iterable)sourceBuffers);
                long fileSize = this.internalFileSize(file, connection);
                long offset = Math.max(0L, fileSize);
                for (long available = buffersLength; available > 0L; available -= currentBatchSize) {
                    currentBatchSize = Math.min(available, maxBatchSize);
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        statement.setString(1, file.identifier());
                        statement.setLong(2, offset);
                        statement.setLong(3, offset + currentBatchSize - 1L);
                        this.provider.setBlob(statement, 4, (InputStream)LimitedInputStream.New((InputStream)inputStream, (long)currentBatchSize), currentBatchSize);
                        statement.executeUpdate();
                    }
                    offset += currentBatchSize;
                }
                return buffersLength;
            });
            if (this.useCache) {
                Default default_ = this;
                synchronized (default_) {
                    this.fileExistsCache.put(file.fullQualifiedName(), Boolean.TRUE);
                    this.fileSizeCache.merge(file.fullQualifiedName(), written, Math::addExact);
                }
            }
            return written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveFile(SqlPath sourceFile, SqlPath targetFile) {
            this.provider.execute(connection -> {
                if (sourceFile.parentPath().fullQualifiedName().equals(targetFile.parentPath().fullQualifiedName())) {
                    String sql = this.provider.moveFileQuerySameParent(sourceFile.parentPath().fullQualifiedName());
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        statement.setString(1, targetFile.identifier());
                        statement.setString(2, sourceFile.identifier());
                        statement.executeUpdate();
                    }
                }
                String sql = this.provider.copyFileQuery(sourceFile.parentPath().fullQualifiedName(), targetFile.parentPath().fullQualifiedName());
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    statement.setString(1, targetFile.identifier());
                    statement.setString(2, sourceFile.identifier());
                    statement.executeUpdate();
                }
                sql = this.provider.deleteFileQuery(sourceFile.parentPath().fullQualifiedName());
                statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, sourceFile.identifier());
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                return null;
            });
            if (this.useCache) {
                Default default_ = this;
                synchronized (default_) {
                    this.fileExistsCache.put(sourceFile.fullQualifiedName(), Boolean.FALSE);
                    this.fileExistsCache.put(targetFile.fullQualifiedName(), Boolean.TRUE);
                    Long fileSize = this.fileSizeCache.remove(sourceFile.fullQualifiedName());
                    if (fileSize != null) {
                        this.fileSizeCache.put(targetFile.fullQualifiedName(), fileSize);
                    }
                }
            }
        }

        @Override
        public long copyFile(SqlPath sourceFile, SqlPath targetFile, long offset, long length) {
            ByteBuffer buffer = this.readData(sourceFile, offset, length);
            return this.writeData(targetFile, Arrays.asList(buffer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncateFile(SqlPath file, long newLength) {
            if (newLength == 0L) {
                this.deleteFile(file);
                return;
            }
            this.provider.execute(connection -> {
                long segmentEnd;
                long segmentStart;
                long currentLength = this.internalFileSize(file, connection);
                if (newLength >= currentLength) {
                    throw new IllegalArgumentException("New size must be smaller than current size: " + newLength + " >= " + currentLength);
                }
                String tableName = file.parentPath().fullQualifiedName();
                try (PreparedStatement statement = connection.prepareStatement(this.provider.readMetadataQuerySingleSegment(tableName));){
                    statement.setString(1, file.identifier());
                    statement.setLong(2, newLength);
                    statement.setLong(3, newLength);
                    try (ResultSet result = statement.executeQuery();){
                        result.next();
                        segmentStart = result.getLong(1);
                        segmentEnd = result.getLong(2);
                    }
                }
                if (segmentStart == newLength) {
                    statement = connection.prepareStatement(this.provider.deleteFileQueryFromStart(tableName));
                    try {
                        statement.setString(1, file.identifier());
                        statement.setLong(2, newLength);
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                if (segmentEnd == newLength - 1L) {
                    statement = connection.prepareStatement(this.provider.deleteFileQueryFromEnd(tableName));
                    try {
                        statement.setString(1, file.identifier());
                        statement.setLong(2, newLength);
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                long newSegmentLength = newLength - segmentStart;
                ByteBuffer buffer = ByteBuffer.allocateDirect(X.checkArrayRange((long)newSegmentLength));
                this.internalReadData(file, size -> buffer, 0L, newSegmentLength, connection);
                try (PreparedStatement statement = connection.prepareStatement(this.provider.deleteFileQueryFromStart(tableName));){
                    statement.setString(1, file.identifier());
                    statement.setLong(2, segmentStart);
                    statement.executeUpdate();
                }
                statement = connection.prepareStatement(this.provider.writeDataQuery(tableName));
                try {
                    statement.setString(1, file.identifier());
                    statement.setLong(2, segmentStart);
                    statement.setLong(3, segmentStart + newSegmentLength - 1L);
                    this.provider.setBlob(statement, 4, (InputStream)ByteBufferInputStream.New((ByteBuffer)buffer), newSegmentLength);
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                return null;
            });
            if (this.useCache) {
                Default default_ = this;
                synchronized (default_) {
                    this.fileSizeCache.put(file.fullQualifiedName(), newLength);
                }
            }
        }
    }
}

