/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import one.microstream.X;
import one.microstream.afs.sql.types.SqlConnector;
import one.microstream.afs.sql.types.SqlIoHandler;
import one.microstream.afs.sql.types.SqlPath;
import one.microstream.afs.sql.types.SqlProvider;
import one.microstream.afs.sql.types.SqlReadableFile;
import one.microstream.afs.sql.types.SqlWritableFile;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.afs.types.AIoHandler;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AResolver;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.io.XIO;

public interface SqlFileSystem
extends AFileSystem,
AResolver<SqlPath, SqlPath> {
    public static SqlPath toPath(AItem item) {
        return SqlFileSystem.toPath(item.toPath());
    }

    public static SqlPath toPath(String ... pathElements) {
        return SqlPath.New((String[])X.notNull((Object)pathElements));
    }

    public static SqlFileSystem New(SqlProvider provider) {
        return SqlFileSystem.New(SqlConnector.New(provider));
    }

    public static SqlFileSystem New(SqlConnector connector) {
        return SqlFileSystem.New(SqlIoHandler.New(connector));
    }

    public static SqlFileSystem New(SqlIoHandler ioHandler) {
        return new Default((SqlIoHandler)X.notNull((Object)ioHandler));
    }

    public static class Default
    extends AFileSystem.Abstract<SqlIoHandler, SqlPath, SqlPath>
    implements SqlFileSystem {
        protected Default(SqlIoHandler ioHandler) {
            super("jdbc:", (AIoHandler)ioHandler);
        }

        public String deriveFileIdentifier(String fileName, String fileType) {
            return XIO.addFileSuffix((String)fileName, (String)fileType);
        }

        public String deriveFileName(String fileIdentifier) {
            return XIO.getFilePrefix((String)fileIdentifier);
        }

        public String deriveFileType(String fileIdentifier) {
            return XIO.getFileSuffix((String)fileIdentifier);
        }

        public String getFileName(AFile file) {
            return XIO.getFilePrefix((String)file.identifier());
        }

        public String getFileType(AFile file) {
            return XIO.getFileSuffix((String)file.identifier());
        }

        public String[] resolveDirectoryToPath(SqlPath directory) {
            return directory.pathElements();
        }

        public String[] resolveFileToPath(SqlPath file) {
            return file.pathElements();
        }

        public SqlPath resolve(ADirectory directory) {
            return SqlFileSystem.toPath((AItem)directory);
        }

        public SqlPath resolve(AFile file) {
            return SqlFileSystem.toPath((AItem)file);
        }

        protected VarString assembleItemPath(AItem item, VarString vs) {
            return XChars.assembleSeparated((VarString)vs, (char)SqlPath.getSeparatorChar(), (CharSequence[])item.toPath());
        }

        public AReadableFile wrapForReading(AFile file, Object user) {
            SqlPath path = this.resolve(file);
            return SqlReadableFile.New(file, user, path);
        }

        public AWritableFile wrapForWriting(AFile file, Object user) {
            SqlPath path = this.resolve(file);
            return SqlWritableFile.New(file, user, path);
        }

        public AReadableFile convertToReading(AWritableFile file) {
            return SqlReadableFile.New((AFile)file, file.user(), ((SqlWritableFile)file).path());
        }

        public AWritableFile convertToWriting(AReadableFile file) {
            return SqlWritableFile.New((AFile)file, file.user(), ((SqlReadableFile)file).path());
        }
    }
}

