/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.lang.reflect.InvocationTargetException;
import javax.sql.DataSource;
import one.microstream.afs.sql.types.SqlConnector;
import one.microstream.afs.sql.types.SqlDataSourceProvider;
import one.microstream.afs.sql.types.SqlFileSystem;
import one.microstream.afs.sql.types.SqlProvider;
import one.microstream.afs.types.AFileSystem;
import one.microstream.chars.XChars;
import one.microstream.configuration.exceptions.ConfigurationException;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationBasedCreator;

public abstract class SqlFileSystemCreator
extends ConfigurationBasedCreator.Abstract<AFileSystem> {
    private final String name;

    protected SqlFileSystemCreator(String name) {
        super(AFileSystem.class);
        this.name = (String)XChars.notEmpty((CharSequence)name);
    }

    public AFileSystem create(Configuration configuration) {
        String configurationKey = "sql." + this.name;
        Configuration sqlConfiguration = configuration.child(configurationKey);
        if (sqlConfiguration == null) {
            return null;
        }
        String dataSourceProviderClassName = sqlConfiguration.get("data-source-provider");
        if (dataSourceProviderClassName == null) {
            throw new ConfigurationException(sqlConfiguration, configurationKey + ".data-source-provider must be set");
        }
        try {
            SqlDataSourceProvider dataSourceProvider = (SqlDataSourceProvider)Class.forName(dataSourceProviderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SqlProvider sqlProvider = this.createSqlProvider(sqlConfiguration, dataSourceProvider.provideDataSource(sqlConfiguration.detach()));
            boolean cache = configuration.optBoolean("cache").orElse(true);
            return SqlFileSystem.New(cache ? SqlConnector.Caching(sqlProvider) : SqlConnector.New(sqlProvider));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ConfigurationException(sqlConfiguration, (Throwable)e);
        }
    }

    protected abstract SqlProvider createSqlProvider(Configuration var1, DataSource var2);
}

