/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import one.microstream.X;
import one.microstream.afs.exceptions.AfsExceptionRetiredFile;
import one.microstream.afs.sql.types.SqlItemWrapper;
import one.microstream.afs.sql.types.SqlPath;
import one.microstream.afs.types.AFile;
import one.microstream.chars.XChars;

public interface SqlFileWrapper
extends AFile.Wrapper,
SqlItemWrapper {
    public boolean retire();

    public boolean isRetired();

    public boolean isHandleOpen();

    public boolean checkHandleOpen();

    public boolean openHandle();

    public boolean closeHandle();

    public SqlFileWrapper ensureOpenHandle();

    public static abstract class Abstract<U>
    extends AFile.Wrapper.Abstract<U>
    implements SqlFileWrapper {
        private SqlPath path;
        private boolean handleOpen = false;

        protected Abstract(AFile actual, U user, SqlPath path) {
            super(actual, user);
            this.path = (SqlPath)X.notNull((Object)path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqlPath path() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                return this.path;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retire() {
            Object object = this.mutex();
            synchronized (object) {
                if (this.path == null) {
                    return false;
                }
                this.path = null;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRetired() {
            Object object = this.mutex();
            synchronized (object) {
                return this.path == null;
            }
        }

        public void validateIsNotRetired() {
            if (!this.isRetired()) {
                return;
            }
            throw new AfsExceptionRetiredFile("File is retired: " + XChars.systemString((Object)this) + "(\"" + this.toPathString() + "\".");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHandleOpen() {
            Object object = this.mutex();
            synchronized (object) {
                return this.handleOpen;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkHandleOpen() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                return this.isHandleOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean openHandle() {
            Object object = this.mutex();
            synchronized (object) {
                if (this.checkHandleOpen()) {
                    return false;
                }
                this.handleOpen = true;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean closeHandle() {
            Object object = this.mutex();
            synchronized (object) {
                if (!this.isHandleOpen()) {
                    return false;
                }
                this.handleOpen = false;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqlFileWrapper ensureOpenHandle() {
            Object object = this.mutex();
            synchronized (object) {
                this.validateIsNotRetired();
                this.openHandle();
                return this;
            }
        }
    }
}

