/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.afs.sql.types.SqlConnector;
import one.microstream.afs.sql.types.SqlFileSystem;
import one.microstream.afs.sql.types.SqlFileWrapper;
import one.microstream.afs.sql.types.SqlItemWrapper;
import one.microstream.afs.sql.types.SqlPath;
import one.microstream.afs.sql.types.SqlReadableFile;
import one.microstream.afs.sql.types.SqlWritableFile;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AIoHandler;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.afs.types.WriteController;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.io.BufferProvider;

public interface SqlIoHandler
extends AIoHandler {
    public SqlConnector connector();

    public static SqlIoHandler New(SqlConnector connector) {
        return SqlIoHandler.New(WriteController.Enabled(), connector);
    }

    public static SqlIoHandler New(WriteController writeController, SqlConnector connector) {
        return new Default((WriteController)X.notNull((Object)writeController), (SqlConnector)X.notNull((Object)connector));
    }

    public static final class Default
    extends AIoHandler.Abstract<SqlPath, SqlPath, SqlItemWrapper, SqlFileWrapper, ADirectory, SqlReadableFile, SqlWritableFile>
    implements SqlIoHandler {
        private final SqlConnector connector;

        Default(WriteController writeController, SqlConnector sqlConnector) {
            super(writeController, SqlItemWrapper.class, SqlFileWrapper.class, ADirectory.class, SqlReadableFile.class, SqlWritableFile.class);
            this.connector = sqlConnector;
        }

        @Override
        public SqlConnector connector() {
            return this.connector;
        }

        protected SqlPath toSubjectFile(AFile file) {
            return SqlFileSystem.toPath((AItem)file);
        }

        protected SqlPath toSubjectDirectory(ADirectory directory) {
            return SqlFileSystem.toPath((AItem)directory);
        }

        protected long subjectFileSize(SqlPath file) {
            return this.connector.fileSize(file);
        }

        protected boolean subjectFileExists(SqlPath file) {
            return this.connector.fileExists(file);
        }

        protected boolean subjectDirectoryExists(SqlPath directory) {
            return this.connector.directoryExists(directory);
        }

        protected long specificSize(SqlFileWrapper file) {
            return this.subjectFileSize(file.path());
        }

        protected boolean specificExists(SqlFileWrapper file) {
            return this.subjectFileExists(file.path());
        }

        protected boolean specificExists(ADirectory directory) {
            return this.subjectDirectoryExists(this.toSubjectDirectory(directory));
        }

        protected XGettingEnum<String> specificListItems(ADirectory parent) {
            EqHashEnum items = EqHashEnum.New();
            SqlPath directoryPath = this.toSubjectDirectory(parent);
            this.connector.visitDirectories(directoryPath, arg_0 -> ((EqHashEnum)items).add(arg_0));
            this.connector.visitFiles(directoryPath, arg_0 -> ((EqHashEnum)items).add(arg_0));
            return items;
        }

        protected XGettingEnum<String> specificListDirectories(ADirectory parent) {
            EqHashEnum directories = EqHashEnum.New();
            this.connector.visitDirectories(this.toSubjectDirectory(parent), arg_0 -> ((EqHashEnum)directories).add(arg_0));
            return directories;
        }

        protected XGettingEnum<String> specificListFiles(ADirectory parent) {
            EqHashEnum files = EqHashEnum.New();
            this.connector.visitFiles(this.toSubjectDirectory(parent), arg_0 -> ((EqHashEnum)files).add(arg_0));
            return files;
        }

        protected void specificInventorize(ADirectory directory) {
            SqlPath dirPath = this.toSubjectDirectory(directory);
            if (!this.subjectDirectoryExists(dirPath)) {
                return;
            }
            this.connector.visitDirectories(dirPath, arg_0 -> ((ADirectory)directory).ensureDirectory(arg_0));
            this.connector.visitFiles(dirPath, arg_0 -> ((ADirectory)directory).ensureFile(arg_0));
        }

        protected boolean specificIsEmpty(ADirectory directory) {
            return this.connector.isEmpty(this.toSubjectDirectory(directory));
        }

        protected boolean specificOpenReading(SqlReadableFile file) {
            return file.openHandle();
        }

        protected boolean specificIsOpen(SqlReadableFile file) {
            return file.isHandleOpen();
        }

        protected boolean specificClose(SqlReadableFile file) {
            return file.closeHandle();
        }

        protected boolean specificOpenWriting(SqlWritableFile file) {
            return file.openHandle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void create(ADirectory directory) {
            this.validateHandledDirectory(directory);
            Default default_ = this;
            synchronized (default_) {
                directory.iterateObservers(o -> o.onBeforeDirectoryCreate(directory));
                this.specificCreate(directory);
                directory.iterateObservers(o -> o.onAfterDirectoryCreate(directory));
            }
        }

        protected void specificCreate(ADirectory directory) {
            this.connector.createDirectory(this.toSubjectDirectory(directory));
        }

        protected void specificCreate(SqlWritableFile file) {
        }

        protected boolean specificDeleteFile(SqlWritableFile file) {
            return this.connector.deleteFile(SqlFileSystem.toPath(file));
        }

        protected ByteBuffer specificReadBytes(SqlReadableFile sourceFile) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), 0L, -1L);
        }

        protected ByteBuffer specificReadBytes(SqlReadableFile sourceFile, long position) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), position, -1L);
        }

        protected ByteBuffer specificReadBytes(SqlReadableFile sourceFile, long position, long length) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), position, length);
        }

        protected long specificReadBytes(SqlReadableFile sourceFile, ByteBuffer targetBuffer) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), targetBuffer, 0L, -1L);
        }

        protected long specificReadBytes(SqlReadableFile sourceFile, ByteBuffer targetBuffer, long position) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), targetBuffer, position, targetBuffer.remaining());
        }

        protected long specificReadBytes(SqlReadableFile sourceFile, ByteBuffer targetBuffer, long position, long length) {
            return this.connector.readData(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), targetBuffer, position, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(SqlReadableFile sourceFile, BufferProvider bufferProvider) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer());
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(SqlReadableFile sourceFile, BufferProvider bufferProvider, long position) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer(), position);
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long specificReadBytes(SqlReadableFile sourceFile, BufferProvider bufferProvider, long position, long length) {
            bufferProvider.initializeOperation();
            try {
                long l = this.specificReadBytes(sourceFile, bufferProvider.provideBuffer(length), position, length);
                return l;
            }
            finally {
                bufferProvider.completeOperation();
            }
        }

        protected long specificWriteBytes(SqlWritableFile targetFile, Iterable<? extends ByteBuffer> sourceBuffers) {
            return this.connector.writeData(SqlFileSystem.toPath(targetFile.ensureOpenHandle()), sourceBuffers);
        }

        protected void specificMoveFile(SqlWritableFile sourceFile, AWritableFile targetFile) {
            SqlWritableFile handlableTarget = (SqlWritableFile)this.castWritableFile(targetFile);
            this.connector.moveFile(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), SqlFileSystem.toPath(handlableTarget.ensureOpenHandle()));
        }

        protected long specificCopyTo(SqlReadableFile sourceFile, AWritableFile targetFile) {
            SqlWritableFile handlableTarget = (SqlWritableFile)this.castWritableFile(targetFile);
            return this.connector.copyFile(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), SqlFileSystem.toPath(handlableTarget.ensureOpenHandle()), 0L, -1L);
        }

        protected long specificCopyTo(SqlReadableFile sourceFile, long sourcePosition, AWritableFile targetFile) {
            SqlWritableFile handlableTarget = (SqlWritableFile)this.castWritableFile(targetFile);
            return this.connector.copyFile(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), SqlFileSystem.toPath(handlableTarget.ensureOpenHandle()), sourcePosition, -1L);
        }

        protected long specificCopyTo(SqlReadableFile sourceFile, long sourcePosition, long length, AWritableFile targetFile) {
            SqlWritableFile handlableTarget = (SqlWritableFile)this.castWritableFile(targetFile);
            return this.connector.copyFile(SqlFileSystem.toPath(sourceFile.ensureOpenHandle()), SqlFileSystem.toPath(handlableTarget.ensureOpenHandle()), sourcePosition, length);
        }

        protected long specificCopyFrom(AReadableFile source, SqlWritableFile targetSubject) {
            SqlReadableFile handlableSource = (SqlReadableFile)this.castReadableFile(source);
            return this.connector.copyFile(SqlFileSystem.toPath(handlableSource.ensureOpenHandle()), SqlFileSystem.toPath(targetSubject.ensureOpenHandle()), 0L, -1L);
        }

        protected long specificCopyFrom(AReadableFile source, long sourcePosition, SqlWritableFile targetSubject) {
            SqlReadableFile handlableSource = (SqlReadableFile)this.castReadableFile(source);
            return this.connector.copyFile(SqlFileSystem.toPath(handlableSource.ensureOpenHandle()), SqlFileSystem.toPath(targetSubject.ensureOpenHandle()), sourcePosition, -1L);
        }

        protected long specificCopyFrom(AReadableFile source, long sourcePosition, long length, SqlWritableFile targetSubject) {
            SqlReadableFile handlableSource = (SqlReadableFile)this.castReadableFile(source);
            return this.connector.copyFile(SqlFileSystem.toPath(handlableSource.ensureOpenHandle()), SqlFileSystem.toPath(targetSubject.ensureOpenHandle()), sourcePosition, length);
        }

        protected void specificTruncateFile(SqlWritableFile file, long newSize) {
            this.connector.truncateFile(file.path(), newSize);
        }
    }
}

