/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.util.Arrays;
import java.util.stream.Collectors;
import one.microstream.X;
import one.microstream.afs.sql.types.SqlPathSeparatorProvider;
import one.microstream.chars.XChars;
import one.microstream.collections.XArrays;

public interface SqlPath {
    public String[] pathElements();

    public String identifier();

    public String fullQualifiedName();

    public SqlPath parentPath();

    public static String[] splitPath(String fullQualifiedPath) {
        return XChars.splitSimple((String)fullQualifiedPath, (String)SqlPath.getSeparatorString());
    }

    public static SqlPath New(String ... pathElements) {
        return new Default((String[])X.notNull((Object)pathElements));
    }

    public static SqlPathSeparatorProvider set(SqlPathSeparatorProvider sqlPathSeparatorProvider) {
        return Static.set(sqlPathSeparatorProvider);
    }

    public static SqlPathSeparatorProvider get() {
        return Static.get();
    }

    public static String getSeparatorString() {
        return Static.get().getSqlPathSeparator();
    }

    public static char getSeparatorChar() {
        return Static.get().getSqlPathSeparatorChar();
    }

    public static final class Default
    implements SqlPath {
        private final String[] pathElements;
        private String fullQualifiedName;

        Default(String[] pathElements) {
            this.pathElements = pathElements;
        }

        @Override
        public String[] pathElements() {
            return this.pathElements;
        }

        @Override
        public String identifier() {
            return this.pathElements[this.pathElements.length - 1];
        }

        @Override
        public String fullQualifiedName() {
            if (this.fullQualifiedName == null) {
                this.fullQualifiedName = Arrays.stream(this.pathElements).collect(Collectors.joining(SqlPath.getSeparatorString()));
            }
            return this.fullQualifiedName;
        }

        @Override
        public SqlPath parentPath() {
            return this.pathElements.length > 1 ? new Default((String[])XArrays.copyRange((Object[])this.pathElements, (int)0, (int)(this.pathElements.length - 1))) : null;
        }
    }

    public static final class Static {
        static SqlPathSeparatorProvider pathSeparatorProvider = SqlPathSeparatorProvider.New();

        static synchronized SqlPathSeparatorProvider set(SqlPathSeparatorProvider sqlPathSeparatorProvider) {
            pathSeparatorProvider = sqlPathSeparatorProvider;
            return pathSeparatorProvider;
        }

        static synchronized SqlPathSeparatorProvider get() {
            return pathSeparatorProvider;
        }
    }
}

