/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import one.microstream.X;
import one.microstream.afs.exceptions.AfsException;
import one.microstream.afs.sql.types.SqlOperation;
import one.microstream.chars.VarString;
import one.microstream.exceptions.IORuntimeException;

public interface SqlProvider {
    public static final String IDENTIFIER_COLUMN_NAME = "identifier";
    public static final int IDENTIFIER_COLUMN_TYPE = 12;
    public static final int IDENTIFIER_COLUMN_LENGTH = 255;
    public static final String START_COLUMN_NAME = "start";
    public static final int START_COLUMN_TYPE = -5;
    public static final String END_COLUMN_NAME = "end";
    public static final int END_COLUMN_TYPE = -5;
    public static final String DATA_COLUMN_NAME = "data";
    public static final int DATA_COLUMN_TYPE = 2004;

    public String catalog();

    public String schema();

    public <T> T execute(SqlOperation<T> var1);

    public void setBlob(PreparedStatement var1, int var2, InputStream var3, long var4) throws SQLException;

    public boolean queryDirectoryExists(Connection var1, String var2) throws SQLException;

    public Set<String> queryDirectories(Connection var1, String var2) throws SQLException;

    public String fileSizeQuery(String var1);

    public String listFilesQuery(String var1);

    public String countFilesQuery(String var1);

    public String readMetadataQuery(String var1);

    public String readMetadataQuerySingleSegment(String var1);

    public String readDataQuery(String var1);

    public String readDataQueryWithLength(String var1);

    public String readDataQueryWithOffset(String var1);

    public String readDataQueryWithRange(String var1);

    public String fileExistsQuery(String var1);

    public Iterable<String> createDirectoryQueries(String var1);

    public String deleteFileQuery(String var1);

    public String deleteFileQueryFromStart(String var1);

    public String deleteFileQueryFromEnd(String var1);

    public String writeDataQuery(String var1);

    public String moveFileQuerySameParent(String var1);

    public String copyFileQuery(String var1, String var2);

    public static abstract class Abstract
    implements SqlProvider {
        private final String catalog;
        private final String schema;
        private final DataSource dataSource;

        protected Abstract(String catalog, String schema, DataSource dataSource) {
            this.catalog = (String)X.mayNull((Object)catalog);
            this.schema = (String)X.mayNull((Object)schema);
            this.dataSource = (DataSource)X.notNull((Object)dataSource);
        }

        protected char quoteOpen() {
            return '\"';
        }

        protected char quoteClose() {
            return '\"';
        }

        protected VarString addSqlTableName(VarString vs, String tableName) {
            return this.addNameQuoted(vs, tableName);
        }

        protected VarString addSqlColumnName(VarString vs, String columnName) {
            return this.addNameQuoted(vs, columnName);
        }

        protected VarString addNameQuoted(VarString vs, String name) {
            return vs.add(this.quoteOpen()).add(name).add(this.quoteClose());
        }

        protected String internalReadDataQuery(String tableName, VarString ... conditions) {
            VarString vs = VarString.New();
            vs.add("select * from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            for (VarString condition : conditions) {
                vs.add(" and ").add(condition);
            }
            vs.add(" order by ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(" desc");
            return vs.toString();
        }

        @Override
        public String catalog() {
            return this.catalog;
        }

        @Override
        public String schema() {
            return this.schema;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T execute(SqlOperation<T> operation) {
            try (Connection connection = this.dataSource.getConnection();){
                T t;
                connection.setAutoCommit(false);
                try {
                    T result = operation.execute(connection);
                    connection.commit();
                    t = result;
                }
                catch (SQLException e) {
                    connection.rollback();
                    throw e;
                }
                return t;
            }
            catch (SQLException e) {
                throw new AfsException((Throwable)e);
            }
        }

        @Override
        public void setBlob(PreparedStatement statement, int index, InputStream inputStream, long length) throws SQLException {
            try {
                statement.setBinaryStream(index, inputStream, length);
            }
            catch (SQLFeatureNotSupportedException featureNotSupported) {
                try {
                    byte[] bytes = new byte[X.checkArrayRange((long)length)];
                    for (int offset = 0; offset < bytes.length - 1; offset += inputStream.read(bytes, offset, bytes.length - offset)) {
                    }
                    statement.setBytes(index, bytes);
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        }

        @Override
        public boolean queryDirectoryExists(Connection connection, String tableName) throws SQLException {
            try (ResultSet result = connection.getMetaData().getTables(this.catalog(), this.schema(), tableName, new String[]{"TABLE"});){
                boolean bl = result.next();
                return bl;
            }
        }

        @Override
        public Set<String> queryDirectories(Connection connection, String prefix) throws SQLException {
            HashSet<String> directories = new HashSet<String>();
            try (ResultSet result = connection.getMetaData().getTables(this.catalog(), this.schema(), prefix, new String[]{"TABLE"});){
                while (result.next()) {
                    directories.add(result.getString("TABLE_NAME"));
                }
            }
            return directories;
        }

        @Override
        public String fileSizeQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("select count(*), max(");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(") from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }

        @Override
        public String listFilesQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("select distinct ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add(" from ");
            this.addSqlTableName(vs, tableName);
            return vs.toString();
        }

        @Override
        public String countFilesQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("select count(*) from ");
            this.addSqlTableName(vs, tableName);
            return vs.toString();
        }

        @Override
        public String readMetadataQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("select ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(" from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }

        @Override
        public String readMetadataQuerySingleSegment(String tableName) {
            VarString vs = VarString.New();
            vs.add("select ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(" from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=? and ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add("<=? and ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(">=?");
            return vs.toString();
        }

        @Override
        public String readDataQuery(String tableName) {
            return this.internalReadDataQuery(tableName, new VarString[0]);
        }

        @Override
        public String readDataQueryWithLength(String tableName) {
            return this.internalReadDataQuery(tableName, this.addSqlColumnName(VarString.New(), SqlProvider.START_COLUMN_NAME).add("<?"));
        }

        @Override
        public String readDataQueryWithOffset(String tableName) {
            return this.internalReadDataQuery(tableName, this.addSqlColumnName(VarString.New(), SqlProvider.END_COLUMN_NAME).add(">=?"));
        }

        @Override
        public String readDataQueryWithRange(String tableName) {
            return this.internalReadDataQuery(tableName, this.addSqlColumnName(VarString.New(), SqlProvider.END_COLUMN_NAME).add(">=?"), this.addSqlColumnName(VarString.New(), SqlProvider.START_COLUMN_NAME).add("<=?"));
        }

        @Override
        public String fileExistsQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("select count(*) from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }

        @Override
        public String deleteFileQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("delete from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }

        @Override
        public String deleteFileQueryFromStart(String tableName) {
            VarString vs = VarString.New();
            vs.add("delete from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=? and ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(">=?");
            return vs.toString();
        }

        @Override
        public String deleteFileQueryFromEnd(String tableName) {
            VarString vs = VarString.New();
            vs.add("delete from ");
            this.addSqlTableName(vs, tableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=? and ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(">=?");
            return vs.toString();
        }

        @Override
        public String writeDataQuery(String tableName) {
            VarString vs = VarString.New();
            vs.add("insert into ");
            this.addSqlTableName(vs, tableName);
            vs.add(" (");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.DATA_COLUMN_NAME);
            vs.add(") values (?, ?, ?, ?)");
            return vs.toString();
        }

        @Override
        public String moveFileQuerySameParent(String tableName) {
            VarString vs = VarString.New();
            vs.add("update ");
            this.addSqlTableName(vs, tableName);
            vs.add(" set ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=? where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }

        @Override
        public String copyFileQuery(String sourceTableName, String targetTableName) {
            VarString vs = VarString.New();
            vs.add("insert into ");
            this.addSqlTableName(vs, targetTableName);
            vs.add(" (");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.DATA_COLUMN_NAME);
            vs.add(") select ?, ");
            this.addSqlColumnName(vs, SqlProvider.START_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.END_COLUMN_NAME);
            vs.add(", ");
            this.addSqlColumnName(vs, SqlProvider.DATA_COLUMN_NAME);
            vs.add(" from ");
            this.addSqlTableName(vs, sourceTableName);
            vs.add(" where ");
            this.addSqlColumnName(vs, SqlProvider.IDENTIFIER_COLUMN_NAME);
            vs.add("=?");
            return vs.toString();
        }
    }
}

