/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import one.microstream.X;
import one.microstream.afs.sql.types.SqlProvider;
import one.microstream.chars.VarString;

public interface SqlProviderOracle
extends SqlProvider {
    public static SqlProviderOracle New(DataSource dataSource) {
        return SqlProviderOracle.New(null, null, dataSource);
    }

    public static SqlProviderOracle New(String catalog, String schema, DataSource dataSource) {
        return new Default((String)X.mayNull((Object)catalog), (String)X.mayNull((Object)schema), (DataSource)X.notNull((Object)dataSource));
    }

    public static class Default
    extends SqlProvider.Abstract
    implements SqlProviderOracle {
        Default(String catalog, String schema, DataSource dataSource) {
            super(catalog, schema, dataSource);
        }

        @Override
        public Iterable<String> createDirectoryQueries(String tableName) {
            VarString vs = VarString.New();
            vs.add("create table ");
            this.addSqlTableName(vs, tableName);
            vs.add(" (");
            this.addSqlColumnName(vs, "identifier");
            vs.add(" varchar2(").add(255).add(") not null, ");
            this.addSqlColumnName(vs, "start");
            vs.add(" number(19) not null, ");
            this.addSqlColumnName(vs, "end");
            vs.add(" number(19) not null, ");
            this.addSqlColumnName(vs, "data");
            vs.add(" blob not null, constraint ");
            this.addNameQuoted(vs, tableName + "_pk");
            vs.add(" primary key (");
            this.addSqlColumnName(vs, "identifier");
            vs.add(", ");
            this.addSqlColumnName(vs, "start");
            vs.add("))");
            return Arrays.asList(vs.toString());
        }

        @Override
        public boolean queryDirectoryExists(Connection connection, String tableName) throws SQLException {
            try (PreparedStatement statement = connection.prepareStatement("SELECT COUNT(*) FROM user_tables WHERE table_name=?");){
                boolean bl;
                block12: {
                    statement.setString(1, tableName);
                    ResultSet result = statement.executeQuery();
                    try {
                        boolean bl2 = result.next() ? result.getLong(1) > 0L : (bl = false);
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return bl;
            }
        }

        @Override
        public Set<String> queryDirectories(Connection connection, String prefix) throws SQLException {
            HashSet<String> directories;
            block27: {
                directories = new HashSet<String>();
                if (prefix != null) {
                    try (PreparedStatement statement = connection.prepareStatement("SELECT table_name FROM user_tables WHERE table_name LIKE ?");){
                        statement.setString(1, prefix);
                        try (ResultSet result = statement.executeQuery();){
                            while (result.next()) {
                                directories.add(result.getString(1));
                            }
                            break block27;
                        }
                    }
                }
                try (Statement statement = connection.createStatement();
                     ResultSet result = statement.executeQuery("SELECT table_name FROM user_tables");){
                    while (result.next()) {
                        directories.add(result.getString(1));
                    }
                }
            }
            return directories;
        }
    }
}

