/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.sql.types;

import java.util.Arrays;
import javax.sql.DataSource;
import one.microstream.X;
import one.microstream.afs.sql.types.SqlProvider;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;

public interface SqlProviderPostgres
extends SqlProvider {
    public static SqlProviderPostgres New(DataSource dataSource) {
        return SqlProviderPostgres.New(null, null, dataSource);
    }

    public static SqlProviderPostgres New(String catalog, String schema, DataSource dataSource) {
        return new Default((String)X.mayNull((Object)catalog), (String)X.mayNull((Object)schema), (DataSource)X.notNull((Object)dataSource));
    }

    public static class Default
    extends SqlProvider.Abstract
    implements SqlProviderPostgres {
        Default(String catalog, String schema, DataSource dataSource) {
            super(catalog, schema, dataSource);
        }

        @Override
        protected VarString addSqlTableName(VarString vs, String tableName) {
            String schema = this.schema();
            if (!XChars.isEmpty((CharSequence)schema)) {
                this.addNameQuoted(vs, schema).add('.');
            }
            return super.addSqlTableName(vs, tableName);
        }

        @Override
        public Iterable<String> createDirectoryQueries(String tableName) {
            VarString vs = VarString.New();
            vs.add("create table ");
            this.addSqlTableName(vs, tableName);
            vs.add(" (");
            this.addSqlColumnName(vs, "identifier");
            vs.add(" character varying(").add(255).add(") not null, ");
            this.addSqlColumnName(vs, "start");
            vs.add(" bigint not null, ");
            this.addSqlColumnName(vs, "end");
            vs.add(" bigint not null, ");
            this.addSqlColumnName(vs, "data");
            vs.add(" bytea not null, constraint ");
            this.addNameQuoted(vs, tableName + "_pk");
            vs.add(" primary key (");
            this.addSqlColumnName(vs, "identifier");
            vs.add(", ");
            this.addSqlColumnName(vs, "start");
            vs.add("))");
            return Arrays.asList(vs.toString());
        }
    }
}

