/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import one.microstream.X;
import one.microstream.afs.exceptions.AfsExceptionUnresolvablePathElement;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AResolving;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.VarString;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingTable;
import one.microstream.functional.XFunc;
import one.microstream.typing.XTypes;

public interface ADirectory
extends AItem,
AResolving {
    @Override
    default public String toPathString() {
        return this.fileSystem().assemblePath(this);
    }

    @Override
    default public String[] toPath() {
        return this.fileSystem().buildPath(this);
    }

    public <R> R accessDirectories(Function<? super XGettingTable<String, ? extends ADirectory>, R> var1);

    public <R> R accessFiles(Function<? super XGettingTable<String, ? extends AFile>, R> var1);

    public <S, R> R accessDirectories(S var1, BiFunction<? super XGettingTable<String, ? extends ADirectory>, S, R> var2);

    public <S, R> R accessFiles(S var1, BiFunction<? super XGettingTable<String, ? extends AFile>, S, R> var2);

    public boolean registerObserver(Observer var1);

    public boolean removeObserver(Observer var1);

    public <C extends Consumer<? super Observer>> C iterateObservers(C var1);

    default public boolean ensureExists() {
        return this.fileSystem().ioHandler().ensureExists(this);
    }

    public ADirectory ensureDirectory(String var1);

    default public AFile ensureFile(String identifier) {
        return this.ensureFile(identifier, null, null);
    }

    default public AFile ensureFile(String name, String type) {
        return this.ensureFile(null, name, type);
    }

    public AFile ensureFile(String var1, String var2, String var3);

    public AItem getItem(String var1);

    public ADirectory getDirectory(String var1);

    public AFile getFile(String var1);

    public <C extends Consumer<? super AItem>> C iterateItems(C var1);

    public <C extends Consumer<? super ADirectory>> C iterateDirectories(C var1);

    public <C extends Consumer<? super AFile>> C iterateFiles(C var1);

    public ADirectory inventorize();

    default public XGettingEnum<AItem> listItems() {
        return AFS.listItems(this, XFunc.all());
    }

    default public XGettingEnum<ADirectory> listDirectories() {
        return AFS.listDirectories(this, XFunc.all());
    }

    default public XGettingEnum<AFile> listFiles() {
        return AFS.listFiles(this, XFunc.all());
    }

    public boolean contains(AItem var1);

    default public boolean contains(ADirectory directory) {
        return this.contains((AItem)directory);
    }

    default public boolean contains(AFile file) {
        return this.contains((AItem)file);
    }

    public boolean containsDeep(AItem var1);

    default public boolean containsDeep(ADirectory directory) {
        return this.containsDeep((AItem)directory);
    }

    default public boolean containsDeep(AFile file) {
        return this.containsDeep((AItem)file);
    }

    public boolean containsItem(String var1);

    public boolean containsDirectory(String var1);

    public boolean containsFile(String var1);

    @Override
    public ADirectory resolveDirectoryPath(String[] var1, int var2, int var3);

    @Override
    default public boolean exists() {
        return this.fileSystem().ioHandler().exists(this);
    }

    public int consolidate();

    public int consolidateDirectories();

    public int consolidateFiles();

    public static ADirectory New(ADirectory parent, String identifier) {
        return new Default((ADirectory)X.notNull((Object)parent), (String)X.notNull((Object)identifier));
    }

    public static ADirectory actual(ADirectory directory) {
        return directory instanceof Wrapper ? ((Wrapper)directory).actual() : directory;
    }

    public static abstract class Abstract
    extends AItem.Abstract
    implements ADirectory {
        private static final Observer[] NO_OBSERVERS = new Observer[0];
        private static final EqHashTable<String, Object> EMPTY = EqHashTable.NewCustom((int)0);
        private EqHashTable<String, ADirectory> directories = Abstract.emptyTable();
        private EqHashTable<String, AFile> files = Abstract.emptyTable();
        private Observer[] observers = NO_OBSERVERS;
        private boolean inventorized;

        static <T> EqHashTable<String, T> emptyTable() {
            return EMPTY;
        }

        protected Abstract(String identifier) {
            super(identifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final AItem getItem(String identifier) {
            Object object = this.mutex();
            synchronized (object) {
                AFile file = this.getFile(identifier);
                if (file != null) {
                    return file;
                }
                return this.getDirectory(identifier);
            }
        }

        private ADirectory internalGetDirectory(String identifier) {
            return (ADirectory)this.directories.get((Object)identifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ADirectory getDirectory(String identifier) {
            Object object = this.mutex();
            synchronized (object) {
                return this.internalGetDirectory(identifier);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final AFile getFile(String identifier) {
            Object object = this.mutex();
            synchronized (object) {
                return (AFile)this.files.get((Object)identifier);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ADirectory inventorize() {
            Object object = this.mutex();
            synchronized (object) {
                this.fileSystem().ioHandler().inventorize(this);
            }
            return this;
        }

        private void ensureInventorized() {
            if (this.inventorized) {
                return;
            }
            this.inventorize();
            this.inventorized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <C extends Consumer<? super AItem>> C iterateItems(C iterator) {
            Object object = this.mutex();
            synchronized (object) {
                this.iterateDirectories(iterator);
                this.iterateFiles(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super ADirectory>> C iterateDirectories(C iterator) {
            Object object = this.mutex();
            synchronized (object) {
                this.ensureInventorized();
                this.directories.values().iterate(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super AFile>> C iterateFiles(C iterator) {
            Object object = this.mutex();
            synchronized (object) {
                this.ensureInventorized();
                this.files.values().iterate(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int consolidate() {
            XGettingEnum<String> physicalItems;
            long count = 0L;
            Object object = this.mutex();
            synchronized (object) {
                physicalItems = this.fileSystem().ioHandler().listItems(this);
                count += this.directories.keys().removeBy(dirName -> !physicalItems.contains(dirName));
            }
            return XTypes.to_int((long)(count += this.files.keys().removeBy(fileName -> !physicalItems.contains(fileName))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int consolidateDirectories() {
            XGettingEnum<String> physicalDirectories;
            long count = 0L;
            Object object = this.mutex();
            synchronized (object) {
                physicalDirectories = this.fileSystem().ioHandler().listDirectories(this);
            }
            return XTypes.to_int((long)(count += this.directories.keys().removeBy(dirName -> !physicalDirectories.contains(dirName))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int consolidateFiles() {
            XGettingEnum<String> physicalFiles;
            long count = 0L;
            Object object = this.mutex();
            synchronized (object) {
                physicalFiles = this.fileSystem().ioHandler().listFiles(this);
            }
            return XTypes.to_int((long)(count += this.files.keys().removeBy(fileName -> !physicalFiles.contains(fileName))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean contains(AItem item) {
            Object object = this.mutex();
            synchronized (object) {
                return item.parent() == this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsDeep(AItem item) {
            Object object = this.mutex();
            synchronized (object) {
                AItem i = item;
                do {
                    if ((i = i.parent()) != null) continue;
                    return false;
                } while (i != this);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean containsItem(String itemName) {
            Object object = this.mutex();
            synchronized (object) {
                return this.containsFile(itemName) || this.containsDirectory(itemName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean containsDirectory(String directoryName) {
            Object object = this.mutex();
            synchronized (object) {
                return this.directories.get((Object)directoryName) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean containsFile(String fileName) {
            Object object = this.mutex();
            synchronized (object) {
                return this.files.get((Object)fileName) != null;
            }
        }

        private void register(String identifier, ADirectory directory) {
            if (this.directories == Abstract.emptyTable()) {
                this.directories = EqHashTable.New();
            }
            this.directories.add((Object)identifier, (Object)directory);
        }

        private void register(String identifier, AFile file) {
            if (this.files == Abstract.emptyTable()) {
                this.files = EqHashTable.New();
            }
            this.files.add((Object)identifier, (Object)file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ADirectory ensureDirectory(String identifier) {
            Object object = this.mutex();
            synchronized (object) {
                ADirectory directory = (ADirectory)this.directories.get((Object)identifier);
                if (directory == null) {
                    directory = this.fileSystem().creator().createDirectory(this, identifier);
                    this.register(identifier, directory);
                }
                return directory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final AFile ensureFile(String identifier, String name, String type) {
            String effIdnt;
            String effType;
            String effName;
            if (identifier == null) {
                effName = (String)X.notNull((Object)name);
                effType = (String)X.mayNull((Object)type);
                effIdnt = this.fileSystem().deriveFileIdentifier(name, type);
            } else {
                effIdnt = identifier;
                effName = name != null ? name : this.fileSystem().deriveFileName(identifier);
                effType = type != null ? type : this.fileSystem().deriveFileType(identifier);
            }
            Object object = this.mutex();
            synchronized (object) {
                AFile file = (AFile)this.files.get((Object)effIdnt);
                if (file == null) {
                    file = this.fileSystem().creator().createFile(this, effIdnt, effName, effType);
                    this.register(effIdnt, file);
                }
                return file;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ADirectory resolveDirectoryPath(String[] pathElements, int offset, int length) {
            if (length == 0) {
                return this;
            }
            XArrays.validateArrayRange((Object[])pathElements, (int)offset, (int)length);
            AFileSystem aFileSystem = this.fileSystem();
            synchronized (aFileSystem) {
                ADirectory currentDirectory = this;
                int o = offset;
                int l = length;
                while (l > 0) {
                    ADirectory resolvedChildDirectory = currentDirectory.getDirectory(pathElements[o]);
                    if (resolvedChildDirectory == null) {
                        throw new AfsExceptionUnresolvablePathElement(VarString.New().add("Unresolvable path element \"").add(pathElements[offset]).add("\" in path \"").addAll((Object[])pathElements, VarString::commaSpace).deleteLast(2).add('\"', '.').toString());
                    }
                    currentDirectory = resolvedChildDirectory;
                    ++o;
                    --l;
                }
                return currentDirectory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <R> R accessDirectories(Function<? super XGettingTable<String, ? extends ADirectory>, R> logic) {
            Object object = this.mutex();
            synchronized (object) {
                return logic.apply((XGettingTable<String, ADirectory>)this.directories);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <R> R accessFiles(Function<? super XGettingTable<String, ? extends AFile>, R> logic) {
            Object object = this.mutex();
            synchronized (object) {
                return logic.apply((XGettingTable<String, AFile>)this.files);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <S, R> R accessDirectories(S subject, BiFunction<? super XGettingTable<String, ? extends ADirectory>, S, R> logic) {
            Object object = this.mutex();
            synchronized (object) {
                return logic.apply((XGettingTable<String, ADirectory>)this.directories, subject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <S, R> R accessFiles(S subject, BiFunction<? super XGettingTable<String, ? extends AFile>, S, R> logic) {
            Object object = this.mutex();
            synchronized (object) {
                return logic.apply((XGettingTable<String, AFile>)this.files, subject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean registerObserver(Observer observer) {
            Object object = this.mutex();
            synchronized (object) {
                block6: {
                    block5: {
                        if (this.observers != NO_OBSERVERS) break block5;
                        this.observers = (Observer[])X.Array((Object)observer);
                        return true;
                    }
                    if (XArrays.contains((Object[])this.observers, (Object)observer)) break block6;
                    this.observers = (Observer[])XArrays.add((Object[])this.observers, (Object)observer);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean removeObserver(Observer observer) {
            Object object = this.mutex();
            synchronized (object) {
                block8: {
                    block7: {
                        block6: {
                            if (this.observers.length != 1 || this.observers[0] != observer) break block6;
                            this.observers = NO_OBSERVERS;
                            return true;
                        }
                        if (this.observers != NO_OBSERVERS) break block7;
                        return false;
                    }
                    int index = XArrays.indexOf((Object)observer, (Object[])this.observers);
                    if (index < 0) break block8;
                    XArrays.remove((Object[])this.observers, (int)index);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <C extends Consumer<? super Observer>> C iterateObservers(C logic) {
            Object object = this.mutex();
            synchronized (object) {
                return (C)XArrays.iterate((Object[])this.observers, logic);
            }
        }
    }

    public static class Default
    extends Abstract {
        private final ADirectory parent;

        protected Default(ADirectory parent, String identifier) {
            super(identifier);
            this.parent = parent;
        }

        @Override
        public final ADirectory parent() {
            return this.parent;
        }

        @Override
        public final AFileSystem fileSystem() {
            return this.parent.fileSystem();
        }
    }

    public static interface Observer {
        public void onBeforeFileCreate(AWritableFile var1);

        public void onAfterFileCreate(AWritableFile var1);

        public void onBeforeFileMove(AWritableFile var1, AWritableFile var2);

        public void onAfterFileMove(AWritableFile var1, AWritableFile var2);

        public void onBeforeFileDelete(AWritableFile var1);

        public void onAfterFileDelete(AWritableFile var1, boolean var2);

        public void onBeforeDirectoryCreate(ADirectory var1);

        public void onAfterDirectoryCreate(ADirectory var1);

        public void onBeforeDirectoryMove(ADirectory var1, ADirectory var2);

        public void onAfterDirectoryMove(ADirectory var1, ADirectory var2);

        public void onBeforeDirectoryDelete(ADirectory var1);

        public void onAfterDirectoryDelete(ADirectory var1, boolean var2);
    }

    public static interface Wrapper
    extends ADirectory,
    AItem.Wrapper {
        @Override
        public ADirectory actual();
    }
}

